/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.CoreSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;

public class CoreSpheroidType
extends SpheroidType {
    private final class_2680 coreBlock;
    private final LinkedHashMap<class_2680, Float> shellBlockStates;
    private final int minCoreRadius;
    private final int maxCoreRadius;

    public CoreSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 coreBlock, final class_2680 shellBlock, int minCoreRadius, int maxCoreRadius) {
        this(spheroidAdvancementIdentifier, minRadius, maxRadius, coreBlock, new LinkedHashMap<class_2680, Float>(){
            {
                this.put(shellBlock, Float.valueOf(1.0f));
            }
        }, minCoreRadius, maxCoreRadius);
    }

    public CoreSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 coreBlock, LinkedHashMap<class_2680, Float> shellBlockStates, int minCoreRadius, int maxCoreRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (coreBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("CoreSpheroidType: Registered a SpheroidType with null coreBlock!");
        }
        if (shellBlockStates == null || shellBlockStates.size() == 0) {
            StarrySkyCommon.LOGGER.error("CoreSpheroidType: Registered a SpheroidType with empty shellBlockStates!");
        }
        this.coreBlock = coreBlock;
        this.shellBlockStates = shellBlockStates;
        this.minCoreRadius = minCoreRadius;
        this.maxCoreRadius = maxCoreRadius;
    }

    @Override
    public String getDescription() {
        return "CoreSpheroid";
    }

    @Override
    public CoreSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int coreRadius = Support.getRandomBetween((Random)chunkRandom, this.minCoreRadius, this.maxCoreRadius);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 shellBlockState = Support.getWeightedRandom(this.shellBlockStates, (Random)chunkRandom);
        return new CoreSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.coreBlock, shellBlockState, coreRadius);
    }
}

