/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.DoubleCoreSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;

public class DoubleCoreSpheroidType
extends SpheroidType {
    private final class_2680 innerCoreBlock;
    private final class_2680 outerCoreBlock;
    private final LinkedHashMap<class_2680, Float> validShellBlocks;
    private final int minInnerCoreRadius;
    private final int maxInnerCoreRadius;
    private final int minShellRadius;
    private final int maxShellRadius;

    public DoubleCoreSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 innerCoreBlock, class_2680 outerCoreBlock, final class_2680 shellBlock, int minInnerCoreRadius, int maxInnerCoreRadius, int minShellRadius, int maxShellRadius) {
        this(spheroidAdvancementIdentifier, minRadius, maxRadius, innerCoreBlock, outerCoreBlock, new LinkedHashMap<class_2680, Float>(){
            {
                this.put(shellBlock, Float.valueOf(1.0f));
            }
        }, minInnerCoreRadius, maxInnerCoreRadius, minShellRadius, maxShellRadius);
    }

    public DoubleCoreSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 innerCoreBlock, class_2680 outerCoreBlock, LinkedHashMap<class_2680, Float> validShellBlocks, int minInnerCoreRadius, int maxInnerCoreRadius, int minShellRadius, int maxShellRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (innerCoreBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("DoubleCoreSpheroidType: Registered a SpheroidType with null innerCoreBlock!");
        }
        if (outerCoreBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("DoubleCoreSpheroidType: Registered a SpheroidType with null outerCoreBlock!");
        }
        if (validShellBlocks == null || validShellBlocks.size() == 0) {
            StarrySkyCommon.LOGGER.error("DoubleCoreSpheroidType: Registered a SpheroidType with empty validShellBlocks!");
        }
        this.innerCoreBlock = innerCoreBlock;
        this.outerCoreBlock = outerCoreBlock;
        this.validShellBlocks = validShellBlocks;
        this.minInnerCoreRadius = minInnerCoreRadius;
        this.maxInnerCoreRadius = maxInnerCoreRadius;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
    }

    @Override
    public String getDescription() {
        return "DoubleCoreSpheroid";
    }

    @Override
    public DoubleCoreSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        int innerCoreRadius = Support.getRandomBetween((Random)chunkRandom, this.minInnerCoreRadius, this.maxInnerCoreRadius);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 shellBlock = Support.getWeightedRandom(this.validShellBlocks, (Random)chunkRandom);
        return new DoubleCoreSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.innerCoreBlock, this.outerCoreBlock, shellBlock, innerCoreRadius, shellRadius);
    }
}

