/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.LiquidSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;

public class LiquidSpheroidType
extends SpheroidType {
    private final class_2680 liquid;
    private final LinkedHashMap<class_2680, Float> validShellBlocks;
    private final int minShellRadius;
    private final int maxShellRadius;
    private final int minFillPercent;
    private final int maxFillPercent;
    private final int holeInBottomPercent;
    private class_2680 coreBlock;
    private int minCoreRadius;
    private int maxCoreRadius;

    public LiquidSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 liquid, final class_2680 shellBlock, int minShellRadius, int maxShellRadius, int minFillPercent, int maxFillPercent, int holeInBottomPercent) {
        this(spheroidAdvancementIdentifier, minRadius, maxRadius, liquid, new LinkedHashMap<class_2680, Float>(){
            {
                this.put(shellBlock, Float.valueOf(1.0f));
            }
        }, minShellRadius, maxShellRadius, minFillPercent, maxFillPercent, holeInBottomPercent);
    }

    public LiquidSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 liquid, LinkedHashMap<class_2680, Float> validShellBlocks, int minShellRadius, int maxShellRadius, int minFillPercent, int maxFillPercent, int holeInBottomPercent) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (liquid == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("LiquidSpheroidType: Registered a SpheroidType with null liquid!");
        }
        if (validShellBlocks == null || validShellBlocks.size() == 0) {
            StarrySkyCommon.LOGGER.error("LiquidSpheroidType: Registered a SpheroidType with empty validShellBlocks!");
        }
        this.liquid = liquid;
        this.validShellBlocks = validShellBlocks;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
        this.minFillPercent = minFillPercent;
        this.maxFillPercent = maxFillPercent;
        this.holeInBottomPercent = holeInBottomPercent;
    }

    @Override
    public String getDescription() {
        return "LiquidSpheroid";
    }

    public LiquidSpheroidType setCoreBlock(class_2680 coreBlock, int minCoreRadius, int maxCoreRadius) {
        this.coreBlock = coreBlock;
        this.minCoreRadius = minCoreRadius;
        this.maxCoreRadius = maxCoreRadius;
        return this;
    }

    @Override
    public LiquidSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int coreRadius = Support.getRandomBetween((Random)chunkRandom, this.minCoreRadius, this.maxCoreRadius);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        int fillPercent = Support.getRandomBetween((Random)chunkRandom, this.minFillPercent, this.maxFillPercent);
        boolean holeInBottom = chunkRandom.nextInt(100) < this.holeInBottomPercent;
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 shellBlock = Support.getWeightedRandom(this.validShellBlocks, (Random)chunkRandom);
        return new LiquidSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.liquid, shellBlock, shellRadius, fillPercent, holeInBottom, this.coreBlock, coreRadius);
    }
}

