/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.ModularSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_2960;

public class ModularSpheroidType
extends SpheroidType {
    private final class_2680 mainBlock;
    private class_2680 topBlock;
    private class_2680 bottomBlock;
    private class_2960 centerChestLootTable;

    public ModularSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 mainBlock) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (mainBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("ModularSpheroidType: Registered a SpheroidType with null mainBlock!");
        }
        this.mainBlock = mainBlock;
    }

    @Override
    public String getDescription() {
        return "ModularSpheroid";
    }

    public class_2680 getTopBlock() {
        return this.topBlock != null ? this.topBlock : this.mainBlock;
    }

    public class_2680 getBottomBlock() {
        return this.bottomBlock != null ? this.bottomBlock : this.mainBlock;
    }

    public ModularSpheroidType setTopBlockState(class_2680 state) {
        if (this.mainBlock == null) {
            StarrySkyCommon.LOGGER.error("ModularSpheroidType: Registered a SpheroidType with null mainBlock!");
        } else {
            this.topBlock = state;
        }
        return this;
    }

    public ModularSpheroidType setBottomBlockState(class_2680 state) {
        if (this.mainBlock == null) {
            StarrySkyCommon.LOGGER.error("ModularSpheroidType: Registered a SpheroidType with null mainBlock!");
        } else {
            this.bottomBlock = state;
        }
        return this;
    }

    public ModularSpheroidType addCenterChestWithLoot(class_2960 lootTable) {
        this.centerChestLootTable = lootTable;
        return this;
    }

    @Override
    public ModularSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 topBlock = this.getTopBlock();
        class_2680 bottomBlock = this.getBottomBlock();
        return new ModularSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.mainBlock, topBlock, bottomBlock, this.centerChestLootTable);
    }
}

