/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.RainbowSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import net.minecraft.class_2680;
import net.minecraft.class_2919;

public class RainbowSpheroidType
extends SpheroidType {
    private final ArrayList<class_2680> rainbowBlocks;

    public RainbowSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, ArrayList<class_2680> rainbowBlocks) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (rainbowBlocks == null || rainbowBlocks.size() == 0) {
            StarrySkyCommon.LOGGER.error("RainbowSpheroidType: Registered a SpheroidType with empty rainbowBlocks!");
        }
        this.rainbowBlocks = rainbowBlocks;
    }

    @Override
    public String getDescription() {
        return "RainbowSpheroid";
    }

    @Override
    public RainbowSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        return new RainbowSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.rainbowBlocks);
    }
}

