/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.ShellSpheroid;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2919;

public class ShellSpheroidType
extends SpheroidType {
    private final class_2680 coreBlock;
    private final LinkedHashMap<class_2680, Float> validShellBlocks;
    private final int minShellRadius;
    private final int maxShellRadius;
    private final LinkedHashMap<class_2680, Float> shellSpeckleBlockStates = new LinkedHashMap();

    public ShellSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 coreBlock, final class_2680 shellBlock, int minShellRadius, int maxShellRadius) {
        this(spheroidAdvancementIdentifier, minRadius, maxRadius, coreBlock, new LinkedHashMap<class_2680, Float>(){
            {
                this.put(shellBlock, Float.valueOf(1.0f));
            }
        }, minShellRadius, maxShellRadius);
    }

    public ShellSpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius, class_2680 coreBlock, LinkedHashMap<class_2680, Float> validShellBlocks, int minShellRadius, int maxShellRadius) {
        super(spheroidAdvancementIdentifier, minRadius, maxRadius);
        if (coreBlock == class_2246.field_10124.method_9564()) {
            StarrySkyCommon.LOGGER.error("ShellSpheroidType: Registered a SpheroidType with empty coreBlock!");
        }
        if (validShellBlocks == null || validShellBlocks.size() == 0) {
            StarrySkyCommon.LOGGER.error("ShellSpheroidType: Registered a SpheroidType with empty validShellBlocks!");
        }
        this.coreBlock = coreBlock;
        this.validShellBlocks = validShellBlocks;
        this.minShellRadius = minShellRadius;
        this.maxShellRadius = maxShellRadius;
    }

    public class_2680 getRandomShellBlock(class_2919 random) {
        return Support.getWeightedRandom(this.validShellBlocks, (Random)random);
    }

    public ShellSpheroidType addShellSpeckles(class_2680 blockState, Float weight) {
        this.shellSpeckleBlockStates.put(blockState, weight);
        return this;
    }

    @Override
    public String getDescription() {
        return "ShellSpheroid";
    }

    @Override
    public ShellSpheroid getRandomSpheroid(class_2919 chunkRandom) {
        int radius = this.getRandomRadius(chunkRandom);
        int shellRadius = Support.getRandomBetween((Random)chunkRandom, this.minShellRadius, this.maxShellRadius);
        ArrayList<SpheroidDecorator> spheroidDecorators = this.getSpheroidDecoratorsWithChance(chunkRandom);
        ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn = this.getRandomEntityTypesToSpawn(chunkRandom);
        class_2680 shellBlock = this.getRandomShellBlock(chunkRandom);
        return new ShellSpheroid(chunkRandom, this.spheroidAdvancementIdentifier, radius, spheroidDecorators, entityTypesToSpawn, this.coreBlock, shellBlock, shellRadius, this.shellSpeckleBlockStates);
    }
}

