/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.types;

import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2919;

public abstract class SpheroidType {
    protected SpheroidAdvancementIdentifier spheroidAdvancementIdentifier;
    protected int minRadius;
    protected int maxRadius;
    protected LinkedHashMap<SpheroidDecorator, Float> spheroidDecorators = new LinkedHashMap();
    protected LinkedHashMap<SpheroidEntitySpawnDefinition, Float> spawnableEntities = new LinkedHashMap();

    protected SpheroidType(SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int minRadius, int maxRadius) {
        this.spheroidAdvancementIdentifier = spheroidAdvancementIdentifier;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public int getRandomRadius(class_2919 random) {
        int randomInt = random.nextInt(this.maxRadius - this.minRadius + 1);
        return randomInt + this.minRadius;
    }

    public SpheroidType addDecorator(SpheroidDecorator spheroidDecorator, float decoratorChance) {
        this.spheroidDecorators.put(spheroidDecorator, Float.valueOf(decoratorChance));
        return this;
    }

    public SpheroidType addSpawn(SpheroidEntitySpawnDefinition entityType, float spawnChance) {
        this.spawnableEntities.put(entityType, Float.valueOf(spawnChance));
        return this;
    }

    public ArrayList<SpheroidDecorator> getSpheroidDecoratorsWithChance(class_2919 random) {
        ArrayList<SpheroidDecorator> resultingSpheroidDecorators = new ArrayList<SpheroidDecorator>();
        for (Map.Entry<SpheroidDecorator, Float> spheroidDecorator : this.spheroidDecorators.entrySet()) {
            if (!(random.nextFloat() < spheroidDecorator.getValue().floatValue())) continue;
            resultingSpheroidDecorators.add(spheroidDecorator.getKey());
        }
        return resultingSpheroidDecorators;
    }

    public abstract String getDescription();

    public SpheroidAdvancementIdentifier getSpheroidTypeIdentifier() {
        return this.spheroidAdvancementIdentifier;
    }

    public abstract Spheroid getRandomSpheroid(class_2919 var1);

    protected ArrayList<SpheroidEntitySpawnDefinition> getRandomEntityTypesToSpawn(class_2919 chunkRandom) {
        ArrayList<SpheroidEntitySpawnDefinition> entityTypes = new ArrayList<SpheroidEntitySpawnDefinition>();
        for (Map.Entry<SpheroidEntitySpawnDefinition, Float> spawnableEntitiy : this.spawnableEntities.entrySet()) {
            if (!(chunkRandom.nextFloat() < spawnableEntitiy.getValue().floatValue())) continue;
            entityTypes.add(spawnableEntitiy.getKey());
        }
        return entityTypes;
    }
}

