/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.tickratechanger;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.guichaguri.tickratechanger.TickrateChanger;
import me.guichaguri.tickratechanger.api.TickrateAPI;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameRules;

public class TickrateCommand
extends CommandBase {
    private final List<String> aliases = ImmutableList.of((Object)"ticks", (Object)"tickratechanger", (Object)"trc", (Object)"settickrate");
    private final List<String> suggestedTickrateValues = ImmutableList.of((Object)"20", (Object)"2.5", (Object)"5", (Object)"10", (Object)"15", (Object)"25", (Object)"35", (Object)"50", (Object)"100");

    public String func_71517_b() {
        return "tickrate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/tickrate [ticks per second] [all/server/client/playername]";
    }

    public int func_82362_a() {
        return 2;
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length < 1) {
            return null;
        }
        ArrayList<String> tab = new ArrayList<String>();
        if (args.length == 1) {
            tab.addAll(this.suggestedTickrateValues);
            float defaultTickrate = TickrateChanger.DEFAULT_TICKRATE;
            String defTickrate = Float.toString(defaultTickrate);
            if (defaultTickrate == (float)((int)defaultTickrate)) {
                defTickrate = Integer.toString((int)defaultTickrate);
            }
            if (!tab.contains(defTickrate)) {
                tab.add(0, defTickrate);
            }
            tab.add("setdefault");
            tab.add("setmap");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("setdefault") || args[0].equalsIgnoreCase("setmap")) {
                tab.addAll(this.suggestedTickrateValues);
                float defaultTickrate = TickrateChanger.DEFAULT_TICKRATE;
                String defTickrate = Float.toString(defaultTickrate);
                if (defaultTickrate == (float)((int)defaultTickrate)) {
                    defTickrate = Integer.toString((int)defaultTickrate);
                }
                if (!tab.contains(defTickrate)) {
                    tab.add(0, defTickrate);
                }
            } else {
                tab.add("all");
                tab.add("server");
                tab.add("client");
                for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                    tab.add(p.getDisplayNameString());
                }
            }
        } else if ((args.length == 3 || args.length == 4) && args[0].equalsIgnoreCase("setdefault")) {
            tab.add("--dontsave");
            tab.add("--dontupdate");
        } else if ((args.length == 3 || args.length == 4) && args[0].equalsIgnoreCase("setmap")) {
            tab.add("--dontupdate");
        }
        return tab;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        float ticksPerSecond;
        if (args.length < 1) {
            this.showInfo(server, sender);
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.showHelp(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("setdefault") && args.length > 1) {
            this.cmdSetDefault(sender, args);
            return;
        }
        if (args[0].equalsIgnoreCase("setmap") && args.length > 1) {
            this.cmdSetMap(sender, args);
            return;
        }
        try {
            ticksPerSecond = Float.parseFloat(args[0]);
        }
        catch (Exception ex) {
            TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.error", TextFormatting.DARK_RED, new Object[0]));
            TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate <ticks per second> [all/server/client/", TextFormatting.RED), TickrateCommand.c("playername", TextFormatting.RED, TextFormatting.ITALIC), TickrateCommand.c("]", TextFormatting.RED)});
            return;
        }
        if (args.length < 2 || args[1].equalsIgnoreCase("all")) {
            TickrateAPI.changeTickrate(ticksPerSecond);
            if (TickrateChanger.SHOW_MESSAGES) {
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.everything.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond)));
            }
        } else if (args[1].equalsIgnoreCase("client")) {
            TickrateAPI.changeClientTickrate(ticksPerSecond);
            if (TickrateChanger.SHOW_MESSAGES) {
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.client.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond)));
            }
        } else if (args[1].equalsIgnoreCase("server")) {
            TickrateAPI.changeServerTickrate(ticksPerSecond);
            if (TickrateChanger.SHOW_MESSAGES) {
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.server.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond)));
            }
        } else {
            EntityPlayerMP p = server.func_184103_al().func_152612_a(args[1]);
            if (p == null) {
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.player.error", TextFormatting.RED, new Object[0]));
                return;
            }
            TickrateAPI.changeClientTickrate((EntityPlayer)p, ticksPerSecond);
            if (TickrateChanger.SHOW_MESSAGES) {
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.player.success", TextFormatting.GREEN, p.getDisplayNameString(), Float.valueOf(ticksPerSecond)));
            }
        }
    }

    private void showInfo(MinecraftServer server, ICommandSender sender) {
        TickrateCommand.chat(sender, new ITextComponent[]{new TextComponentTranslation("tickratechanger.show.clientside", new Object[0])});
        TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.info.server", TextFormatting.WHITE, new Object[0]), TickrateCommand.t("tickratechanger.info.value", TextFormatting.GREEN, Float.valueOf(TickrateAPI.getServerTickrate())));
        try {
            GameRules rules = server.func_130014_f_().func_82736_K();
            if (rules.func_82765_e("tickrate")) {
                float tickrate = Float.parseFloat(rules.func_82767_a("tickrate"));
                TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.info.map", TextFormatting.WHITE, new Object[0]), TickrateCommand.t("tickratechanger.info.value", TextFormatting.GREEN, Float.valueOf(tickrate)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.info.default", TextFormatting.WHITE, new Object[0]), TickrateCommand.t("tickratechanger.info.value", TextFormatting.YELLOW, Float.valueOf(TickrateChanger.DEFAULT_TICKRATE)));
        TickrateCommand.chat(sender, new ITextComponent[0]);
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate <ticks per second> [all/server/client/", TextFormatting.AQUA), TickrateCommand.c("playername", TextFormatting.DARK_AQUA), TickrateCommand.c("]", TextFormatting.AQUA)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault <ticks per second> [--dontsave, --dontupdate]", TextFormatting.AQUA)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setmap <ticks per second> [--dontupdate]", TextFormatting.AQUA)});
        TickrateCommand.chat(sender, new ITextComponent[0]);
        TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.info.help", TextFormatting.RED, TextFormatting.WHITE + "/tickrate help" + TextFormatting.RED));
    }

    private void showHelp(ICommandSender sender) {
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c(" * * Tickrate Changer * * ", TextFormatting.DARK_PURPLE, TextFormatting.BOLD), TickrateCommand.c("by ", TextFormatting.GRAY, TextFormatting.ITALIC), TickrateCommand.c("Guichaguri", TextFormatting.WHITE, TextFormatting.ITALIC)});
        TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.help.desc", TextFormatting.GREEN, new Object[0]));
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate 20", TickrateCommand.t("tickratechanger.help.command.1", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate 20 server", TickrateCommand.t("tickratechanger.help.command.2", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate 20 client", TickrateCommand.t("tickratechanger.help.command.3", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate 20 Notch", TickrateCommand.t("tickratechanger.help.command.4", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault 20", TickrateCommand.t("tickratechanger.help.command.5", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault 20 --dontsave", TickrateCommand.t("tickratechanger.help.command.6", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault 20 --dontupdate", TickrateCommand.t("tickratechanger.help.command.7", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault 20 --dontsave --dontupdate", TickrateCommand.t("tickratechanger.help.command.8", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setmap 20", TickrateCommand.t("tickratechanger.help.command.9", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setmap 20 --dontupdate", TickrateCommand.t("tickratechanger.help.command.10", TextFormatting.GREEN, new Object[0]), TextFormatting.GRAY)});
        TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c(" * * * * * * * * * * * * * * ", TextFormatting.DARK_PURPLE, TextFormatting.BOLD)});
    }

    private void cmdSetDefault(ICommandSender sender, String[] args) {
        float ticksPerSecond;
        boolean save = true;
        boolean update = true;
        for (String s : args) {
            if (s.equalsIgnoreCase("--dontsave")) {
                save = false;
            }
            if (!s.equalsIgnoreCase("--dontupdate")) continue;
            update = false;
        }
        try {
            ticksPerSecond = Float.parseFloat(args[1]);
        }
        catch (Exception ex) {
            TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.error", TextFormatting.DARK_RED, new Object[0]));
            TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setdefault <ticks per second> [--dontsave, --dontupdate]", TextFormatting.RED)});
            return;
        }
        TickrateAPI.changeDefaultTickrate(ticksPerSecond, save);
        if (update) {
            TickrateAPI.changeTickrate(ticksPerSecond);
        }
        if (TickrateChanger.SHOW_MESSAGES) {
            TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.default.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond)));
        }
    }

    private void cmdSetMap(ICommandSender sender, String[] args) {
        float ticksPerSecond;
        boolean update = true;
        for (String s : args) {
            if (!s.equalsIgnoreCase("--dontupdate")) continue;
            update = false;
        }
        try {
            ticksPerSecond = Float.parseFloat(args[1]);
        }
        catch (Exception ex) {
            TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.error", TextFormatting.DARK_RED, new Object[0]));
            TickrateCommand.chat(sender, new ITextComponent[]{TickrateCommand.c("/tickrate setmap <ticks per second> [--dontupdate]", TextFormatting.RED)});
            return;
        }
        TickrateAPI.changeMapTickrate(ticksPerSecond);
        if (update) {
            TickrateAPI.changeTickrate(ticksPerSecond);
        }
        if (TickrateChanger.SHOW_MESSAGES) {
            TickrateCommand.chat(sender, TickrateCommand.t("tickratechanger.cmd.map.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond)));
        }
    }

    protected static ITextComponent clientTickrateMsg() {
        TextComponentString msg = new TextComponentString("");
        msg.func_150257_a(TickrateCommand.t("tickratechanger.info.client", TextFormatting.WHITE, new Object[0]));
        msg.func_150258_a(" ");
        msg.func_150257_a(TickrateCommand.t("tickratechanger.info.value", TextFormatting.GREEN, Float.valueOf(TickrateAPI.getClientTickrate())));
        return msg;
    }

    protected static ITextComponent successTickrateMsg(float ticksPerSecond) {
        return TickrateCommand.t("tickratechanger.cmd.everything.success", TextFormatting.GREEN, Float.valueOf(ticksPerSecond));
    }

    private static void chat(ICommandSender sender, ITextComponent ... comps) {
        ITextComponent top;
        if (comps.length == 1) {
            top = comps[0];
        } else {
            top = new TextComponentString("");
            for (ITextComponent c : comps) {
                top.func_150257_a(c);
                top.func_150258_a(" ");
            }
        }
        sender.func_145747_a(top);
    }

    private static ITextComponent t(String langKey, TextFormatting formatting, Object ... data) {
        TextComponentTranslation comp = new TextComponentTranslation(langKey, data);
        comp.func_150255_a(comp.func_150256_b().func_150238_a(formatting));
        return comp;
    }

    private static TextComponentString c(String s, ITextComponent hover, TextFormatting ... formattings) {
        TextComponentString txt = TickrateCommand.c(s, formattings);
        txt.func_150255_a(txt.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hover)));
        return txt;
    }

    private static TextComponentString c(String s, TextFormatting ... formattings) {
        TextComponentString comp = new TextComponentString(s);
        Style style = comp.func_150256_b();
        for (TextFormatting f : formattings) {
            if (f == TextFormatting.BOLD) {
                style.func_150227_a(Boolean.valueOf(true));
                continue;
            }
            if (f == TextFormatting.ITALIC) {
                style.func_150217_b(Boolean.valueOf(true));
                continue;
            }
            if (f == TextFormatting.UNDERLINE) {
                style.func_150228_d(Boolean.valueOf(true));
                continue;
            }
            style.func_150238_a(f);
        }
        comp.func_150255_a(style);
        return comp;
    }
}

