/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.tickratechanger;

import me.guichaguri.tickratechanger.TickrateChanger;
import me.guichaguri.tickratechanger.TickrateCommand;
import me.guichaguri.tickratechanger.TickrateMessageHandler;
import me.guichaguri.tickratechanger.api.TickrateAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameRules;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="tickratechanger", name="Tickrate Changer", version="1.0.14", acceptedMinecraftVersions="[1.12.2]")
public class TickrateContainer {
    public static boolean KEYS_AVAILABLE = false;
    public static KeyBinding KEY_5 = null;
    public static KeyBinding KEY_10 = null;
    public static KeyBinding KEY_15 = null;
    public static KeyBinding KEY_20 = null;
    public static KeyBinding KEY_40 = null;
    public static KeyBinding KEY_60 = null;
    public static KeyBinding KEY_100 = null;
    private long lastKeyInputTime = 0L;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TickrateChanger.NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("TickrateChanger");
        TickrateChanger.NETWORK.registerMessage(TickrateMessageHandler.class, TickrateMessageHandler.TickrateMessage.class, 0, Side.CLIENT);
        TickrateChanger.NETWORK.registerMessage(TickrateMessageHandler.class, TickrateMessageHandler.TickrateMessage.class, 1, Side.SERVER);
        TickrateChanger.CONFIG_FILE = event.getSuggestedConfigurationFile();
        Configuration cfg = new Configuration(TickrateChanger.CONFIG_FILE);
        TickrateChanger.DEFAULT_TICKRATE = (float)cfg.get("default", "tickrate", 20.0, "Default tickrate. The game will always initialize with this value.").getDouble(20.0);
        TickrateChanger.MIN_TICKRATE = (float)cfg.get("minimum", "tickrate", 0.1, "Minimum tickrate from servers. Prevents really low tickrate values.").getDouble(0.1);
        TickrateChanger.MAX_TICKRATE = (float)cfg.get("maximum", "tickrate", 1000, "Maximum tickrate from servers. Prevents really high tickrate values.").getDouble(1000.0);
        TickrateChanger.SHOW_MESSAGES = cfg.get("miscellaneous", "show-messages", true, "Whether it will show log messages in the console and the game").getBoolean(true);
        TickrateChanger.CHANGE_SOUND = cfg.get("miscellaneous", "change-sound", true, "Whether it will change the sound speed").getBoolean();
        KEYS_AVAILABLE = cfg.get("miscellaneous", "keybindings", false, "Whether it will have special keys for setting the tickrate").getBoolean(false);
        if (KEYS_AVAILABLE) {
            KEY_5 = new KeyBinding("tickratechanger.keybinding.5", 0, "key.categories.misc");
            KEY_10 = new KeyBinding("tickratechanger.keybinding.10", 0, "key.categories.misc");
            KEY_15 = new KeyBinding("tickratechanger.keybinding.15", 0, "key.categories.misc");
            KEY_20 = new KeyBinding("tickratechanger.keybinding.20", 0, "key.categories.misc");
            KEY_40 = new KeyBinding("tickratechanger.keybinding.40", 0, "key.categories.misc");
            KEY_60 = new KeyBinding("tickratechanger.keybinding.60", 0, "key.categories.misc");
            KEY_100 = new KeyBinding("tickratechanger.keybinding.100", 0, "key.categories.misc");
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_5);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_10);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_15);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_20);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_40);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_60);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_100);
        }
        cfg.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TickrateAPI.changeTickrate(TickrateChanger.DEFAULT_TICKRATE);
    }

    @Mod.EventHandler
    public void start(FMLServerStartingEvent event) {
        TickrateChanger.COMMAND = new TickrateCommand();
        event.registerServerCommand((ICommand)TickrateChanger.COMMAND);
    }

    @Mod.EventHandler
    public void imc(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            if (!msg.key.equalsIgnoreCase("tickrate")) continue;
            try {
                TickrateAPI.processIMC(msg);
            }
            catch (Exception exception) {}
        }
    }

    @SubscribeEvent
    public void chat(ClientChatReceivedEvent event) {
        TextComponentTranslation t;
        ITextComponent message = event.getMessage();
        if (message instanceof TextComponentTranslation && (t = (TextComponentTranslation)message).func_150268_i().equals("tickratechanger.show.clientside")) {
            event.setMessage(TickrateCommand.clientTickrateMsg());
        }
    }

    @SubscribeEvent
    public void disconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        TickrateAPI.changeServerTickrate(TickrateChanger.DEFAULT_TICKRATE);
        TickrateAPI.changeClientTickrate(null, TickrateChanger.DEFAULT_TICKRATE);
    }

    @SubscribeEvent
    public void connect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (event.isLocal()) {
            float tickrate = TickrateChanger.DEFAULT_TICKRATE;
            try {
                GameRules rules;
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server != null && (rules = server.func_130014_f_().func_82736_K()).func_82765_e("tickrate")) {
                    tickrate = Float.parseFloat(rules.func_82767_a("tickrate"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            TickrateAPI.changeServerTickrate(tickrate);
            TickrateAPI.changeClientTickrate(null, tickrate);
        } else {
            TickrateAPI.changeClientTickrate(null, 20.0f);
        }
    }

    @SubscribeEvent
    public void connect(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            float tickrate = TickrateChanger.DEFAULT_TICKRATE;
            try {
                GameRules rules;
                MinecraftServer server = event.player.func_184102_h();
                if (server != null && (rules = server.func_130014_f_().func_82736_K()).func_82765_e("tickrate")) {
                    tickrate = Float.parseFloat(rules.func_82767_a("tickrate"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            TickrateAPI.changeClientTickrate(event.player, tickrate);
        }
    }

    @SubscribeEvent
    public void key(InputEvent.KeyInputEvent event) {
        float tickrate;
        if (!KEYS_AVAILABLE) {
            return;
        }
        if (KEY_5.func_151468_f()) {
            tickrate = 5.0f;
        } else if (KEY_10.func_151468_f()) {
            tickrate = 10.0f;
        } else if (KEY_15.func_151468_f()) {
            tickrate = 15.0f;
        } else if (KEY_20.func_151468_f()) {
            tickrate = 20.0f;
        } else if (KEY_40.func_151468_f()) {
            tickrate = 40.0f;
        } else if (KEY_60.func_151468_f()) {
            tickrate = 60.0f;
        } else if (KEY_100.func_151468_f()) {
            tickrate = 100.0f;
        } else {
            return;
        }
        if (this.lastKeyInputTime > Minecraft.func_71386_F() - 100L) {
            return;
        }
        this.lastKeyInputTime = Minecraft.func_71386_F();
        TickrateChanger.NETWORK.sendToServer((IMessage)new TickrateMessageHandler.TickrateMessage(tickrate));
    }
}

