/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.tickratechanger;

import io.netty.buffer.ByteBuf;
import me.guichaguri.tickratechanger.TickrateChanger;
import me.guichaguri.tickratechanger.TickrateCommand;
import me.guichaguri.tickratechanger.api.TickrateAPI;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TickrateMessageHandler
implements IMessageHandler<TickrateMessage, IMessage> {
    public IMessage onMessage(TickrateMessage msg, MessageContext context) {
        EntityPlayerMP player;
        if (context.side == Side.SERVER && !TickrateChanger.COMMAND.func_184882_a(player.field_71133_b, (ICommandSender)(player = context.getServerHandler().field_147369_b))) {
            return null;
        }
        float tickrate = msg.getTickrate();
        if (tickrate < TickrateChanger.MIN_TICKRATE) {
            TickrateChanger.LOGGER.info("Tickrate forced to change from " + tickrate + " to " + TickrateChanger.MIN_TICKRATE + ", because the value is too low (You can change the minimum tickrate in the config file)");
            tickrate = TickrateChanger.MIN_TICKRATE;
        } else if (tickrate > TickrateChanger.MAX_TICKRATE) {
            TickrateChanger.LOGGER.info("Tickrate forced to change from " + tickrate + " to " + TickrateChanger.MAX_TICKRATE + ", because the value is too high (You can change the maximum tickrate in the config file)");
            tickrate = TickrateChanger.MAX_TICKRATE;
        }
        if (context.side == Side.CLIENT) {
            TickrateChanger.INSTANCE.updateClientTickrate(tickrate, TickrateChanger.SHOW_MESSAGES);
        } else {
            TickrateAPI.changeTickrate(tickrate, TickrateChanger.SHOW_MESSAGES);
            if (TickrateChanger.SHOW_MESSAGES) {
                context.getServerHandler().field_147369_b.func_145747_a(TickrateCommand.successTickrateMsg(tickrate));
            }
        }
        return null;
    }

    public static class TickrateMessage
    implements IMessage {
        private float tickrate;

        public TickrateMessage() {
        }

        public TickrateMessage(float tickrate) {
            this.tickrate = tickrate;
        }

        public float getTickrate() {
            return this.tickrate;
        }

        public void fromBytes(ByteBuf buf) {
            this.tickrate = buf.readFloat();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeFloat(this.tickrate);
        }
    }
}

