/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.tickratechanger;

import me.guichaguri.tickratechanger.TickrateChanger;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TickrateTransformer
implements IClassTransformer {
    public byte[] transform(String name, String name2, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            if (name.equals("net.minecraft.server.MinecraftServer")) {
                return this.patchServerTickrate(bytes);
            }
            if (name.equals("paulscode.sound.SoundSystem")) {
                return this.patchSoundSystem(bytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public byte[] patchServerTickrate(byte[] bytes) {
        TickrateChanger.LOGGER.info("Applying ASM to Minecraft methods...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("run") || !method.desc.equals("()V")) continue;
            InsnList list = new InsnList();
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node instanceof LdcInsnNode) {
                    LdcInsnNode ldcNode = (LdcInsnNode)node;
                    if (ldcNode.cst instanceof Long && (Long)ldcNode.cst == 50L) {
                        list.add((AbstractInsnNode)new FieldInsnNode(178, "me/guichaguri/tickratechanger/TickrateChanger", "MILISECONDS_PER_TICK", "J"));
                        continue;
                    }
                }
                list.add(node);
            }
            method.instructions.clear();
            method.instructions.add(list);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public byte[] patchSoundSystem(byte[] bytes) {
        TickrateChanger.LOGGER.info("Patching sound system...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("setPitch") || !method.desc.equals("(Ljava/lang/String;F)V")) continue;
            InsnList inst = new InsnList();
            inst.add((AbstractInsnNode)new VarInsnNode(23, 2));
            inst.add((AbstractInsnNode)new FieldInsnNode(178, "me/guichaguri/tickratechanger/TickrateChanger", "GAME_SPEED", "F"));
            inst.add((AbstractInsnNode)new InsnNode(106));
            inst.add((AbstractInsnNode)new VarInsnNode(56, 2));
            inst.add(method.instructions);
            method.instructions = inst;
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

