/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.tickratechanger.api;

import me.guichaguri.tickratechanger.TickrateChanger;
import me.guichaguri.tickratechanger.TickrateMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class TickrateAPI {
    public static void changeTickrate(float ticksPerSecond) {
        TickrateAPI.changeTickrate(ticksPerSecond, TickrateChanger.SHOW_MESSAGES);
    }

    public static void changeTickrate(float ticksPerSecond, boolean log) {
        TickrateAPI.changeServerTickrate(ticksPerSecond, log);
        TickrateAPI.changeClientTickrate(ticksPerSecond, log);
    }

    public static void changeServerTickrate(float ticksPerSecond) {
        TickrateAPI.changeServerTickrate(ticksPerSecond, TickrateChanger.SHOW_MESSAGES);
    }

    public static void changeServerTickrate(float ticksPerSecond, boolean log) {
        TickrateChanger.INSTANCE.updateServerTickrate(ticksPerSecond, log);
    }

    public static void changeClientTickrate(float ticksPerSecond) {
        TickrateAPI.changeClientTickrate(ticksPerSecond, TickrateChanger.SHOW_MESSAGES);
    }

    public static void changeClientTickrate(float ticksPerSecond, boolean log) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && server.func_184103_al() != null) {
            for (EntityPlayerMP p : server.func_184103_al().func_181057_v()) {
                TickrateAPI.changeClientTickrate((EntityPlayer)p, ticksPerSecond, log);
            }
        } else {
            TickrateAPI.changeClientTickrate(null, ticksPerSecond, log);
        }
    }

    public static void changeClientTickrate(EntityPlayer player, float ticksPerSecond) {
        TickrateAPI.changeClientTickrate(player, ticksPerSecond, TickrateChanger.SHOW_MESSAGES);
    }

    public static void changeClientTickrate(EntityPlayer player, float ticksPerSecond, boolean log) {
        if (player == null || player.field_70170_p.field_72995_K) {
            if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
                return;
            }
            if (player != null && player != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            TickrateChanger.INSTANCE.updateClientTickrate(ticksPerSecond, log);
        } else {
            TickrateChanger.NETWORK.sendTo((IMessage)new TickrateMessageHandler.TickrateMessage(ticksPerSecond), (EntityPlayerMP)player);
        }
    }

    public static void changeDefaultTickrate(float ticksPerSecond, boolean save) {
        TickrateChanger.DEFAULT_TICKRATE = ticksPerSecond;
        if (save) {
            Configuration cfg = new Configuration(TickrateChanger.CONFIG_FILE);
            cfg.get("default", "tickrate", 20.0, "Default tickrate. The game will always initialize with this value.").set((double)ticksPerSecond);
            cfg.save();
        }
    }

    public static void changeMapTickrate(float ticksPerSecond) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        World world = server.func_130014_f_();
        world.func_82736_K().func_82764_b("tickrate", ticksPerSecond + "");
    }

    public static float getServerTickrate() {
        return 1000.0f / (float)TickrateChanger.MILISECONDS_PER_TICK;
    }

    public static float getClientTickrate() {
        return TickrateChanger.TICKS_PER_SECOND;
    }

    public static float getMapTickrate() {
        GameRules rules = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_82736_K();
        if (rules.func_82765_e("tickrate")) {
            return Float.parseFloat(rules.func_82767_a("tickrate"));
        }
        return TickrateAPI.getServerTickrate();
    }

    @Deprecated
    public static boolean isValidTickrate(float ticksPerSecond) {
        return true;
    }

    public static void processIMC(FMLInterModComms.IMCMessage msg) {
        float tickrate;
        String type;
        String player = null;
        boolean save = false;
        if (msg.isNBTMessage()) {
            NBTTagCompound nbt = msg.getNBTValue();
            type = nbt.func_74764_b("type") ? nbt.func_74779_i("type") : "all";
            tickrate = nbt.func_74764_b("tickrate") ? nbt.func_74760_g("tickrate") : TickrateChanger.DEFAULT_TICKRATE;
            player = nbt.func_74764_b("player") ? nbt.func_74779_i("player") : null;
            save = nbt.func_74764_b("save") && nbt.func_74767_n("save");
        } else if (msg.isStringMessage()) {
            type = "all";
            tickrate = Float.parseFloat(msg.getStringValue());
        } else {
            return;
        }
        if (type.equalsIgnoreCase("client")) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (player != null && server != null && server.func_184103_al() != null) {
                EntityPlayerMP pl = server.func_184103_al().func_152612_a(player);
                TickrateAPI.changeClientTickrate((EntityPlayer)pl, tickrate, false);
            } else {
                TickrateAPI.changeClientTickrate(tickrate, false);
            }
        } else if (type.equalsIgnoreCase("server")) {
            TickrateAPI.changeServerTickrate(tickrate, false);
        } else if (type.equalsIgnoreCase("map")) {
            TickrateAPI.changeMapTickrate(tickrate);
        } else if (type.equalsIgnoreCase("default")) {
            TickrateAPI.changeDefaultTickrate(tickrate, save);
        } else {
            TickrateAPI.changeTickrate(tickrate, false);
        }
    }
}

