/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.display.BarDisplay;
import net.torocraft.torohealth.display.EntityDisplay;

public class Hud
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("torohealth:textures/gui/default_skin_basic.png");
    private EntityDisplay entityDisplay = new EntityDisplay();
    private class_1309 entity;
    private BarDisplay barDisplay;
    private Config config = new Config();
    private int age;

    public Hud() {
        super((class_2561)new class_2585("ToroHealth HUD"));
        this.field_22787 = class_310.method_1551();
        this.barDisplay = new BarDisplay(class_310.method_1551(), (class_332)this);
    }

    public void draw(class_4587 matrix, Config config) {
        if (this.field_22787.field_1690.field_1866) {
            return;
        }
        this.config = config;
        if (this.config == null) {
            this.config = new Config();
        }
        float x = this.determineX();
        float y = this.determineY();
        this.draw(matrix, x, y, config.hud.scale);
    }

    private float determineX() {
        float x = this.config.hud.x;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        float wScreen = this.field_22787.method_22683().method_4486();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return wScreen / 2.0f + x;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return wScreen + x;
            }
        }
        return x;
    }

    private float determineY() {
        float y = this.config.hud.y;
        Config.AnchorPoint anchor = this.config.hud.anchorPoint;
        float hScreen = this.field_22787.method_22683().method_4502();
        switch (anchor) {
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                return y + hScreen;
            }
        }
        return y;
    }

    public void method_25393() {
        ++this.age;
    }

    public void setEntity(class_1309 entity) {
        if (entity != null) {
            this.age = 0;
        }
        if (entity == null && this.age > this.config.hud.hideDelay) {
            this.setEntityWork(null);
        }
        if (entity != null && entity != this.entity) {
            this.setEntityWork(entity);
        }
    }

    private void setEntityWork(class_1309 entity) {
        this.entity = entity;
        this.entityDisplay.setEntity(entity);
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    private void draw(class_4587 matrix, float x, float y, float scale) {
        if (this.entity == null) {
            return;
        }
        if (this.config.hud.onlyWhenHurt && this.entity.method_6032() >= this.entity.method_6063()) {
            return;
        }
        matrix.method_22903();
        matrix.method_22905(scale, scale, scale);
        matrix.method_22904((double)(x - 10.0f), (double)(y - 10.0f), 0.0);
        if (this.config.hud.showSkin) {
            this.drawSkin(matrix);
        }
        matrix.method_22904(10.0, 10.0, 0.0);
        if (this.config.hud.showEntity) {
            this.entityDisplay.draw(matrix, scale);
        }
        matrix.method_22904(44.0, 0.0, 0.0);
        if (this.config.hud.showBar) {
            this.barDisplay.draw(matrix, this.entity);
        }
        matrix.method_22909();
    }

    private void drawSkin(class_4587 matrix) {
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int w = 160;
        int h = 60;
        Hud.method_25290((class_4587)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
    }
}

