/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.torocraft.torohealth.bars.BarParticle;
import net.torocraft.torohealth.bars.BarState;

public class BarStates {
    private static final Map<Integer, BarState> STATES = new HashMap<Integer, BarState>();
    public static List<BarParticle> PARTICLES = new ArrayList<BarParticle>();
    private static int tickCount = 0;

    public static BarState getState(LivingEntity entity) {
        int id = entity.m_19879_();
        BarState state = STATES.get(id);
        if (state == null) {
            state = new BarState(entity);
            STATES.put(id, state);
        }
        return state;
    }

    public static void tick() {
        for (BarState state : STATES.values()) {
            state.tick();
        }
        if (tickCount % 200 == 0) {
            BarStates.cleanCache();
        }
        PARTICLES.forEach(p -> p.tick());
        PARTICLES.removeIf(p -> p.age > 50);
        ++tickCount;
    }

    private static void cleanCache() {
        STATES.entrySet().removeIf(BarStates::stateExpired);
    }

    private static boolean stateExpired(Map.Entry<Integer, BarState> entry) {
        if (entry.getValue() == null) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91073_.m_6815_(entry.getKey().intValue());
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (!minecraft.f_91073_.m_46805_(entity.m_20183_())) {
            return true;
        }
        return !entity.m_6084_();
    }
}

