/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBlockEntityScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.CombinedInvWrapper;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.RangedWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.InventoryUtils;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3908;
import net.minecraft.class_5431;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBlockEntity
extends class_2586
implements ITravelersBackpackInventory,
BlockEntityClientSerializable,
class_1275 {
    public InventoryImproved inventory = this.createInventory(Tiers.LEATHER.getAllSlots());
    public InventoryImproved craftingInventory = this.createInventory(9);
    private InventoryImproved fluidSlots = this.createTemporaryInventory();
    public SingleVariantStorage<FluidVariant> leftTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    public SingleVariantStorage<FluidVariant> rightTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private class_1657 player = null;
    private boolean isSleepingBagDeployed = false;
    private int color = 0;
    private int sleepingBagColor = class_1767.field_7964.method_7789();
    private Tiers.Tier tier = Tiers.LEATHER;
    private boolean ability = false;
    private int lastTime = 0;
    private class_2561 customName = null;
    private final String LEFT_TANK = "LeftTank";
    private final String LEFT_TANK_AMOUNT = "LeftTankAmount";
    private final String RIGHT_TANK = "RightTank";
    private final String RIGHT_TANK_AMOUNT = "RightTankAmount";
    private final String SLEEPING_BAG = "SleepingBag";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";
    private final String CUSTOM_NAME = "CustomName";

    public TravelersBackpackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.readAllData(nbt);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.writeAllData(tag);
        return tag;
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public InventoryImproved getFluidSlotsInventory() {
        return this.fluidSlots;
    }

    @Override
    public class_1263 getCombinedInventory() {
        RangedWrapper additional = null;
        if (this.tier != Tiers.LEATHER) {
            additional = new RangedWrapper(this, this.getInventory(), 0, this.tier.getStorageSlots() - 18);
        }
        if (additional != null) {
            return new CombinedInvWrapper(this, additional, new RangedWrapper(this, this.getInventory(), additional.method_5439(), additional.method_5439() + 6), new RangedWrapper(this, this.getCraftingGridInventory(), 0, 3), new RangedWrapper(this, this.getInventory(), additional.method_5439() + 6, additional.method_5439() + 12), new RangedWrapper(this, this.getCraftingGridInventory(), 3, 6), new RangedWrapper(this, this.getInventory(), additional.method_5439() + 12, additional.method_5439() + 18), new RangedWrapper(this, this.getCraftingGridInventory(), 6, 9));
        }
        return new CombinedInvWrapper(this, new RangedWrapper(this, this.getInventory(), 0, 6), new RangedWrapper(this, this.getCraftingGridInventory(), 0, 3), new RangedWrapper(this, this.getInventory(), 6, 12), new RangedWrapper(this, this.getCraftingGridInventory(), 3, 6), new RangedWrapper(this, this.getInventory(), 12, 18), new RangedWrapper(this, this.getCraftingGridInventory(), 6, 9));
    }

    @Override
    public SingleVariantStorage<FluidVariant> getLeftTank() {
        return this.leftTank;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getRightTank() {
        return this.rightTank;
    }

    public void writeTier(class_2487 compound) {
        compound.method_10569("Tier", this.tier.getOrdinal());
    }

    public void readTier(class_2487 compound) {
        if (compound.method_10573("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.method_10558("Tier"));
            compound.method_10551("Tier");
            compound.method_10569("Tier", tier.getOrdinal());
        }
        this.tier = compound.method_10545("Tier") ? Tiers.of(compound.method_10550("Tier")) : (TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER : Tiers.DIAMOND);
    }

    @Override
    public void writeItems(class_2487 compound) {
        InventoryUtils.writeNbt(compound, this.inventory.getStacks(), true, false);
        InventoryUtils.writeNbt(compound, this.craftingInventory.getStacks(), true, true);
    }

    @Override
    public void readItems(class_2487 compound) {
        this.inventory = this.createInventory(this.tier.getAllSlots());
        this.craftingInventory = this.createInventory(9);
        InventoryUtils.readNbt(compound, this.inventory.getStacks(), false);
        InventoryUtils.readNbt(compound, this.craftingInventory.getStacks(), true);
    }

    @Override
    public void writeTanks(class_2487 compound) {
        compound.method_10566("LeftTank", (class_2520)((FluidVariant)this.getLeftTank().variant).toNbt());
        compound.method_10566("RightTank", (class_2520)((FluidVariant)this.getRightTank().variant).toNbt());
        compound.method_10544("LeftTankAmount", this.getLeftTank().amount);
        compound.method_10544("RightTankAmount", this.getRightTank().amount);
    }

    @Override
    public void readTanks(class_2487 compound) {
        this.leftTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("LeftTank"));
        this.rightTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("RightTank"));
        this.leftTank.amount = compound.method_10537("LeftTankAmount");
        this.rightTank.amount = compound.method_10537("RightTankAmount");
    }

    @Override
    public void writeColor(class_2487 compound) {
        compound.method_10569("Color", this.color);
    }

    @Override
    public void readColor(class_2487 compound) {
        this.color = compound.method_10550("Color");
    }

    @Override
    public void writeSleepingBagColor(class_2487 compound) {
        compound.method_10569("SleepingBagColor", this.sleepingBagColor);
    }

    @Override
    public void readSleepingBagColor(class_2487 compound) {
        this.sleepingBagColor = compound.method_10545("SleepingBagColor") ? compound.method_10550("SleepingBagColor") : class_1767.field_7964.method_7789();
    }

    @Override
    public void writeAbility(class_2487 compound) {
        compound.method_10556("Ability", this.ability);
    }

    @Override
    public void readAbility(class_2487 compound) {
        this.ability = !compound.method_10545("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.method_10577("Ability");
    }

    @Override
    public void writeTime(class_2487 compound) {
        compound.method_10569("LastTime", this.lastTime);
    }

    @Override
    public void readTime(class_2487 compound) {
        this.lastTime = compound.method_10550("LastTime");
    }

    public void writeSleepingBag(class_2487 compound) {
        compound.method_10556("SleepingBag", this.isSleepingBagDeployed);
    }

    public void readSleepingBag(class_2487 compound) {
        this.isSleepingBagDeployed = compound.method_10577("SleepingBag");
    }

    public void writeName(class_2487 compound) {
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
    }

    public void readName(class_2487 compound) {
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
    }

    @Override
    public void writeAllData(class_2487 compound) {
        this.writeTier(compound);
        this.writeItems(compound);
        this.writeTanks(compound);
        this.writeSleepingBag(compound);
        this.writeColor(compound);
        this.writeSleepingBagColor(compound);
        this.writeAbility(compound);
        this.writeTime(compound);
        this.writeName(compound);
        this.slotManager.writeUnsortableSlots(compound);
        this.slotManager.writeMemorySlots(compound);
        this.settingsManager.writeSettings(compound);
    }

    @Override
    public void readAllData(class_2487 compound) {
        this.readTier(compound);
        this.readItems(compound);
        this.readTanks(compound);
        this.readSleepingBag(compound);
        this.readColor(compound);
        this.readSleepingBagColor(compound);
        this.readAbility(compound);
        this.readTime(compound);
        this.readName(compound);
        this.slotManager.readUnsortableSlots(compound);
        this.slotManager.readMemorySlots(compound);
        this.settingsManager.readSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), this.player);
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.sleepingBagColor != class_1767.field_7964.method_7789();
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.sleepingBagColor;
        }
        return class_1767.field_7964.method_7789();
    }

    public void setSleepingBagColor(int colorId) {
        this.sleepingBagColor = colorId;
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().method_7909()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
        this.method_5431();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    public void resetTier() {
        this.tier = Tiers.LEATHER;
        this.method_5431();
    }

    @Override
    public class_1937 method_10997() {
        return super.method_10997();
    }

    @Override
    public class_2338 getPosition() {
        return this.field_11867;
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public class_1799 getItemStack() {
        class_2248 class_22482 = this.field_11863.method_8320(this.method_11016()).method_26204();
        if (class_22482 instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block = (TravelersBackpackBlock)class_22482;
            return new class_1799((class_1935)block);
        }
        return new class_1799((class_1935)ModBlocks.STANDARD_TRAVELERS_BACKPACK);
    }

    @Override
    public void setUsingPlayer(@Nullable class_1657 player) {
        this.player = player;
    }

    @Override
    public void markDataDirty(byte ... dataIds) {
    }

    @Override
    public void method_5431() {
        if (!this.field_11863.field_9236) {
            super.method_5431();
            this.sync();
        }
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(class_1937 world, class_2338 pos) {
        class_2338 sleepingBagPos1;
        class_2338 sleepingBagPos2;
        class_2350 direction = this.getBlockDirection(world.method_8321(this.method_11016()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && world.method_22347(sleepingBagPos2 = (sleepingBagPos1 = pos.method_10093(direction)).method_10093(direction)) && world.method_22347(sleepingBagPos1) && world.method_8320(sleepingBagPos1.method_10074()).method_30368((class_1922)world, sleepingBagPos1.method_10074(), class_2350.field_11036, class_5431.field_25822) && world.method_8320(sleepingBagPos2.method_10074()).method_30368((class_1922)world, sleepingBagPos2.method_10074(), class_2350.field_11036, class_5431.field_25822)) {
            world.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
            if (!world.field_9236) {
                class_2680 sleepingBagState = this.getProperSleepingBag(this.getSleepingBagColor());
                world.method_8652(sleepingBagPos1, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12557)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                world.method_8652(sleepingBagPos2, (class_2680)((class_2680)((class_2680)sleepingBagState.method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12560)).method_11657((class_2769)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                world.method_8452(pos, sleepingBagState.method_26204());
                world.method_8452(sleepingBagPos2, sleepingBagState.method_26204());
            }
            this.isSleepingBagDeployed = true;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(class_1937 world) {
        class_2350 blockFacing = this.getBlockDirection(world.method_8321(this.method_11016()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            class_2338 sleepingBagPos1 = this.field_11867.method_10093(blockFacing);
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(blockFacing);
            if (world.method_8320(sleepingBagPos1).method_26204() instanceof SleepingBagBlock && world.method_8320(sleepingBagPos2).method_26204() instanceof SleepingBagBlock) {
                world.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
                world.method_8501(sleepingBagPos2, class_2246.field_10124.method_9564());
                world.method_8501(sleepingBagPos1, class_2246.field_10124.method_9564());
                this.isSleepingBagDeployed = false;
                this.method_5431();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(class_2350 direction) {
        if (this.field_11863.method_8320(this.field_11867.method_10093(direction)).method_26204() instanceof SleepingBagBlock && this.field_11863.method_8320(this.field_11867.method_10093(direction).method_10093(direction)).method_26204() instanceof SleepingBagBlock) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public class_2680 getProperSleepingBag(int colorId) {
        return switch (colorId) {
            case 0 -> ModBlocks.WHITE_SLEEPING_BAG.method_9564();
            case 1 -> ModBlocks.ORANGE_SLEEPING_BAG.method_9564();
            case 2 -> ModBlocks.MAGENTA_SLEEPING_BAG.method_9564();
            case 3 -> ModBlocks.LIGHT_BLUE_SLEEPING_BAG.method_9564();
            case 4 -> ModBlocks.YELLOW_SLEEPING_BAG.method_9564();
            case 5 -> ModBlocks.LIME_SLEEPING_BAG.method_9564();
            case 6 -> ModBlocks.PINK_SLEEPING_BAG.method_9564();
            case 7 -> ModBlocks.GRAY_SLEEPING_BAG.method_9564();
            case 8 -> ModBlocks.LIGHT_GRAY_SLEEPING_BAG.method_9564();
            case 9 -> ModBlocks.CYAN_SLEEPING_BAG.method_9564();
            case 10 -> ModBlocks.PURPLE_SLEEPING_BAG.method_9564();
            case 11 -> ModBlocks.BLUE_SLEEPING_BAG.method_9564();
            case 12 -> ModBlocks.BROWN_SLEEPING_BAG.method_9564();
            case 13 -> ModBlocks.GREEN_SLEEPING_BAG.method_9564();
            case 14 -> ModBlocks.RED_SLEEPING_BAG.method_9564();
            case 15 -> ModBlocks.BLACK_SLEEPING_BAG.method_9564();
            default -> ModBlocks.RED_SLEEPING_BAG.method_9564();
        };
    }

    public boolean isUsableByPlayer(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return this.player == player && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public class_2350 getBlockDirection(class_2586 blockEntity) {
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            if (this.field_11863 == null || !(this.field_11863.method_8320(this.method_11016()).method_26204() instanceof TravelersBackpackBlock)) {
                return class_2350.field_11043;
            }
            return (class_2350)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)TravelersBackpackBlock.FACING);
        }
        return class_2350.field_11043;
    }

    public boolean hasData() {
        boolean isDefaultTier = this.getTier() == Tiers.LEATHER;
        boolean isInvEmpty = this.getInventory().method_5442();
        boolean isCraftingInvEmpty = this.getCraftingGridInventory().method_5442();
        boolean leftTankEmpty = this.getLeftTank().isResourceBlank();
        boolean rightTankEmpty = this.getRightTank().isResourceBlank();
        boolean hasColor = this.hasColor();
        boolean hasSleepingBagColor = this.hasSleepingBagColor();
        boolean hasTime = this.getLastTime() != 0;
        boolean hasUnsortableSlots = !this.slotManager.getUnsortableSlots().isEmpty();
        boolean hasMemorySlots = !this.slotManager.getMemorySlots().isEmpty();
        boolean hasCustomName = this.method_16914();
        return !isDefaultTier || !isInvEmpty || !isCraftingInvEmpty || !leftTankEmpty || !rightTankEmpty || hasColor || hasSleepingBagColor || hasTime || hasUnsortableSlots || hasMemorySlots || hasCustomName;
    }

    public class_1799 transferToItemStack(class_1799 stack) {
        class_2487 compound = new class_2487();
        this.writeTier(compound);
        this.writeTanks(compound);
        this.writeItems(compound);
        if (this.hasColor()) {
            this.writeColor(compound);
        }
        if (this.hasSleepingBagColor()) {
            this.writeSleepingBagColor(compound);
        }
        this.writeAbility(compound);
        this.writeTime(compound);
        this.slotManager.writeUnsortableSlots(compound);
        this.slotManager.writeMemorySlots(compound);
        this.settingsManager.writeSettings(compound);
        stack.method_7980(compound);
        if (this.method_16914()) {
            stack.method_7977(this.method_5797());
        }
        return stack;
    }

    public void fromClientTag(class_2487 compoundTag) {
        this.method_11014(compoundTag);
    }

    public class_2487 toClientTag(class_2487 compoundTag) {
        return this.method_11007(compoundTag);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 getDefaultName() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, blockEntity.getItemStack())) {
            if (blockEntity.getLastTime() > 0) {
                blockEntity.setLastTime(blockEntity.getLastTime() - 1);
                blockEntity.method_5431();
            }
            BackpackAbilities.ABILITIES.abilityTick(null, null, blockEntity);
        }
    }

    public void openHandledScreen(class_1657 player) {
        if (!player.field_6002.field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.method_10807(TravelersBackpackBlockEntity.this.field_11867);
                }

                public class_2561 method_5476() {
                    return new class_2588(TravelersBackpackBlockEntity.this.method_11010().method_26204().method_9539());
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new TravelersBackpackBlockEntityScreenHandler(syncId, inv, TravelersBackpackBlockEntity.this);
                }
            });
        }
    }

    public InventoryImproved createInventory(int size) {
        return new InventoryImproved(class_2371.method_10213((int)size, (Object)class_1799.field_8037)){

            @Override
            public void method_5431() {
                TravelersBackpackBlockEntity.this.method_5431();
            }

            @Override
            public boolean method_5437(int slot, class_1799 stack) {
                class_2960 blacklistedItems = new class_2960("travelersbackpack", "blacklisted_items");
                if (BackpackSlot.BLACKLISTED_ITEMS.contains(stack.method_7909())) {
                    return false;
                }
                return !(stack.method_7909() instanceof TravelersBackpackItem) && !stack.method_31573(class_3489.method_15106().method_30210(blacklistedItems)) && (TravelersBackpackConfig.allowShulkerBoxes || stack.method_7909().method_31568());
            }
        };
    }

    public SingleVariantStorage<FluidVariant> createFluidTank(long capacity) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return TravelersBackpackBlockEntity.this.tier.getTankCapacity();
            }

            protected void onFinalCommit() {
                TravelersBackpackBlockEntity.this.method_5431();
            }
        };
    }
}

