/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.mojang.datafixers.util.Either;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.mixin.AccessorPlayerEntity;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class SleepingBagBlock
extends class_2244 {
    public static final class_2754<class_2742> PART = class_2741.field_12483;
    public static final class_2746 OCCUPIED = class_2741.field_12528;
    public static final class_2746 CAN_DROP = class_2741.field_12486;
    private static final class_265 SLEEPING_BAG_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final class_265 SLEEPING_BAG_SHAPE_NORTH = Stream.of(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)8.0)).reduce((v1, v2) -> class_259.method_1082((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 SLEEPING_BAG_SHAPE_EAST = Stream.of(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> class_259.method_1082((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 SLEEPING_BAG_SHAPE_SOUTH = Stream.of(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> class_259.method_1082((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 SLEEPING_BAG_SHAPE_WEST = Stream.of(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), class_2248.method_9541((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> class_259.method_1082((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();

    public SleepingBagBlock(class_1767 color, class_4970.class_2251 settings) {
        super(color, settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)class_2742.field_12557)).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CAN_DROP, (Comparable)Boolean.valueOf(true)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((class_2742)state.method_11654(PART)) {
            case field_12557: {
                return SLEEPING_BAG_SHAPE;
            }
            case field_12560: {
                switch ((class_2350)state.method_11654((class_2769)field_11177)) {
                    case field_11034: {
                        return SLEEPING_BAG_SHAPE_EAST;
                    }
                    case field_11035: {
                        return SLEEPING_BAG_SHAPE_SOUTH;
                    }
                    case field_11039: {
                        return SLEEPING_BAG_SHAPE_WEST;
                    }
                }
                return SLEEPING_BAG_SHAPE_NORTH;
            }
        }
        return SLEEPING_BAG_SHAPE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_21466;
        }
        if (state.method_11654(PART) != class_2742.field_12560 && !(state = world.method_8320(pos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177)))).method_27852((class_2248)this)) {
            return class_1269.field_21466;
        }
        if (!SleepingBagBlock.method_27352((class_1937)world)) {
            world.method_8650(pos, false);
            class_2338 blockPos = pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_10153());
            if (world.method_8320(blockPos).method_27852((class_2248)this)) {
                world.method_8650(blockPos, false);
            }
            return class_1269.field_5812;
        }
        if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
            if (!this.isFree(world, pos)) {
                player.method_9203((class_2561)new class_2588("block.minecraft.bed.occupied"), player.method_5667());
            }
            return class_1269.field_5812;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.trySleep(serverPlayer, pos).ifLeft(sleepFailureReason -> {
                if (sleepFailureReason != null) {
                    player.method_7353(sleepFailureReason.method_19206(), true);
                }
            });
        }
        return class_1269.field_5812;
    }

    public Either<class_1657.class_1658, class_3902> trySleep(class_3222 player, class_2338 pos) {
        class_2350 direction = (class_2350)player.field_6002.method_8320(pos).method_11654((class_2769)class_2383.field_11177);
        if (!player.method_6113() && player.method_5805()) {
            if (!player.field_6002.method_8597().method_28537()) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                }
                return Either.left((Object)class_1657.class_1658.field_7528);
            }
            if (!this.isBedTooFarAway((class_1657)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                }
                return Either.left((Object)class_1657.class_1658.field_7530);
            }
            if (this.isBedObstructed((class_1657)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                }
                return Either.left((Object)class_1657.class_1658.field_18592);
            }
            if (player.field_6002.method_8530()) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                }
                return Either.left((Object)class_1657.class_1658.field_7529);
            }
            if (!player.method_7337()) {
                double d = 8.0;
                double e = 5.0;
                class_243 vec3d = class_243.method_24955((class_2382)pos);
                List list = player.field_6002.method_8390(class_1588.class, new class_238(vec3d.method_10216() - 8.0, vec3d.method_10214() - 5.0, vec3d.method_10215() - 8.0, vec3d.method_10216() + 8.0, vec3d.method_10214() + 5.0, vec3d.method_10215() + 8.0), hostileEntity -> hostileEntity.method_7076((class_1657)player));
                if (!list.isEmpty()) {
                    if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                        player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                    }
                    return Either.left((Object)class_1657.class_1658.field_7532);
                }
            }
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                Either either = player.method_7269(pos).ifRight(unit -> {
                    player.method_7281(class_3468.field_15381);
                    class_174.field_1212.method_9027(player);
                });
                ((class_3218)player.field_6002).method_8448();
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
                }
                return either;
            }
            player.method_18403(pos);
            ((AccessorPlayerEntity)player).setSleepTimer(0);
            player.method_7281(class_3468.field_15381);
            class_174.field_1212.method_9027(player);
            ((class_3218)player.field_6002).method_8448();
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
            }
            return Either.right((Object)class_3902.field_17274);
        }
        if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
            player.method_26284(player.field_6002.method_27983(), pos, player.method_36454(), true, true);
        }
        return Either.left((Object)class_1657.class_1658.field_7531);
    }

    private boolean isBedTooFarAway(class_1657 player, class_2338 pos, class_2350 direction) {
        return this.isBedTooFarAway(player, pos) || this.isBedTooFarAway(player, pos.method_10093(direction.method_10153()));
    }

    private boolean isBedTooFarAway(class_1657 player, class_2338 pos) {
        class_243 vec3d = class_243.method_24955((class_2382)pos);
        return Math.abs(player.method_23317() - vec3d.method_10216()) <= 3.0 && Math.abs(player.method_23318() - vec3d.method_10214()) <= 2.0 && Math.abs(player.method_23321() - vec3d.method_10215()) <= 3.0;
    }

    private boolean isBedObstructed(class_1657 player, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10084();
        return !this.doesNotSuffocate(player, blockPos) || !this.doesNotSuffocate(player, blockPos.method_10093(direction.method_10153()));
    }

    protected boolean doesNotSuffocate(class_1657 player, class_2338 pos) {
        return !player.field_6002.method_8320(pos).method_26228((class_1922)player.field_6002, pos);
    }

    private boolean isFree(class_1937 world, class_2338 pos) {
        List list = world.method_8390(class_1646.class, new class_238(pos), class_1309::method_6113);
        if (list.isEmpty()) {
            return false;
        }
        ((class_1646)list.get(0)).method_18400();
        return true;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(world, state, pos, entity, fallDistance * 0.75f);
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(world, entity);
        } else {
            this.bounceEntity(entity);
        }
    }

    private void bounceEntity(class_1297 entity) {
        class_243 vec3d = entity.method_18798();
        if (vec3d.field_1351 < 0.0) {
            double d = entity instanceof class_1309 ? 1.0 : 0.8;
            entity.method_18800(vec3d.field_1352, -vec3d.field_1351 * (double)0.66f * d, vec3d.field_1350);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == SleepingBagBlock.getDirectionTowardsOtherPart((class_2742)state.method_11654(PART), (class_2350)state.method_11654((class_2769)field_11177))) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? (class_2680)state.method_11657((class_2769)OCCUPIED, (Comparable)((Boolean)neighborState.method_11654((class_2769)OCCUPIED))) : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private static class_2350 getDirectionTowardsOtherPart(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 class_25862;
        class_2338 backpackPos;
        boolean isFoot = state.method_11654(PART) == class_2742.field_12557;
        class_2338 class_23382 = backpackPos = isFoot ? pos.method_10093(((class_2350)state.method_11654((class_2769)field_11177)).method_10153()) : pos.method_10079(((class_2350)state.method_11654((class_2769)field_11177)).method_10153(), 2);
        if (world.method_8320(backpackPos).method_26204() instanceof TravelersBackpackBlock && (class_25862 = world.method_8321(backpackPos)) instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)class_25862;
            blockEntity.setSleepingBagDeployed(false);
        }
        super.method_9576(world, pos, state, player);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        class_2338 blockPos = ctx.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        return ctx.method_8045().method_8320(blockPos2).method_26166(ctx) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction) : null;
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15971;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, PART, OCCUPIED, CAN_DROP});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2338 blockPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177));
            world.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)class_2742.field_12560), 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 blockPos = pos.method_10079((class_2350)state.method_11654((class_2769)field_11177), state.method_11654(PART) == class_2742.field_12560 ? 0 : 1);
        return class_3532.method_15371((int)blockPos.method_10263(), (int)pos.method_10264(), (int)blockPos.method_10260());
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        if (!((Boolean)state.method_11654((class_2769)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.method_9560(state, builder);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }
}

