/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screen.tooltip.BackpackTooltipData;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class BackpackTooltipComponent
implements class_5684 {
    public static final class_2960 LEATHER_TOOLTIP_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/tooltip/leather_travelers_backpack_tooltip.png");
    public static final class_2960 IRON_TOOLTIP_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/tooltip/iron_travelers_backpack_tooltip.png");
    public static final class_2960 GOLD_TOOLTIP_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/tooltip/gold_travelers_backpack_tooltip.png");
    public static final class_2960 DIAMOND_TOOLTIP_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/tooltip/diamond_travelers_backpack_tooltip.png");
    public static final class_2960 NETHERITE_TOOLTIP_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/tooltip/netherite_travelers_backpack_tooltip.png");
    private final BackpackTooltipData component;

    public BackpackTooltipComponent(BackpackTooltipData component) {
        this.component = component;
    }

    public int method_32661() {
        if (BackpackUtils.isCtrlPressed() && this.component.stack.method_7985()) {
            return this.getTextureHeight();
        }
        return 0;
    }

    public int method_32664(class_327 textRenderer) {
        if (BackpackUtils.isCtrlPressed() && this.component.stack.method_7985()) {
            return 229;
        }
        return 0;
    }

    public void method_32665(class_327 textRenderer, int x, int y, class_1159 matrix4f, class_4597.class_4598 immediate) {
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_4587 matrices, class_918 itemRenderer, int z, class_1060 textureManager) {
        if (!this.component.stack.method_7985()) {
            return;
        }
        if (BackpackUtils.isCtrlPressed()) {
            int i;
            this.blit(matrices, x, y, z, textureManager);
            int slot = 0;
            boolean isEmpty = true;
            if (!this.component.inventory.method_5442()) {
                for (int j = 0; j < 3 + this.component.tier.getOrdinal(); ++j) {
                    for (int i2 = 0; i2 < 9; ++i2) {
                        if (this.applyGridConditions(i2, j)) continue;
                        int i1 = x + i2 * 18 + 43;
                        int j1 = y + j * 18 + 6;
                        this.renderItemInSlot(i1, j1, slot, textRenderer, matrices, itemRenderer, z, textureManager, false);
                        ++slot;
                    }
                }
                isEmpty = false;
            }
            int craftingSlot = 0;
            if (!this.component.craftingInventory.method_5442()) {
                for (int j = 0; j < 3; ++j) {
                    for (i = 0; i < 3; ++i) {
                        int i1 = x + i * 18 + 151;
                        int j1 = y + j * 18 + this.component.tier.getOrdinal() * 18 + 6;
                        this.renderItemInSlot(i1, j1, craftingSlot, textRenderer, matrices, itemRenderer, z, textureManager, true);
                        ++craftingSlot;
                    }
                }
            }
            int tool = 0;
            if (!isEmpty && this.component.hasToolInSlot(Tiers.SlotType.TOOL_FIRST)) {
                for (i = this.component.tier.getSlotIndex(Tiers.SlotType.TOOL_FIRST); i <= this.component.tier.getSlotIndex(Tiers.SlotType.TOOL_FIRST) + this.component.tier.getToolSlots() - 1; ++i) {
                    this.renderItemInSlot(x + 5, y + tool * 18 + 6, i, textRenderer, matrices, itemRenderer, z, textureManager, false);
                    ++tool;
                }
            }
            if (!this.component.leftTank.isResourceBlank()) {
                RenderUtils.renderScreenTank(matrices, this.component.leftTank, x + 25, y + 7, 1000.0, this.component.tier.getTankRenderPos(), 16.0);
            }
            if (!this.component.rightTank.isResourceBlank()) {
                RenderUtils.renderScreenTank(matrices, this.component.rightTank, x + 207, y + 7, 1000.0, this.component.tier.getTankRenderPos(), 16.0);
            }
        }
    }

    private void renderItemInSlot(int x, int y, int slot, class_327 textRenderer, class_4587 matrices, class_918 itemRenderer, int z, class_1060 textureManager, boolean isCrafting) {
        class_1799 stack = class_1799.field_8037;
        if (!isCrafting) {
            if (slot > this.component.tier.getStorageSlots() + this.component.tier.getToolSlots()) {
                return;
            }
            stack = this.component.inventory.method_5438(slot);
        } else {
            stack = this.component.craftingInventory.method_5438(slot);
        }
        if (stack.method_7960()) {
            return;
        }
        itemRenderer.method_4010(stack, x + 1, y + 1);
        itemRenderer.method_4025(textRenderer, stack, x + 1, y + 1);
    }

    private void blit(class_4587 matrices, int x, int y, int z, class_1060 textureManager) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTooltipTexture());
        class_437.method_25291((class_4587)matrices, (int)x, (int)y, (int)z, (float)0.0f, (float)0.0f, (int)229, (int)this.getTextureHeight(), (int)256, (int)256);
    }

    private boolean applyGridConditions(int i, int j) {
        if (this.component.tier == Tiers.LEATHER && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.IRON && j > 0 && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.GOLD && j > 1 && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.DIAMOND && j > 2 && i > 5) {
            return true;
        }
        return this.component.tier == Tiers.NETHERITE && j > 3 && i > 5;
    }

    public class_2960 getTooltipTexture() {
        if (this.component.tier == Tiers.LEATHER) {
            return LEATHER_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.IRON) {
            return IRON_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.GOLD) {
            return GOLD_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.DIAMOND) {
            return DIAMOND_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.NETHERITE) {
            return NETHERITE_TOOLTIP_TRAVELERS_BACKPACK;
        }
        return LEATHER_TOOLTIP_TRAVELERS_BACKPACK;
    }

    public int getTextureHeight() {
        if (this.component.tier == Tiers.LEATHER) {
            return 67;
        }
        if (this.component.tier == Tiers.IRON) {
            return 85;
        }
        if (this.component.tier == Tiers.GOLD) {
            return 103;
        }
        if (this.component.tier == Tiers.DIAMOND) {
            return 121;
        }
        if (this.component.tier == Tiers.NETHERITE) {
            return 139;
        }
        return 67;
    }
}

