/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Random;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;

public class ShapelessBackpackRecipe
extends class_1867 {
    private final String group;

    public ShapelessBackpackRecipe(class_2960 id, String group, class_1799 output, class_2371<class_1856> input) {
        super(id, group, output, input);
        this.group = group;
    }

    public class_1799 method_17729(class_1715 inv) {
        class_1799 output = super.method_17729(inv);
        if (!output.method_7960()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ingredient = inv.method_5438(i);
                if (ingredient.method_7960() || !(ingredient.method_7909() instanceof TravelersBackpackItem)) continue;
                class_2487 compound = ingredient.method_7969();
                output.method_7980(compound);
                break;
            }
        }
        return output;
    }

    private class_1799 damageShears(class_1799 stack) {
        Object craftingPlayer = null;
        if (stack.method_7970(1, craftingPlayer == null ? new Random() : craftingPlayer.field_6002.field_9229, craftingPlayer instanceof class_3222 ? (class_3222)craftingPlayer : null)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public class_2371<class_1799> getRemainder(class_1715 inventoryCrafting) {
        class_2371 remainingItems = class_2371.method_10213((int)inventoryCrafting.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < remainingItems.size(); ++i) {
            class_1799 itemstack = inventoryCrafting.method_5438(i);
            if (!itemstack.method_7960() && itemstack.method_7909() instanceof class_1820) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.method_7972()));
            }
            if (!itemstack.method_7909().method_7857()) continue;
            remainingItems.set(i, (Object)new class_1799((class_1935)itemstack.method_7909().method_7858()));
        }
        return remainingItems;
    }

    public class_1865<?> method_8119() {
        return ModCrafting.BACKPACK_SHAPELESS;
    }

    public static class Serializer
    implements class_1865<ShapelessBackpackRecipe> {
        public ShapelessBackpackRecipe read(class_2960 recipeId, JsonObject json) {
            String s = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> nonnulllist = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new ShapelessBackpackRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ShapelessBackpackRecipe read(class_2960 recipeId, class_2540 buffer) {
            String s = buffer.method_10800(Short.MAX_VALUE);
            int i = buffer.method_10816();
            class_2371 nonnulllist = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemstack = buffer.method_10819();
            return new ShapelessBackpackRecipe(recipeId, s, itemstack, (class_2371<class_1856>)nonnulllist);
        }

        public void write(class_2540 buffer, ShapelessBackpackRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.method_8110());
        }
    }
}

