/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.component.ITravelersBackpackComponent;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class UnpackBackpackCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"tb").requires(player -> player.method_9259(2));
        tbCommand.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unpack").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(source -> UnpackBackpackCommand.unpackTargetBlockEntity((class_2168)source.getSource(), class_2262.method_48299((CommandContext)source, (String)"pos"))))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(source -> UnpackBackpackCommand.unpackTargetInventory((class_2168)source.getSource(), class_2186.method_9315((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public static int unpackTargetBlockEntity(class_2168 source, class_2338 blockPos) throws CommandSyntaxException {
        if (source.method_9225().method_8321(blockPos) instanceof TravelersBackpackBlockEntity) {
            class_1799 stack;
            int i;
            TravelersBackpackBlockEntity inv = (TravelersBackpackBlockEntity)source.method_9225().method_8321(blockPos);
            class_2371 stacks = class_2371.method_10211();
            for (i = 0; i < inv.getInventory().method_5439(); ++i) {
                stack = inv.getInventory().method_5438(i);
                if (stack.method_7960()) continue;
                stacks.add((Object)stack);
                inv.getInventory().method_5447(i, class_1799.field_8037);
            }
            for (i = 0; i < inv.getCraftingGridInventory().method_5439(); ++i) {
                stack = inv.getCraftingGridInventory().method_5438(i);
                if (stack.method_7960()) continue;
                stacks.add((Object)stack);
                inv.getCraftingGridInventory().method_5447(i, class_1799.field_8037);
            }
            if (stacks.size() > 0) {
                if (!source.method_9225().field_9236) {
                    class_1264.method_17349((class_1937)source.method_9225(), (class_2338)blockPos, (class_2371)stacks);
                }
                source.method_9226(() -> class_2561.method_43470((String)("Dropping contents of backpack placed at " + blockPos.method_23854())), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)("There's no contents in backpack at coordinates " + blockPos.method_23854())));
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)("There's no backpack at coordinates " + blockPos.method_23854())));
        return -1;
    }

    public static int unpackTargetInventory(class_2168 source, class_3222 serverPlayer) throws CommandSyntaxException {
        boolean hasBackpack = ComponentUtils.isWearingBackpack((class_1657)serverPlayer);
        if (hasBackpack) {
            class_1799 stack;
            int i;
            AtomicBoolean flag = new AtomicBoolean(false);
            ITravelersBackpackComponent component = ComponentUtils.getComponent((class_1657)serverPlayer);
            class_2371 stacks = class_2371.method_10211();
            for (i = 0; i < component.getInventory().getInventory().method_5439(); ++i) {
                stack = component.getInventory().getInventory().method_5438(i);
                if (stack.method_7960()) continue;
                stacks.add((Object)stack);
                component.getInventory().getInventory().method_5447(i, class_1799.field_8037);
            }
            for (i = 0; i < component.getInventory().getCraftingGridInventory().method_5439(); ++i) {
                stack = component.getInventory().getCraftingGridInventory().method_5438(i);
                if (stack.method_7960()) continue;
                stacks.add((Object)stack);
                component.getInventory().getCraftingGridInventory().method_5447(i, class_1799.field_8037);
            }
            if (stacks.size() > 0 && !source.method_9225().field_9236) {
                class_1264.method_17349((class_1937)source.method_9225(), (class_2338)serverPlayer.method_24515(), (class_2371)stacks);
                flag.set(true);
            }
            if (flag.get()) {
                source.method_9226(() -> class_2561.method_43470((String)("Dropping contents of " + serverPlayer.method_5476().getString() + " backpack at " + serverPlayer.method_24515().method_23854())), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)("There's no contents in " + serverPlayer.method_5476().getString() + " backpack")));
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)("Player " + serverPlayer.method_5476().getString() + " is not wearing backpack")));
        return -1;
    }
}

