/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.class_8790;

public class BackpackUpgradeRecipeJsonBuilder {
    private final class_1856 template;
    private final class_1856 base;
    private final class_1856 addition;
    private final class_7800 category;
    private final class_1792 result;
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    private final class_1865<?> serializer;

    public BackpackUpgradeRecipeJsonBuilder(class_1865<?> serializer, class_1856 template, class_1856 base, class_1856 addition, class_7800 category, class_1792 result) {
        this.category = category;
        this.serializer = serializer;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public static BackpackUpgradeRecipeJsonBuilder create(class_1856 template, class_1856 base, class_1856 addition, class_7800 category, class_1792 result) {
        return new BackpackUpgradeRecipeJsonBuilder(ModCrafting.BACKPACK_UPGRADE, template, base, addition, category, result);
    }

    public BackpackUpgradeRecipeJsonBuilder criterion(String name, class_175<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void offerTo(class_8790 exporter, String recipeId) {
        this.offerTo(exporter, new class_2960(recipeId));
    }

    public void offerTo(class_8790 exporter, class_2960 recipeId) {
        this.validate(recipeId);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        exporter.method_53819((class_2444)new BackpackUpgradeRecipeJsonProvider(recipeId, this.serializer, this.template, this.base, this.addition, this.result, builder.method_695(recipeId.method_45138("recipes/" + this.category.method_46203() + "/"))));
    }

    private void validate(class_2960 recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    public static final class BackpackUpgradeRecipeJsonProvider
    extends Record
    implements class_2444 {
        private final class_2960 id;
        private final class_1865<?> serializer;
        private final class_1856 template;
        private final class_1856 base;
        private final class_1856 addition;
        private final class_1792 result;
        private final class_8779 advancement;

        public BackpackUpgradeRecipeJsonProvider(class_2960 id, class_1865<?> serializer, class_1856 template, class_1856 base, class_1856 addition, class_1792 result, class_8779 advancement) {
            this.id = id;
            this.serializer = serializer;
            this.template = template;
            this.base = base;
            this.addition = addition;
            this.result = result;
            this.advancement = advancement;
        }

        public void method_10416(JsonObject json) {
            json.add("template", this.template.method_8089(true));
            json.add("base", this.base.method_8089(true));
            json.add("addition", this.addition.method_8089(true));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            json.add("result", (JsonElement)jsonObject);
        }

        public class_2960 comp_1230() {
            return this.id;
        }

        public class_1865<?> comp_1231() {
            return this.serializer;
        }

        public class_1856 template() {
            return this.template;
        }

        public class_1856 base() {
            return this.base;
        }

        public class_1856 addition() {
            return this.addition;
        }

        public class_1792 result() {
            return this.result;
        }

        public class_8779 comp_1235() {
            return this.advancement;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BackpackUpgradeRecipeJsonProvider.class, "id;serializer;template;base;addition;result;advancement", "id", "serializer", "template", "base", "addition", "result", "advancement"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BackpackUpgradeRecipeJsonProvider.class, "id;serializer;template;base;addition;result;advancement", "id", "serializer", "template", "base", "addition", "result", "advancement"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BackpackUpgradeRecipeJsonProvider.class, "id;serializer;template;base;addition;result;advancement", "id", "serializer", "template", "base", "addition", "result", "advancement"}, this, o);
        }
    }
}

