/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TravelersBackpackBlockEntity
extends BlockEntity
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private final ItemStackHandler inventory = this.createHandler(Tiers.LEATHER.getAllSlots(), true);
    private final ItemStackHandler craftingInventory = this.createHandler(9, false);
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private Player player = null;
    private boolean isSleepingBagDeployed = false;
    private int color = 0;
    private int sleepingBagColor = DyeColor.RED.m_41060_();
    private Tiers.Tier tier = Tiers.LEATHER;
    private boolean ability = true;
    private int lastTime = 0;
    private Component customName = null;
    private final LazyOptional<IItemHandlerModifiable> inventoryCapability = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, this.tier.getStorageSlots()));
    private final LazyOptional<ItemStackHandler> craftingInventoryCapability = LazyOptional.of(() -> this.craftingInventory);
    private final LazyOptional<IFluidHandler> leftFluidTankCapability = LazyOptional.of(() -> this.leftTank);
    private final LazyOptional<IFluidHandler> rightFluidTankCapability = LazyOptional.of(() -> this.rightTank);
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String SLEEPING_BAG = "SleepingBag";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";
    private final String CUSTOM_NAME = "CustomName";

    public TravelersBackpackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TRAVELERS_BACKPACK.get(), pos, state);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        this.saveAllData(compound);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadAllData(compound);
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedHandler() {
        RangedWrapper additional = null;
        if (this.tier != Tiers.LEATHER) {
            additional = new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 0, this.tier.getStorageSlots() - 18);
        }
        if (additional != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{additional, new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots(), additional.getSlots() + 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots() + 6, additional.getSlots() + 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots() + 12, additional.getSlots() + 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 6, 9)});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 0, 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 6, 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 12, 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 6, 9)});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void saveTier(CompoundTag compound) {
        compound.m_128405_("Tier", this.tier.getOrdinal());
    }

    public void loadTier(CompoundTag compound) {
        if (compound.m_128425_("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.m_128461_("Tier"));
            compound.m_128473_("Tier");
            compound.m_128405_("Tier", tier.getOrdinal());
        }
        this.tier = compound.m_128441_("Tier") ? Tiers.of(compound.m_128451_("Tier")) : (TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER : Tiers.DIAMOND);
    }

    @Override
    public void saveItems(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
    }

    @Override
    public void saveTanks(CompoundTag compound) {
        compound.m_128365_("LeftTank", (Tag)this.leftTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("RightTank", (Tag)this.rightTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    @Override
    public void saveColor(CompoundTag compound) {
        compound.m_128405_("Color", this.color);
    }

    @Override
    public void loadColor(CompoundTag compound) {
        this.color = compound.m_128451_("Color");
    }

    @Override
    public void saveSleepingBagColor(CompoundTag compound) {
        compound.m_128405_("SleepingBagColor", this.sleepingBagColor);
    }

    @Override
    public void loadSleepingBagColor(CompoundTag compound) {
        this.sleepingBagColor = compound.m_128441_("SleepingBagColor") ? compound.m_128451_("SleepingBagColor") : DyeColor.RED.m_41060_();
    }

    @Override
    public void saveAbility(CompoundTag compound) {
        compound.m_128379_("Ability", this.ability);
    }

    @Override
    public void loadAbility(CompoundTag compound) {
        this.ability = !compound.m_128441_("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.m_128471_("Ability");
    }

    @Override
    public void saveTime(CompoundTag compound) {
        compound.m_128405_("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundTag compound) {
        this.lastTime = compound.m_128451_("LastTime");
    }

    public void saveSleepingBag(CompoundTag compound) {
        compound.m_128379_("SleepingBag", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(CompoundTag compound) {
        this.isSleepingBagDeployed = compound.m_128471_("SleepingBag");
    }

    public void saveName(CompoundTag compound) {
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void loadName(CompoundTag compound) {
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
    }

    @Override
    public void saveAllData(CompoundTag compound) {
        this.saveTier(compound);
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveSleepingBag(compound);
        this.saveColor(compound);
        this.saveSleepingBagColor(compound);
        this.saveAbility(compound);
        this.saveTime(compound);
        this.saveName(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
    }

    @Override
    public void loadAllData(CompoundTag compound) {
        this.loadTier(compound);
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadSleepingBag(compound);
        this.loadColor(compound);
        this.loadSleepingBagColor(compound);
        this.loadAbility(compound);
        this.loadTime(compound);
        this.loadName(compound);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(compound);
        this.settingsManager.loadSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), this.player);
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.sleepingBagColor != DyeColor.RED.m_41060_();
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.sleepingBagColor;
        }
        return DyeColor.RED.m_41060_();
    }

    public void setSleepingBagColor(int colorId) {
        this.sleepingBagColor = colorId;
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().m_41720_()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
        this.setDataChanged();
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasBlockEntity() {
        return true;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    public void resetTier() {
        this.tier = Tiers.LEATHER;
        this.setDataChanged();
    }

    public Level m_58904_() {
        return super.m_58904_();
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.f_58857_.m_8055_(this.m_58899_()).m_60734_();
        if (block instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block2 = (TravelersBackpackBlock)block;
            return new ItemStack((ItemLike)block2);
        }
        return new ItemStack((ItemLike)ModBlocks.STANDARD_TRAVELERS_BACKPACK.get());
    }

    @Override
    public void setUsingPlayer(Player player) {
        this.player = player;
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
    }

    @Override
    public void setDataChanged() {
        if (!this.f_58857_.f_46443_) {
            super.m_6596_();
            this.notifyBlockUpdate();
        }
    }

    private void notifyBlockUpdate() {
        BlockState blockstate = this.m_58904_().m_8055_(this.m_58899_());
        this.m_58904_().m_6550_(this.m_58899_(), blockstate, blockstate);
        this.m_58904_().m_7260_(this.m_58899_(), blockstate, blockstate, 3);
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(Level level, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        Direction direction = this.getBlockDirection(level.m_7702_(this.m_58899_()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && level.m_8055_(sleepingBagPos2 = (sleepingBagPos1 = pos.m_142300_(direction)).m_142300_(direction)).m_60795_() && level.m_8055_(sleepingBagPos1).m_60795_() && level.m_8055_(sleepingBagPos1.m_7495_()).m_60838_((BlockGetter)level, sleepingBagPos1.m_7495_()) && level.m_8055_(sleepingBagPos2.m_7495_()).m_60838_((BlockGetter)level, sleepingBagPos2.m_7495_())) {
            level.m_5594_(null, sleepingBagPos2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (!level.f_46443_) {
                BlockState sleepingBagState = this.getProperSleepingBag(this.getSleepingBagColor());
                level.m_7731_(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.m_7731_(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.m_46672_(pos, sleepingBagState.m_60734_());
                level.m_46672_(sleepingBagPos2, sleepingBagState.m_60734_());
            }
            this.isSleepingBagDeployed = true;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(Level level) {
        Direction blockFacing = this.getBlockDirection(level.m_7702_(this.m_58899_()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            BlockPos sleepingBagPos1 = this.m_58899_().m_142300_(blockFacing);
            BlockPos sleepingBagPos2 = sleepingBagPos1.m_142300_(blockFacing);
            if (level.m_8055_(sleepingBagPos1).m_60734_() instanceof SleepingBagBlock && level.m_8055_(sleepingBagPos2).m_60734_() instanceof SleepingBagBlock) {
                level.m_5594_(null, sleepingBagPos2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
                level.m_7731_(sleepingBagPos2, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(sleepingBagPos1, Blocks.f_50016_.m_49966_(), 3);
                this.isSleepingBagDeployed = false;
                this.setDataChanged();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.setDataChanged();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.f_58857_.m_8055_(this.m_58899_().m_142300_(direction)).m_60734_() instanceof SleepingBagBlock && this.f_58857_.m_8055_(this.m_58899_().m_142300_(direction).m_142300_(direction)).m_60734_() instanceof SleepingBagBlock) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public BlockState getProperSleepingBag(int colorId) {
        return switch (colorId) {
            case 0 -> ((Block)ModBlocks.WHITE_SLEEPING_BAG.get()).m_49966_();
            case 1 -> ((Block)ModBlocks.ORANGE_SLEEPING_BAG.get()).m_49966_();
            case 2 -> ((Block)ModBlocks.MAGENTA_SLEEPING_BAG.get()).m_49966_();
            case 3 -> ((Block)ModBlocks.LIGHT_BLUE_SLEEPING_BAG.get()).m_49966_();
            case 4 -> ((Block)ModBlocks.YELLOW_SLEEPING_BAG.get()).m_49966_();
            case 5 -> ((Block)ModBlocks.LIME_SLEEPING_BAG.get()).m_49966_();
            case 6 -> ((Block)ModBlocks.PINK_SLEEPING_BAG.get()).m_49966_();
            case 7 -> ((Block)ModBlocks.GRAY_SLEEPING_BAG.get()).m_49966_();
            case 8 -> ((Block)ModBlocks.LIGHT_GRAY_SLEEPING_BAG.get()).m_49966_();
            case 9 -> ((Block)ModBlocks.CYAN_SLEEPING_BAG.get()).m_49966_();
            case 10 -> ((Block)ModBlocks.PURPLE_SLEEPING_BAG.get()).m_49966_();
            case 11 -> ((Block)ModBlocks.BLUE_SLEEPING_BAG.get()).m_49966_();
            case 12 -> ((Block)ModBlocks.BROWN_SLEEPING_BAG.get()).m_49966_();
            case 13 -> ((Block)ModBlocks.GREEN_SLEEPING_BAG.get()).m_49966_();
            case 14 -> ((Block)ModBlocks.RED_SLEEPING_BAG.get()).m_49966_();
            case 15 -> ((Block)ModBlocks.BLACK_SLEEPING_BAG.get()).m_49966_();
            default -> ((Block)ModBlocks.RED_SLEEPING_BAG.get()).m_49966_();
        };
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_.m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public Direction getBlockDirection(BlockEntity blockEntity) {
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            if (this.f_58857_ == null || !(this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof TravelersBackpackBlock)) {
                return Direction.NORTH;
            }
            return (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)TravelersBackpackBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean hasData() {
        boolean isDefaultTier = this.getTier() == Tiers.LEATHER;
        boolean isInvEmpty = ContainerUtils.isEmpty(this.getHandler());
        boolean isCraftingGridEmpty = ContainerUtils.isEmpty(this.getCraftingGridHandler());
        boolean leftTankEmpty = this.getLeftTank().isEmpty();
        boolean rightTankEmpty = this.getRightTank().isEmpty();
        boolean hasColor = this.hasColor();
        boolean hasSleepingBagColor = this.hasSleepingBagColor();
        boolean hasTime = this.getLastTime() != 0;
        boolean hasUnsortableSlots = !this.slotManager.getUnsortableSlots().isEmpty();
        boolean hasMemorySlots = !this.slotManager.getMemorySlots().isEmpty();
        boolean hasCustomName = this.m_8077_();
        return !isDefaultTier || !isInvEmpty || !isCraftingGridEmpty || !leftTankEmpty || !rightTankEmpty || hasColor || hasSleepingBagColor || hasTime || hasUnsortableSlots || hasMemorySlots || hasCustomName;
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        this.saveTier(compound);
        this.saveTanks(compound);
        this.saveItems(compound);
        if (this.hasColor()) {
            this.saveColor(compound);
        }
        if (this.hasSleepingBagColor()) {
            this.saveSleepingBagColor(compound);
        }
        this.saveAbility(compound);
        this.saveTime(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
        stack.m_41751_(compound);
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component getDefaultName() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 3, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, blockEntity.getItemStack())) {
            if (blockEntity.getLastTime() > 0) {
                blockEntity.setLastTime(blockEntity.getLastTime() - 1);
                blockEntity.setDataChanged();
            }
            BackpackAbilities.ABILITIES.abilityTick(null, null, blockEntity);
        }
    }

    public void openGUI(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.f_19853_.f_46443_ && this.player == null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, (BlockPos)pos);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TravelersBackpackBlockEntityMenu(id, inventory, this);
    }

    private ItemStackHandler createHandler(int size, final boolean isInventory) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackBlockEntity.this.setDataChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ResourceLocation blacklistedItems = new ResourceLocation("travelersbackpack", "blacklisted_items");
                return !(stack.m_41720_() instanceof TravelersBackpackItem) && !stack.m_150922_(ItemTags.m_13193_().m_13404_(blacklistedItems));
            }

            public void deserializeNBT(CompoundTag nbt) {
                if (isInventory) {
                    if (TravelersBackpackBlockEntity.this.getTier() == Tiers.LEATHER) {
                        int size;
                        int n = size = nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size();
                        if (size == 45) {
                            TravelersBackpackBlockEntity.this.tier = Tiers.DIAMOND;
                        }
                    }
                    this.setSize(TravelersBackpackBlockEntity.this.tier.getAllSlots());
                    ListTag tagList = nbt.m_128437_("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundTag itemTags = tagList.m_128728_(i);
                        int slot = itemTags.m_128451_("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
                    }
                    this.onLoad();
                } else {
                    super.deserializeNBT(nbt);
                }
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackBlockEntity.this.setDataChanged();
            }

            public FluidTank readFromNBT(CompoundTag nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setCapacity(TravelersBackpackBlockEntity.this.tier.getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction direction = this.getBlockDirection(this);
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapability.cast();
            }
            switch (side) {
                case DOWN: 
                case UP: {
                    return this.inventoryCapability.cast();
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    if (side != direction && side != direction.m_122424_()) break;
                    return this.craftingInventoryCapability.cast();
                }
            }
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.leftFluidTankCapability.cast();
            }
            if (direction == Direction.NORTH) {
                switch (side) {
                    case WEST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case EAST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.SOUTH) {
                switch (side) {
                    case EAST: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case WEST: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.EAST) {
                switch (side) {
                    case NORTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case SOUTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
            if (direction == Direction.WEST) {
                switch (side) {
                    case SOUTH: {
                        return this.rightFluidTankCapability.cast();
                    }
                    case NORTH: {
                        return this.leftFluidTankCapability.cast();
                    }
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.craftingInventoryCapability.invalidate();
        this.leftFluidTankCapability.invalidate();
        this.rightFluidTankCapability.invalidate();
    }
}

