/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class TravelersBackpackWearable
implements ITravelersBackpack {
    private ItemStack wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
    private final Player playerEntity;
    private final TravelersBackpackContainer container;

    public TravelersBackpackWearable(Player playerEntity) {
        this.playerEntity = playerEntity;
        this.container = new TravelersBackpackContainer(this.wearable, playerEntity, 2);
    }

    @Override
    public boolean hasWearable() {
        return !this.wearable.m_41619_();
    }

    @Override
    public ItemStack getWearable() {
        return this.wearable;
    }

    @Override
    public void setWearable(ItemStack stack) {
        this.wearable = stack;
    }

    @Override
    public void removeWearable() {
        this.wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
        this.container.setStack(new ItemStack((ItemLike)Items.f_41852_, 0));
    }

    @Override
    public TravelersBackpackContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContents(ItemStack stack) {
        this.container.setStack(stack);
        if (!stack.m_41619_()) {
            this.container.loadAllData(stack.m_41784_());
        }
    }

    @Override
    public void synchronise() {
        if (this.playerEntity != null && !this.playerEntity.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)this.playerEntity;
            CapabilityUtils.getCapability((Player)serverPlayer).ifPresent(cap -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncCapabilityPacket(this.wearable.m_41739_(new CompoundTag()), serverPlayer.m_142049_(), true)));
        }
    }

    @Override
    public void synchroniseToOthers(Player player) {
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityUtils.getCapability((Player)serverPlayer).ifPresent(cap -> TravelersBackpack.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> serverPlayer), (Object)new ClientboundSyncCapabilityPacket(this.wearable.m_41739_(new CompoundTag()), serverPlayer.m_142049_(), true)));
        }
    }

    @Override
    public CompoundTag saveTag() {
        ItemStack wearable;
        CompoundTag compound = new CompoundTag();
        if (this.hasWearable()) {
            wearable = this.getWearable();
            wearable.m_41739_(compound);
        }
        if (!this.hasWearable()) {
            wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
            wearable.m_41739_(compound);
        }
        return compound;
    }

    @Override
    public void loadTag(CompoundTag compoundTag) {
        ItemStack wearable = ItemStack.m_41712_((CompoundTag)compoundTag);
        this.setWearable(wearable);
        this.setContents(wearable);
    }
}

