/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability.entity;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class TravelersBackpackEntityWearable
implements IEntityTravelersBackpack {
    private ItemStack wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
    private final LivingEntity livingEntity;

    public TravelersBackpackEntityWearable(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public boolean hasWearable() {
        return !this.wearable.m_41619_();
    }

    @Override
    public ItemStack getWearable() {
        return this.wearable;
    }

    @Override
    public void setWearable(ItemStack stack) {
        this.wearable = stack;
    }

    @Override
    public void removeWearable() {
        this.wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
    }

    @Override
    public void synchronise() {
        if (this.livingEntity != null && !this.livingEntity.f_19853_.f_46443_) {
            CapabilityUtils.getEntityCapability(this.livingEntity).ifPresent(cap -> TravelersBackpack.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.livingEntity), (Object)new ClientboundSyncCapabilityPacket(this.wearable.m_41739_(new CompoundTag()), this.livingEntity.m_142049_(), false)));
        }
    }

    @Override
    public CompoundTag saveTag() {
        ItemStack wearable;
        CompoundTag compound = new CompoundTag();
        if (this.hasWearable()) {
            wearable = this.getWearable();
            wearable.m_41739_(compound);
        }
        if (!this.hasWearable()) {
            wearable = new ItemStack((ItemLike)Items.f_41852_, 0);
            wearable.m_41739_(compound);
        }
        return compound;
    }

    @Override
    public void loadTag(CompoundTag compoundTag) {
        ItemStack wearable = ItemStack.m_41712_((CompoundTag)compoundTag);
        this.setWearable(wearable);
    }
}

