/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RestoreBackpackCommand {
    public RestoreBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"backpack_id", (ArgumentType)UuidArgument.m_113850_()).executes(source -> this.restoreBackpack((CommandSourceStack)source.getSource(), UuidArgument.m_113853_((CommandContext)source, (String)"backpack_id"), EntityArgument.m_91474_((CommandContext)source, (String)"target"))))));
        dispatcher.register(tbCommand);
    }

    public int restoreBackpack(CommandSourceStack source, UUID backpackID, ServerPlayer player) throws CommandSyntaxException {
        ItemStack backpack = BackpackManager.getBackpack(player.m_9236_(), backpackID);
        if (backpack == null) {
            source.m_81352_((Component)new TextComponent("Backpack with ID " + backpackID.toString() + " not found"));
            return 0;
        }
        if (!player.m_150109_().m_36054_(backpack)) {
            player.m_36176_(backpack, false);
        }
        source.m_81354_((Component)new TextComponent("Successfully restored " + player.m_5446_().getString() + "'s backpack"), true);
        return 1;
    }
}

