/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.effects.LavaEffect;
import com.tiviacz.travelersbackpack.fluids.effects.MilkEffect;
import com.tiviacz.travelersbackpack.fluids.effects.PotionEffect;
import com.tiviacz.travelersbackpack.fluids.effects.WaterEffect;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public class EffectFluidRegistry {
    public static BiMap<String, EffectFluid> EFFECT_REGISTRY = HashBiMap.create();
    public static EffectFluid WATER_EFFECT;
    public static EffectFluid LAVA_EFFECT;
    public static EffectFluid POTION_EFFECT;
    public static EffectFluid MILK_EFFECT;
    public static EffectFluid CREATE_POTION_EFFECT;
    public static EffectFluid TINKERS_CONSTRUCT_POTION_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new WaterEffect();
        LAVA_EFFECT = new LavaEffect();
        POTION_EFFECT = new PotionEffect("travelersbackpack:potion", (Fluid)ModFluids.POTION_FLUID.get());
        MILK_EFFECT = new MilkEffect();
        if (EffectFluidRegistry.canInitialize("create")) {
            CREATE_POTION_EFFECT = new PotionEffect("create:potion", "create", "potion");
        }
        if (EffectFluidRegistry.canInitialize("tconstruct")) {
            TINKERS_CONSTRUCT_POTION_EFFECT = new PotionEffect("tconstruct:potion", "tconstruct", "potion");
        }
    }

    public static int registerFluidEffect(EffectFluid effect) {
        String uniqueId = effect.getUniqueId();
        if (!EFFECT_REGISTRY.containsKey((Object)uniqueId) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)uniqueId, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the FluidEffect with Unique ID of " + uniqueId + " for " + effect.fluid.getAttributes().getDisplayName(new FluidStack(effect.fluid, 1000)).getString() + " (Fluid Amount Required: " + effect.amountRequired + ") with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static Map<String, EffectFluid> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static int getHighestFluidEffectAmount(Fluid fluid) {
        int amount = 0;
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(fluid)) {
            if (effect.amountRequired <= amount) continue;
            amount = effect.amountRequired;
        }
        return amount;
    }

    public static ArrayList<EffectFluid> getEffectsForFluid(Fluid fluid) {
        ArrayList<EffectFluid> effectsForFluid = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean hasEffects(FluidStack fluid) {
        ArrayList<EffectFluid> effects = EffectFluidRegistry.getEffectsForFluid(fluid.getFluid());
        return !effects.isEmpty();
    }

    public static boolean hasExecutableEffects(FluidStack fluid, Level level, Entity entity) {
        List<EffectFluid> executableEffects = EffectFluidRegistry.getExecutableEffects(fluid, level, entity);
        return !executableEffects.isEmpty();
    }

    public static List<EffectFluid> getExecutableEffects(FluidStack fluid, Level level, Entity entity) {
        ArrayList<EffectFluid> executableEffects = new ArrayList<EffectFluid>();
        for (EffectFluid effect : EffectFluidRegistry.getEffectsForFluid(fluid.getFluid())) {
            if (!effect.canExecuteEffect(fluid, level, entity)) continue;
            executableEffects.add(effect);
        }
        return executableEffects;
    }

    public static boolean executeEffects(FluidStack fluid, Entity entity, Level level) {
        for (EffectFluid effect : EffectFluidRegistry.getExecutableEffects(fluid, level, entity)) {
            effect.affectDrinker(fluid, level, entity);
        }
        return true;
    }

    public static boolean canInitialize(String modid) {
        return ModList.get().isLoaded(modid);
    }

    static {
        effectIDCounter = 0;
    }
}

