/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class PotionAttributes
extends FluidAttributes {
    private static final int EMPTY_COLOR = 0xF800F8;

    protected PotionAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
    }

    public String getTranslationKey() {
        return "item.minecraft.potion.effect.empty";
    }

    public String getTranslationKey(FluidStack stack) {
        return PotionUtils.m_43577_((CompoundTag)stack.getTag()).m_43492_("item.minecraft.potion.effect.");
    }

    public Component getDisplayName(FluidStack stack) {
        return new TranslatableComponent(this.getTranslationKey(stack));
    }

    public int getColor() {
        return -524040;
    }

    public int getColor(FluidStack stack) {
        return PotionAttributes.getColor(stack.getTag()) | 0xFF000000;
    }

    private static int getColor(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
            return tag.m_128451_("CustomPotionColor");
        }
        if (PotionUtils.m_43577_((CompoundTag)tag) == Potions.f_43598_) {
            return 0xF800F8;
        }
        return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag));
    }

    public static class PotionBuilder
    extends FluidAttributes.Builder {
        public PotionBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(stillTexture, flowingTexture, PotionAttributes::new);
        }
    }
}

