/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class Tiers {
    public static final Tier LEATHER = new Tier("leather", 20, 2000, 153, 0);
    public static final Tier IRON = new Tier("iron", 30, 3000, 171, 18);
    public static final Tier GOLD = new Tier("gold", 40, 4000, 189, 36);
    public static final Tier DIAMOND = new Tier("diamond", 50, 5000, 207, 54);
    public static final Tier NETHERITE = new Tier("netherite", 60, 6000, 225, 72);
    public static final String TIER = "Tier";

    public static Tier of(String name) {
        return switch (name) {
            case "leather" -> LEATHER;
            case "iron" -> IRON;
            case "gold" -> GOLD;
            case "diamond" -> DIAMOND;
            case "netherite" -> NETHERITE;
            default -> LEATHER;
        };
    }

    public static Tier of(int ordinal) {
        return switch (ordinal) {
            case 0 -> LEATHER;
            case 1 -> IRON;
            case 2 -> GOLD;
            case 3 -> DIAMOND;
            case 4 -> NETHERITE;
            default -> LEATHER;
        };
    }

    public static class Tier {
        public final String name;
        public final int storageSlots;
        public final int tankCapacity;
        public final int imageHeight;
        public final int menuSlotPlacementFactor;

        public Tier(String name, int storageSlots, int tankCapacity, int imageHeight, int menuSlotPlacementFactor) {
            this.name = name;
            this.storageSlots = storageSlots;
            this.tankCapacity = tankCapacity;
            this.imageHeight = imageHeight;
            this.menuSlotPlacementFactor = menuSlotPlacementFactor;
        }

        public String getName() {
            return this.name;
        }

        public int getAllSlots() {
            return this.storageSlots;
        }

        public int getStorageSlots() {
            return this.storageSlots - this.getToolSlots();
        }

        public int getStorageSlotsWithCrafting() {
            return this.getStorageSlots() + 9;
        }

        public int getToolSlots() {
            if (this == LEATHER) {
                return 2;
            }
            if (this == IRON) {
                return 3;
            }
            if (this == GOLD) {
                return 4;
            }
            if (this == DIAMOND) {
                return 5;
            }
            if (this == NETHERITE) {
                return 6;
            }
            return this.getAllSlots() - this.getStorageSlots();
        }

        public int getTankCapacity() {
            return TravelersBackpackConfig.tanksCapacity.get(this.getOrdinal());
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public int getMenuSlotPlacementFactor() {
            return this.menuSlotPlacementFactor;
        }

        public Tier getNextTier() {
            if (this == LEATHER) {
                return IRON;
            }
            if (this == IRON) {
                return GOLD;
            }
            if (this == GOLD) {
                return DIAMOND;
            }
            if (this == DIAMOND) {
                return NETHERITE;
            }
            return LEATHER;
        }

        public int getOrdinal() {
            if (this == LEATHER) {
                return 0;
            }
            if (this == IRON) {
                return 1;
            }
            if (this == GOLD) {
                return 2;
            }
            if (this == DIAMOND) {
                return 3;
            }
            if (this == NETHERITE) {
                return 4;
            }
            return -1;
        }

        public int getSlotIndex(SlotType slotType) {
            return switch (slotType) {
                case SlotType.TOOL_FIRST -> 18 + (this.getStorageSlots() - LEATHER.getStorageSlots());
                case SlotType.TOOL_SECOND -> 19 + (this.getStorageSlots() - LEATHER.getStorageSlots());
                case SlotType.BUCKET_IN_LEFT -> 0;
                case SlotType.BUCKET_OUT_LEFT -> 1;
                case SlotType.BUCKET_IN_RIGHT -> 2;
                case SlotType.BUCKET_OUT_RIGHT -> 3;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        public int getTankRenderPos() {
            if (this == LEATHER) {
                return 46;
            }
            if (this == IRON) {
                return 64;
            }
            if (this == GOLD) {
                return 82;
            }
            if (this == DIAMOND) {
                return 100;
            }
            if (this == NETHERITE) {
                return 118;
            }
            return -1;
        }

        public int getAbilitySliderRenderPos() {
            if (this == LEATHER || this == IRON) {
                return 26;
            }
            return 56;
        }

        public Item getTierUpgradeIngredient() {
            if (this == LEATHER) {
                return (Item)ModItems.IRON_TIER_UPGRADE.get();
            }
            if (this == IRON) {
                return (Item)ModItems.GOLD_TIER_UPGRADE.get();
            }
            if (this == GOLD) {
                return (Item)ModItems.DIAMOND_TIER_UPGRADE.get();
            }
            if (this == DIAMOND) {
                return (Item)ModItems.NETHERITE_TIER_UPGRADE.get();
            }
            return Items.f_41852_;
        }

        public int[] getSortOrder(boolean isCraftingLocked) {
            int[] slots = new int[this.getStorageSlotsWithCrafting()];
            int slot = 0;
            int i = 0;
            while (i <= this.getStorageSlots() - LEATHER.getStorageSlots()) {
                slots[i] = i;
                slot = i++;
            }
            if (!isCraftingLocked) {
                for (i = slot; i < this.getStorageSlotsWithCrafting(); ++i) {
                    slots[i] = i;
                }
            } else {
                int counter = 0;
                int craftingSlot = this.getStorageSlots();
                int j = slot;
                for (int i2 = slot; i2 < slots.length; ++i2) {
                    if (counter < 6) {
                        slots[i2] = j++;
                        ++counter;
                        continue;
                    }
                    slots[i2] = craftingSlot++;
                    if (++counter != 9) continue;
                    counter = 0;
                }
            }
            return slots;
        }
    }

    public static enum SlotType {
        TOOL_FIRST,
        TOOL_SECOND,
        BUCKET_IN_LEFT,
        BUCKET_OUT_LEFT,
        BUCKET_IN_RIGHT,
        BUCKET_OUT_RIGHT;

    }
}

