/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ToolSlotItemHandler
extends SlotItemHandler {
    private final Player player;
    private final ITravelersBackpackContainer container;
    public static final List<Item> TOOL_SLOTS_ACCEPTABLE_ITEMS = new ArrayList<Item>();

    public ToolSlotItemHandler(Player player, ITravelersBackpackContainer container, int index, int xPosition, int yPosition) {
        super((IItemHandler)container.getHandler(), index, xPosition, yPosition);
        this.player = player;
        this.container = container;
    }

    public boolean canAccessPlace() {
        return true;
    }

    public boolean canAccessPickup() {
        return true;
    }

    public boolean m_6659_() {
        return this.container.getSettingsManager().showToolSlots();
    }

    public boolean m_5857_(@Nonnull ItemStack stack) {
        return ToolSlotItemHandler.isValid(stack) && this.m_6659_();
    }

    public static boolean isValid(ItemStack stack) {
        ResourceLocation acceptableToolsTag = new ResourceLocation("travelersbackpack", "acceptable_tools");
        if (stack.m_150922_(ItemTags.m_13193_().m_13404_(acceptableToolsTag))) {
            return true;
        }
        if (TOOL_SLOTS_ACCEPTABLE_ITEMS.contains(stack.m_41720_())) {
            return true;
        }
        if (stack.m_41741_() == 1) {
            if (TravelersBackpackConfig.toolSlotsAcceptSwords && stack.m_41720_() instanceof SwordItem) {
                return true;
            }
            return stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof HoeItem || stack.m_41720_() instanceof FishingRodItem || stack.m_41720_() instanceof ShearsItem || stack.m_41720_() instanceof FlintAndSteelItem || stack.m_41720_() instanceof ProjectileWeaponItem;
        }
        return false;
    }

    public void m_6654_() {
        super.m_6654_();
        if (this.container.getScreenID() == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }
}

