/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SortType;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class ContainerSorter {
    public static final byte SORT_BACKPACK = 0;
    public static final byte QUICK_STACK = 1;
    public static final byte TRANSFER_TO_BACKPACK = 2;
    public static final byte TRANSFER_TO_PLAYER = 3;
    public static final byte SORT = 4;
    public static final byte MEMORY = 5;

    public static void selectSort(ITravelersBackpackContainer container, Player player, byte button, boolean shiftPressed) {
        if (button == 0) {
            ContainerSorter.sortBackpack(container, player, SortType.Type.CATEGORY, shiftPressed);
        } else if (button == 1) {
            ContainerSorter.quickStackToBackpackNoSort(container, player, shiftPressed);
        } else if (button == 2) {
            ContainerSorter.transferToBackpackNoSort(container, player, shiftPressed);
        } else if (button == 3) {
            ContainerSorter.transferToPlayer(container, player);
        } else if (button == 4) {
            ContainerSorter.setUnsortable(container, player, shiftPressed);
        } else if (button == 5) {
            ContainerSorter.setMemory(container, player, shiftPressed);
        }
    }

    public static void sortBackpack(ITravelersBackpackContainer container, Player player, SortType.Type type, boolean shiftPressed) {
        if (!container.getSlotManager().isSelectorActive((byte)0)) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(container, container.getCombinedHandler(), 0, container.getTier().getStorageSlotsWithCrafting());
            for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
                if (container.getSettingsManager().isCraftingGridLocked() && container.getSlotManager().isSlot((byte)2, i)) continue;
                ContainerSorter.addStackWithMerge(stacks, container.getSlotManager().isSlot((byte)0, i) ? ItemStack.f_41583_ : rangedWrapper.getStackInSlot(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(Comparator.comparing(stack -> SortType.getStringForSort(stack, type)));
            }
            if (stacks.size() == 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
                if (container.getSettingsManager().isCraftingGridLocked() && container.getSlotManager().isSlot((byte)2, i) || container.getSlotManager().isSlot((byte)0, i)) continue;
                rangedWrapper.setStackInSlot(i, j < stacks.size() ? (ItemStack)stacks.get(j) : ItemStack.f_41583_);
                ++j;
            }
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof TravelersBackpackBaseMenu) {
                TravelersBackpackBaseMenu menu = (TravelersBackpackBaseMenu)abstractContainerMenu;
                menu.m_6199_((Container)menu.craftSlots);
            }
            container.setDataChanged(2);
        }
    }

    public static void quickStackToBackpackNoSort(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks = new InvWrapper((Container)player.m_150109_());
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.m_41619_() || container.getScreenID() == 1 && i == player.m_150109_().f_35977_)) {
                CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(container, (IItemHandlerModifiable)(container.getSettingsManager().isCraftingGridLocked() ? container.getHandler() : container.getCombinedHandler()), 0, container.getSettingsManager().isCraftingGridLocked() ? container.getTier().getStorageSlots() : container.getTier().getStorageSlotsWithCrafting());
                boolean hasExistingStack = IntStream.range(0, rangedWrapper.getSlots()).mapToObj(arg_0 -> ((CustomRangedWrapper)rangedWrapper).getStackInSlot(arg_0)).filter(existing -> !existing.m_41619_()).anyMatch(existing -> existing.m_41720_() == playerStack.m_41720_());
                if (hasExistingStack) {
                    ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < rangedWrapper.getSlots() && !(ext = rangedWrapper.insertItem(j, ext, false)).m_41619_(); ++j) {
                    }
                    if (!ext.m_41619_()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
            ++i;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof TravelersBackpackBaseMenu) {
            TravelersBackpackBaseMenu menu = (TravelersBackpackBaseMenu)abstractContainerMenu;
            menu.m_6199_((Container)menu.craftSlots);
        }
    }

    public static void transferToBackpackNoSort(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks;
        block11: {
            playerStacks = new InvWrapper((Container)player.m_150109_());
            if (container.getSlotManager().getMemorySlots().isEmpty()) break block11;
            for (Pair<Integer, ItemStack> pair : container.getSlotManager().getMemorySlots()) {
                int firstCraftSlot;
                int i2;
                if (container.getSettingsManager().isCraftingGridLocked() && ((i2 = ((Integer)pair.getFirst()).intValue()) == (firstCraftSlot = container.getTier().getStorageSlots() - Tiers.LEATHER.getStorageSlots() + 5) || i2 == firstCraftSlot + 1 || i2 == firstCraftSlot + 2 || i2 == firstCraftSlot + 8 || i2 == firstCraftSlot + 9 || i2 == firstCraftSlot + 10 || i2 == firstCraftSlot + 16 || i2 == firstCraftSlot + 17 || i2 == firstCraftSlot + 18)) continue;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block12: {
                        ItemStack ext;
                        block13: {
                            ItemStack playerStack = playerStacks.getStackInSlot(i2);
                            if (playerStack.m_41619_() || container.getScreenID() == 1 && i2 == player.m_150109_().f_35977_) break block12;
                            CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(container, container.getCombinedHandler(), 0, container.getTier().getStorageSlotsWithCrafting());
                            ItemStack extSimulate = playerStacks.extractItem(i2, Integer.MAX_VALUE, true);
                            ext = ItemStack.f_41583_;
                            if (!ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), extSimulate)) break block13;
                            ext = playerStacks.extractItem(i2, Integer.MAX_VALUE, false);
                            ext = rangedWrapper.insertItem((Integer)pair.getFirst(), ext, false);
                            if (ext.m_41619_()) break block12;
                        }
                        if (!ext.m_41619_()) {
                            playerStacks.insertItem(i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.m_41619_() || container.getScreenID() == 1 && i == player.m_150109_().f_35977_)) {
                CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(container, (IItemHandlerModifiable)(container.getSettingsManager().isCraftingGridLocked() ? container.getHandler() : container.getCombinedHandler()), 0, container.getSettingsManager().isCraftingGridLocked() ? container.getTier().getStorageSlots() : container.getTier().getStorageSlotsWithCrafting());
                ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                for (int j = 0; j < rangedWrapper.getSlots() && !(ext = rangedWrapper.insertItem(j, ext, false)).m_41619_(); ++j) {
                }
                if (!ext.m_41619_()) {
                    playerStacks.insertItem(i, ext, false);
                }
            }
            ++i;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof TravelersBackpackBaseMenu) {
            TravelersBackpackBaseMenu menu = (TravelersBackpackBaseMenu)abstractContainerMenu;
            menu.m_6199_((Container)menu.craftSlots);
        }
    }

    public static void transferToPlayer(ITravelersBackpackContainer container, Player player) {
        InvWrapper playerStacks = new InvWrapper((Container)player.m_150109_());
        CustomRangedWrapper rangedWrapper = new CustomRangedWrapper(container, (IItemHandlerModifiable)(container.getSettingsManager().isCraftingGridLocked() ? container.getHandler() : container.getCombinedHandler()), 0, container.getSettingsManager().isCraftingGridLocked() ? container.getTier().getStorageSlots() : container.getTier().getStorageSlotsWithCrafting());
        for (int i = 0; i < rangedWrapper.getSlots(); ++i) {
            ItemStack stack = rangedWrapper.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack ext = rangedWrapper.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = playerStacks.insertItem(j, ext, false)).m_41619_(); ++j) {
            }
            if (ext.m_41619_()) continue;
            rangedWrapper.isTransferToPlayer = true;
            rangedWrapper.insertItem(i, ext, false);
            rangedWrapper.isTransferToPlayer = false;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof TravelersBackpackBaseMenu) {
            TravelersBackpackBaseMenu menu = (TravelersBackpackBaseMenu)abstractContainerMenu;
            menu.m_6199_((Container)menu.craftSlots);
        }
    }

    public static void setUnsortable(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)0, !container.getSlotManager().isSelectorActive((byte)0));
    }

    public static void setMemory(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)1, !container.getSlotManager().isSelectorActive((byte)5));
    }

    private static void addStackWithMerge(List<ItemStack> stacks, ItemStack newStack) {
        if (newStack.m_41619_()) {
            return;
        }
        if (newStack.m_41753_() && newStack.m_41613_() != newStack.m_41741_()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ItemStack oldStack = stacks.get(j);
                if (!ContainerSorter.canMergeItems(newStack, oldStack)) continue;
                ContainerSorter.combineStacks(newStack, oldStack);
                if (!oldStack.m_41619_() && oldStack.m_41613_() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(ItemStack stack, ItemStack stack2) {
        if (stack.m_41741_() >= stack.m_41613_() + stack2.m_41613_()) {
            stack.m_41769_(stack2.m_41613_());
            stack2.m_41764_(0);
        }
        int maxInsertAmount = Math.min(stack.m_41741_() - stack.m_41613_(), stack2.m_41613_());
        stack.m_41769_(maxInsertAmount);
        stack2.m_41774_(maxInsertAmount);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41753_() || !stack2.m_41753_()) {
            return false;
        }
        if (stack1.m_41613_() == stack2.m_41741_() || stack2.m_41613_() == stack2.m_41741_()) {
            return false;
        }
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class CustomRangedWrapper
    extends RangedWrapper {
        private final ITravelersBackpackContainer container;
        public boolean isTransferToPlayer;

        public CustomRangedWrapper(ITravelersBackpackContainer container, IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
            this(container, compose, minSlot, maxSlotExclusive, false);
        }

        public CustomRangedWrapper(ITravelersBackpackContainer container, IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive, boolean isTransferToPlayer) {
            super(compose, minSlot, maxSlotExclusive);
            this.container = container;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.container.getSlotManager().isSlot((byte)1, slot)) {
                return this.container.getSlotManager().getMemorySlots().stream().noneMatch(pair -> (Integer)pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), stack)) && !this.isTransferToPlayer ? stack : super.insertItem(slot, stack, simulate);
            }
            return this.container.getSlotManager().isSlot((byte)0, slot) ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.container.getSlotManager().isSlot((byte)0, slot) ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
        }
    }
}

