/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ServerboundMemoryPacket {
    private final byte screenID;
    private final boolean isActive;
    private final int[] selectedSlots;
    private final ItemStack[] stacks;

    public ServerboundMemoryPacket(byte screenID, boolean isActive, int[] selectedSlots, ItemStack[] stacks) {
        this.screenID = screenID;
        this.isActive = isActive;
        this.selectedSlots = selectedSlots;
        this.stacks = stacks;
    }

    public static ServerboundMemoryPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        boolean isActive = buffer.readBoolean();
        int[] selectedSlots = buffer.m_130100_();
        ItemStack[] stacks = new ItemStack[selectedSlots.length];
        for (int i = 0; i < selectedSlots.length; ++i) {
            stacks[i] = buffer.m_130267_();
        }
        return new ServerboundMemoryPacket(screenID, isActive, selectedSlots, stacks);
    }

    public static void encode(ServerboundMemoryPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.isActive);
        buffer.m_130089_(message.selectedSlots);
        for (int i = 0; i < message.selectedSlots.length; ++i) {
            buffer.m_130055_(message.stacks[i]);
        }
    }

    public static void handle(ServerboundMemoryPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                SlotManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((Player)serverPlayer).getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemMenu)serverPlayer.f_36096_).container.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackBlockEntityMenu)serverPlayer.f_36096_).container.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

