/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BackpackUpgradeRecipeBuilder {
    private final Ingredient base;
    private final Ingredient addition;
    private final Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final RecipeSerializer<?> type;

    public BackpackUpgradeRecipeBuilder(RecipeSerializer<?> p_126381_, Ingredient p_126382_, Ingredient p_126383_, Item p_126384_) {
        this.type = p_126381_;
        this.base = p_126382_;
        this.addition = p_126383_;
        this.result = p_126384_;
    }

    public static BackpackUpgradeRecipeBuilder upgrade(Ingredient p_126386_, Ingredient p_126387_, Item p_126388_) {
        return new BackpackUpgradeRecipeBuilder((RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get(), p_126386_, p_126387_, p_126388_);
    }

    public BackpackUpgradeRecipeBuilder unlocks(String p_126390_, CriterionTriggerInstance p_126391_) {
        this.advancement.m_138386_(p_126390_, p_126391_);
        return this;
    }

    public void save(Consumer<FinishedRecipe> p_126393_, String p_126394_) {
        this.save(p_126393_, new ResourceLocation(p_126394_));
    }

    public void save(Consumer<FinishedRecipe> p_126396_, ResourceLocation p_126397_) {
        this.ensureValid(p_126397_);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126397_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126397_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126396_.accept(new Result(p_126397_, this.type, this.base, this.addition, this.result, this.advancement, new ResourceLocation(p_126397_.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + p_126397_.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126399_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126399_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient base;
        private final Ingredient addition;
        private final Item result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<?> type;

        public Result(ResourceLocation p_126408_, RecipeSerializer<?> p_126409_, Ingredient p_126410_, Ingredient p_126411_, Item p_126412_, Advancement.Builder p_126413_, ResourceLocation p_126414_) {
            this.id = p_126408_;
            this.type = p_126409_;
            this.base = p_126410_;
            this.addition = p_126411_;
            this.result = p_126412_;
            this.advancement = p_126413_;
            this.advancementId = p_126414_;
        }

        public void m_7917_(JsonObject p_126416_) {
            p_126416_.add("base", this.base.m_43942_());
            p_126416_.add("addition", this.addition.m_43942_());
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            p_126416_.add("result", (JsonElement)jsonobject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

