/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;

public class SortType {
    static String getStringForSort(ItemStack stack, Type type) {
        Item item = stack.m_41720_();
        String itemName = SortType.specialCases(stack);
        CreativeModeTab group = item.m_41471_();
        return (group != null ? SortType.getTabID(group.m_40775_()) : "999") + Registry.f_122827_.m_7447_((Object)item) + itemName;
    }

    public static String getTabID(int tabID) {
        return tabID < 10 ? "00" + tabID : (tabID < 100 ? "0" + tabID : "999");
    }

    private static String specialCases(ItemStack stack) {
        Item item = stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        if (stack.m_41613_() != stack.m_41741_()) {
            return SortType.stackSize(stack);
        }
        if (item instanceof EnchantedBookItem) {
            return SortType.enchantedBookNameCase(stack);
        }
        if (item instanceof TieredItem) {
            return SortType.toolDuribilityCase(stack);
        }
        return item.m_5671_(stack);
    }

    private static String stackSize(ItemStack stack) {
        return stack.m_41720_().toString() + stack.m_41613_();
    }

    private static String enchantedBookNameCase(ItemStack stack) {
        ListTag enchants = EnchantedBookItem.m_41163_((ItemStack)stack);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (int i = 0; i < enchants.size(); ++i) {
            Enchantment enchant;
            CompoundTag enchantTag = enchants.m_128728_(i);
            ResourceLocation enchantID = ResourceLocation.m_135820_((String)enchantTag.m_128461_("id"));
            if (enchantID == null || (enchant = (Enchantment)Registry.f_122825_.m_7745_(enchantID)) == null) continue;
            names.add(enchant.m_44700_(enchantTag.m_128451_("lvl")).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return stack.m_41720_() + " " + enchants.size() + " " + enchantNames;
    }

    private static String toolDuribilityCase(ItemStack stack) {
        return stack.m_41720_().toString() + stack.m_41773_();
    }

    public static enum Type {
        NAME,
        MOD,
        CATEGORY;

    }
}

