/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TierUpgradeItem
extends Item {
    private final Tiers.Tier tier;

    public TierUpgradeItem(Item.Properties pProperties, Tiers.Tier tier) {
        super(pProperties);
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (TravelersBackpackConfig.enableTierUpgrades) {
            if (this != ModItems.BLANK_UPGRADE.get()) {
                tooltip.add((Component)new TranslatableComponent("item.travelersbackpack.tier_upgrade_tooltip", new Object[]{this.tier.getName()}).m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)new TranslatableComponent("item.travelersbackpack.blank_upgrade_tooltip").m_130940_(ChatFormatting.BLUE));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("item.travelersbackpack.tier_upgrade_disabled"));
        }
    }

    public static NonNullList<ItemStack> getUpgradesForTier(Tiers.Tier tier) {
        NonNullList list = NonNullList.m_122779_();
        if (tier.getOrdinal() >= 1) {
            list.add((Object)((Item)ModItems.IRON_TIER_UPGRADE.get()).m_7968_());
            if (tier.getOrdinal() >= 2) {
                list.add((Object)((Item)ModItems.GOLD_TIER_UPGRADE.get()).m_7968_());
                if (tier.getOrdinal() >= 3) {
                    list.add((Object)((Item)ModItems.DIAMOND_TIER_UPGRADE.get()).m_7968_());
                    if (tier.getOrdinal() >= 4) {
                        list.add((Object)((Item)ModItems.NETHERITE_TIER_UPGRADE.get()).m_7968_());
                    }
                }
            }
        }
        return list;
    }
}

