/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSlotPacket {
    private final byte screenID;
    private final boolean isActive;
    private final int[] selectedSlots;

    public ServerboundSlotPacket(byte screenID, boolean isActive, int[] selectedSlots) {
        this.screenID = screenID;
        this.isActive = isActive;
        this.selectedSlots = selectedSlots;
    }

    public static ServerboundSlotPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        boolean isActive = buffer.readBoolean();
        int[] selectedSlots = buffer.m_130100_();
        return new ServerboundSlotPacket(screenID, isActive, selectedSlots);
    }

    public static void encode(ServerboundSlotPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.isActive);
        buffer.m_130089_(message.selectedSlots);
    }

    public static void handle(ServerboundSlotPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                SlotManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((Player)serverPlayer).getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemMenu)serverPlayer.f_36096_).container.getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackBlockEntityMenu)serverPlayer.f_36096_).container.getSlotManager();
                    manager.setSelectorActive((byte)0, message.isActive);
                    manager.setUnsortableSlots(message.selectedSlots, true);
                    manager.setSelectorActive((byte)0, !message.isActive);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

