/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("49d951a4-ca9c-48b5-b549-61ef67ee53aa"), "NetheriteBackpackBonusArmor", 4.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("294425c4-8dc6-4640-a336-d9fd72950e20"), "DiamondBackpackBonusArmor", 3.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("fcf6706b-dfd9-40d6-aa25-62c4fb7a83fa"), "IronBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("21060f97-da7a-4460-a4e4-c94fae72ab00"), "GoldBackpackBonusArmor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier ENDERMAN_REACH_DISTANCE_MODIFIER = new AttributeModifier(UUID.fromString("a3d7a647-1ed9-4317-94c2-ca889cd33657"), "EndermanReachDistanceBonus", 1.0, AttributeModifier.Operation.ADDITION);
    private final TargetingConditions ocelotAbilityTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
    public static final List<Item> ALLOWED_ABILITIES = new ArrayList<Item>();
    public static final Item[] ALL_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_REMOVAL_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_ABILITIES_LIST = new Item[]{(Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};

    public void abilityTick(@Nullable ItemStack stack, @Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity == null) {
            if (stack.m_41720_() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.m_41720_() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.m_41720_() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
            }
            if (stack.m_41720_() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(player, null);
            }
            if (stack.m_41720_() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.m_41720_() == ModItems.CAKE_TRAVELERS_BACKPACK.get()) {
                this.cakeAbility(player);
            }
            if (stack.m_41720_() == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(player, null);
            }
            if (stack.m_41720_() == ModItems.DRAGON_TRAVELERS_BACKPACK.get()) {
                this.dragonAbility(player);
            }
            if (stack.m_41720_() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            }
            if (stack.m_41720_() == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
            }
            if (stack.m_41720_() == ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()) {
                this.magmaCubeAbility(player);
            }
            if (stack.m_41720_() == ModItems.SPIDER_TRAVELERS_BACKPACK.get()) {
                this.spiderAbility(player);
            }
            if (stack.m_41720_() == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                this.witherAbility(player);
            }
            if (stack.m_41720_() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                this.batAbility(player);
            }
            if (stack.m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
            }
            if (stack.m_41720_() == ModItems.COW_TRAVELERS_BACKPACK.get()) {
                this.cowAbility(player);
            }
            if (stack.m_41720_() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(player, false);
            }
            if (stack.m_41720_() == ModItems.SQUID_TRAVELERS_BACKPACK.get()) {
                this.squidAbility(player);
            }
        } else {
            Item item = blockEntity.getItemStack().m_41720_();
            if (item == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(null, blockEntity);
            }
        }
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack.m_41720_() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
    }

    public void animateTick(TravelersBackpackBlockEntity blockEntity, BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (blockEntity != null && blockEntity.getAbilityValue()) {
            Block block = stateIn.m_60734_();
            if (block == ModBlocks.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(null, blockEntity);
            }
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, blockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(blockEntity);
            }
        }
    }

    public void emeraldAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        Level level;
        Level level2 = level = player == null ? blockEntity.m_58904_() : player.f_19853_;
        if (player == null || level.f_46441_.m_188503_(10) == 1) {
            float f = level.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            float f1 = level.f_46441_.m_188501_() * 0.5f + 0.5f;
            float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, player == null ? (double)((float)blockEntity.m_58899_().m_123341_() + f2 + 0.5f) : player.m_20182_().f_82479_ + (double)f2, player == null ? (double)((float)blockEntity.m_58899_().m_123342_() + level.f_46441_.m_188501_()) : player.m_20191_().f_82289_ + (double)level.f_46441_.m_188501_() + 0.5, player == null ? (double)((float)blockEntity.m_58899_().m_123343_() + f3 + 0.5f) : player.m_20182_().f_82481_ + (double)f3, (double)((float)Math.pow(2.0, (double)(level.f_46441_.m_188503_(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void attributeAbility(Player player, boolean isRemoval, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance armor = player.m_21051_(attribute);
        if (isRemoval && armor != null && armor.m_22109_(modifier)) {
            armor.m_22127_(modifier.m_22209_());
        }
        if (!isRemoval && armor != null && !armor.m_22109_(modifier)) {
            armor.m_22125_(modifier);
        }
    }

    public void armorAbilityRemovals(Player player) {
        this.attributeAbility(player, true, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Attribute)ForgeMod.REACH_DISTANCE.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
    }

    public void lapisAbility(Player player) {
        if (ABILITIES.checkBackpack(player, (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get())) {
            int number = player.m_217043_().m_216332_(0, 1);
            player.m_6756_(number);
            BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.f_175827_, player, number);
        }
    }

    public void bookshelfAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        BlockPos enchanting = BackpackUtils.findBlock3D(blockEntity.m_58904_(), blockEntity.m_58899_().m_123341_(), blockEntity.m_58899_().m_123342_(), blockEntity.m_58899_().m_123343_(), Blocks.f_50201_, 2, 2);
        if (enchanting != null) {
            if (!blockEntity.m_58904_().m_46859_(new BlockPos((enchanting.m_123341_() - blockEntity.m_58899_().m_123341_()) / 2 + blockEntity.m_58899_().m_123341_(), enchanting.m_123342_(), (enchanting.m_123343_() - blockEntity.m_58899_().m_123343_()) / 2 + blockEntity.m_58899_().m_123343_()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                blockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)enchanting.m_123341_() + 0.5, (double)enchanting.m_123342_() + 2.0, (double)enchanting.m_123343_() + 0.5, (double)((float)(blockEntity.m_58899_().m_123341_() - enchanting.m_123341_()) + blockEntity.m_58904_().f_46441_.m_188501_()) - 0.5, (double)((float)(blockEntity.m_58899_().m_123342_() - enchanting.m_123342_()) - blockEntity.m_58904_().f_46441_.m_188501_() - 1.0f), (double)((float)(blockEntity.m_58899_().m_123343_() - enchanting.m_123343_()) + blockEntity.m_58904_().f_46441_.m_188501_()) - 0.5);
            }
        }
    }

    public void spongeAbility(TravelersBackpackBlockEntity blockEntity) {
        if (!blockEntity.getLeftTank().isEmpty() && !blockEntity.getRightTank().isEmpty() && blockEntity.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && blockEntity.getLeftTank().getFluidAmount() == blockEntity.getLeftTank().getCapacity() && blockEntity.getRightTank().getFluidAmount() == blockEntity.getRightTank().getCapacity()) {
            float f = blockEntity.m_58904_().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            float f1 = blockEntity.m_58904_().f_46441_.m_188501_() * 0.5f + 0.5f;
            float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
            blockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)((float)blockEntity.m_58899_().m_123341_() + f2 + 0.5f), (double)((float)blockEntity.m_58899_().m_123342_() + blockEntity.m_58904_().f_46441_.m_188501_()), (double)((float)blockEntity.m_58899_().m_123343_() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(blockEntity.m_58904_().f_46441_.m_188503_(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(Player player) {
        TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
        if (container.getLastTime() <= 0) {
            player.m_36324_().m_38707_(2, 0.1f);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_144090_, SoundSource.AMBIENT, 1.0f, (player.f_19853_.f_46441_.m_188501_() - player.f_19853_.f_46441_.m_188501_()) * 0.3f + 1.0f);
            if (!player.f_19853_.f_46443_) {
                Level level = player.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    for (int i = 0; i < 3; ++i) {
                        float f = server.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
                        float f1 = server.f_46441_.m_188501_() * 0.5f + 0.5f;
                        float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
                        float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123750_, player.m_20182_().f_82479_ + (double)f2, player.m_20191_().f_82289_ + (double)player.f_19853_.f_46441_.m_188501_() + 0.5, player.m_20182_().f_82481_ + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.f_19853_.f_46441_.m_188503_(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                    }
                }
                container.setLastTime(TimeUtils.randomTime(player.f_19853_.f_46441_, 360, 360 + player.m_36324_().m_38702_() * 12));
                container.setDataChanged(7);
            }
        }
    }

    public void chickenAbility(Player player, boolean firstSwitch) {
        TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
        if (firstSwitch && container.getLastTime() <= 0 && !player.f_19853_.f_46443_) {
            container.setLastTime(TimeUtils.randomTime(player.f_19853_.f_46441_, 360, 600));
            container.setDataChanged(7);
            return;
        }
        if (container.getLastTime() <= 0) {
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11752_, SoundSource.AMBIENT, 1.0f, (player.f_19853_.f_46441_.m_188501_() - player.f_19853_.f_46441_.m_188501_()) * 0.3f + 1.0f);
            player.m_19998_((ItemLike)Items.f_42521_);
            if (!player.f_19853_.f_46443_) {
                container.setLastTime(TimeUtils.randomTime(player.f_19853_.f_46441_, 360, 600));
                container.setDataChanged(7);
            }
        }
    }

    public void cactusAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        if (player == null && blockEntity != null) {
            FluidTank leftTank = blockEntity.getLeftTank();
            FluidTank rightTank = blockEntity.getRightTank();
            int drops = 0;
            if (this.isUnderRain(blockEntity.m_58899_(), blockEntity.m_58904_())) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, drops);
            if (!blockEntity.m_58904_().f_46443_ && blockEntity.getLastTime() <= 0 && drops > 0) {
                blockEntity.setLastTime(5);
                if (leftTank.isEmpty() || leftTank.getFluid().isFluidEqual(water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || rightTank.getFluid().isFluidEqual(water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                blockEntity.setDataChanged(3);
            }
        } else if (player != null && blockEntity == null) {
            TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
            FluidTank leftTank = container.getLeftTank();
            FluidTank rightTank = container.getRightTank();
            int drops = 0;
            if (player.m_20069_()) {
                drops += 2;
            }
            if (this.isUnderRain(player.m_20183_(), player.f_19853_)) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, drops);
            if (!container.getLevel().f_46443_ && container.getLastTime() <= 0 && drops > 0) {
                container.setLastTime(5);
                if (leftTank.isEmpty() || leftTank.getFluid().isFluidEqual(water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || rightTank.getFluid().isFluidEqual(water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                container.setDataChanged(3);
            }
        }
    }

    public static void melonAbility(TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && blockEntity.getLastTime() <= 0) {
            Block.m_49840_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_(), (ItemStack)new ItemStack((ItemLike)Items.f_42575_, blockEntity.m_58904_().f_46441_.m_216339_(0, 3)));
            blockEntity.setLastTime(TimeUtils.randomTime(blockEntity.m_58904_().f_46441_, 120, 480));
            blockEntity.setDataChanged();
        }
    }

    public static void pumpkinAbility(EnderManAngerEvent event) {
        if (ABILITIES.checkBackpack(event.getPlayer(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get())) {
            event.setCanceled(true);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
            if (player.m_21224_() && container != null && container.getItemStack().m_41720_() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && container.getAbilityValue() && container.getLastTime() <= 0) {
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 450, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400, 0));
                player.f_19853_.m_7703_((Entity)player, DamageSource.m_19344_((Player)player), null, player.m_20208_(0.5), player.m_20186_(), player.m_20262_(0.5), 3.0f, false, Explosion.BlockInteraction.NONE);
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11837_, SoundSource.AMBIENT, 1.2f, 0.5f);
                if (!player.f_19853_.f_46443_) {
                    container.setLastTime(TimeUtils.randomTime(player.f_19853_.f_46441_, 600, 900));
                    container.setDataChanged(7);
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void dragonAbility(Player player) {
        this.magmaCubeAbility(player);
        this.squidAbility(player);
        this.addTimedMobEffect(player, MobEffects.f_19605_, 0, 210, 0, false, false, true);
        this.addTimedMobEffect(player, MobEffects.f_19600_, 210, 240, 0, false, false, true);
    }

    public void blazeAbility(Player player) {
        if (player.f_19789_ >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, player.m_20208_(0.5), player.m_20187_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            player.f_19789_ = 0.0f;
        }
    }

    public static void blazeAbility(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SmallFireball) {
            Player player;
            EntityHitResult result;
            Entity entity;
            SmallFireball fireball = (SmallFireball)projectile;
            if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = (result = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Player && ABILITIES.checkBackpack(player = (Player)entity, (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get())) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f + player.f_19853_.f_46441_.m_188501_() * 0.4f);
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.f_123744_, player, 3);
                fireball.m_146870_();
                event.setCanceled(true);
            }
        }
    }

    public static void ghastAbility(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Ghast) {
            Player player;
            Ghast ghast = (Ghast)livingEntity;
            livingEntity = event.getNewTarget();
            if (livingEntity instanceof Player && ABILITIES.checkBackpack(player = (Player)livingEntity, (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get()) && ghast.m_21188_() != player) {
                event.setCanceled(true);
            }
        }
    }

    public void magmaCubeAbility(Player player) {
        this.addTimedMobEffect(player, MobEffects.f_19607_, 210, 240, 0, false, false, true);
    }

    public void spiderAbility(Player player) {
        if (player.f_19862_ && !player.isInFluidType()) {
            if (!player.m_20096_() && player.m_6047_()) {
                player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
            } else {
                player.m_20334_(player.m_20184_().f_82479_, 0.2, player.m_20184_().f_82481_);
                Level level = player.f_19853_;
                BlockState state = level.m_8055_(player.m_20183_().m_121945_(player.m_6350_()));
                player.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(player.m_20183_()), player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)player.m_6972_((Pose)Pose.STANDING).f_20377_, player.m_20186_() + 0.1, player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)player.m_6972_((Pose)Pose.STANDING).f_20377_, 0.0, 1.5, 0.0);
            }
        }
    }

    public void witherAbility(Player player) {
        if (player.m_21124_(MobEffects.f_19615_) != null) {
            player.m_21195_(MobEffects.f_19615_);
        }
    }

    public void batAbility(Player player) {
        this.addTimedMobEffect(player, MobEffects.f_19611_, 210, 240, 0, false, false, true);
    }

    public static void beeAbility(AttackEntityEvent event) {
        boolean flag;
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get()) && (flag = event.getTarget().m_6469_(DamageSource.m_19364_((LivingEntity)event.getEntity()), 1.0f))) {
            event.getEntity().m_19970_((LivingEntity)event.getEntity(), event.getTarget());
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_21321_(living.m_21235_() + 1);
                living.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 80, 0), (Entity)event.getEntity());
            }
        }
    }

    public void ocelotAbility(Player player) {
        if (player.f_19853_.m_45963_(Mob.class, this.ocelotAbilityTargeting, (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20191_().m_82377_(6.0, 2.0, 6.0)) != null) {
            this.addTimedMobEffect(player, MobEffects.f_19596_, 20, 30, 0, false, false, true);
        }
    }

    public void cowAbility(Player player) {
        if (!player.m_21220_().isEmpty() && CapabilityUtils.getBackpackInv(player).getLastTime() <= 0) {
            player.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
            if (!player.f_19853_.f_46443_) {
                player.f_19853_.m_46796_(2007, player.m_20183_(), 0xFFFFFF);
            }
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_144178_, SoundSource.PLAYERS, 1.0f, player.m_217043_().m_188501_() * 0.1f + 0.9f);
            CapabilityUtils.getBackpackInv(player).setLastTime(TimeUtils.randomTime(player.f_19853_.f_46441_, 450, 600));
            CapabilityUtils.getBackpackInv(player).setDataChanged(7);
        }
    }

    public void squidAbility(Player player) {
        if (player.m_20069_()) {
            this.addTimedMobEffect(player, MobEffects.f_19608_, 210, 240, 0, false, false, true);
            this.batAbility(player);
        }
    }

    private boolean isUnderRain(BlockPos pos, Level level) {
        return level.m_45527_(pos) && level.m_46471_();
    }

    public boolean checkBackpack(Player player, Item item) {
        return CapabilityUtils.isWearingBackpack(player) && CapabilityUtils.getBackpackInv(player).getItemStack().m_41720_() == item && CapabilityUtils.getBackpackInv(player).getAbilityValue();
    }

    public void addTimedMobEffect(Player player, MobEffect effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.m_21023_(effect)) {
            player.m_7292_(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.m_21023_(effect) && player.m_21124_(effect).m_19557_() <= minDuration) {
            player.m_7292_(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(ParticleOptions type, Player player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.f_19853_.f_46441_.m_188583_() * 0.02;
            double d1 = player.f_19853_.f_46441_.m_188583_() * 0.02;
            double d2 = player.f_19853_.f_46441_.m_188583_() * 0.02;
            Level level = player.f_19853_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)level;
            server.m_8767_(type, player.m_20208_(1.0), player.m_20187_() + 0.5, player.m_20262_(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(Item[] list, ItemStack stackToCheck) {
        return Arrays.stream(list).anyMatch(s -> s == stackToCheck.m_41720_());
    }
}

