/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;

public class InventoryData
extends SavedData {
    private static final String SAVED_DATA_NAME = "travelersbackpack";
    private final Map<UUID, CompoundTag> backpackContents = new HashMap<UUID, CompoundTag>();
    private static final InventoryData clientStorageCopy = new InventoryData();
    private final Set<UUID> updatedBackpackSettingsFlags = new HashSet<UUID>();

    private InventoryData() {
    }

    public static InventoryData get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (InventoryData)storage.m_164861_(InventoryData::load, InventoryData::new, SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static InventoryData load(CompoundTag nbt) {
        InventoryData storage = new InventoryData();
        InventoryData.readBackpackContents(nbt, storage);
        return storage;
    }

    private static void readBackpackContents(CompoundTag nbt, InventoryData storage) {
        for (Tag n : nbt.m_128437_("backpackContents", 10)) {
            CompoundTag uuidContentsPair = (CompoundTag)n;
            UUID uuid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(uuidContentsPair.m_128423_("uuid")));
            CompoundTag contents = uuidContentsPair.m_128469_("contents");
            storage.backpackContents.put(uuid, contents);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag ret = new CompoundTag();
        this.writeBackpackContents(ret);
        return ret;
    }

    private void writeBackpackContents(CompoundTag ret) {
        ListTag backpackContentsNbt = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.backpackContents.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.m_128365_("uuid", (Tag)NbtUtils.m_129226_((UUID)entry.getKey()));
            uuidContentsPair.m_128365_("contents", (Tag)entry.getValue());
            backpackContentsNbt.add((Object)uuidContentsPair);
        }
        ret.m_128365_("backpackContents", (Tag)backpackContentsNbt);
    }

    public CompoundTag getOrCreateBackpackContents(UUID backpackUuid) {
        return this.backpackContents.computeIfAbsent(backpackUuid, uuid -> {
            this.m_77762_();
            return new CompoundTag();
        });
    }

    public void removeBackpackContents(UUID backpackUuid) {
        this.backpackContents.remove(backpackUuid);
    }

    public void setBackpackContents(UUID backpackUuid, CompoundTag contents) {
        if (!this.backpackContents.containsKey(backpackUuid)) {
            this.backpackContents.put(backpackUuid, contents);
            this.updatedBackpackSettingsFlags.add(backpackUuid);
        } else {
            CompoundTag currentContents = this.backpackContents.get(backpackUuid);
            for (String key : contents.m_128431_()) {
                currentContents.m_128365_(key, contents.m_128423_(key));
            }
            this.m_77762_();
        }
    }

    public boolean removeUpdatedBackpackSettingsFlag(UUID backpackUuid) {
        return this.updatedBackpackSettingsFlags.remove(backpackUuid);
    }
}

