/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.network.NetworkHooks;

public class TravelersBackpackContainer
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private final ItemStackHandler inventory = this.createHandler(Tiers.LEATHER.getAllSlots(), true);
    private final ItemStackHandler craftingInventory = this.createHandler(9, false);
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final Player player;
    private ItemStack stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;
    private final String INVENTORY = "Inventory";
    private final String CRAFTING_INVENTORY = "CraftingInventory";
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";

    public TravelersBackpackContainer(ItemStack stack, Player player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        this.loadAllData(stack.m_41784_());
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void loadTier(CompoundTag compound) {
        if (!compound.m_128441_("Tier")) {
            compound.m_128405_("Tier", TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER.getOrdinal() : Tiers.DIAMOND.getOrdinal());
        }
        if (compound.m_128425_("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.m_128461_("Tier"));
            compound.m_128473_("Tier");
            compound.m_128405_("Tier", tier.getOrdinal());
        }
        this.tier = Tiers.of(compound.m_128451_("Tier"));
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedHandler() {
        RangedWrapper additional = null;
        if (this.tier != Tiers.LEATHER) {
            additional = new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 0, this.tier.getStorageSlots() - 18);
        }
        if (additional != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{additional, new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots(), additional.getSlots() + 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots() + 6, additional.getSlots() + 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), additional.getSlots() + 12, additional.getSlots() + 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 6, 9)});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 0, 6), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 0, 3), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 6, 12), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 3, 6), new RangedWrapper((IItemHandlerModifiable)this.getHandler(), 12, 18), new RangedWrapper((IItemHandlerModifiable)this.getCraftingGridHandler(), 6, 9)});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveAllData(CompoundTag compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveTime(compound);
        this.saveAbility(compound);
        this.slotManager.saveUnsortableSlots(compound);
        this.slotManager.saveMemorySlots(compound);
        this.settingsManager.saveSettings(compound);
    }

    @Override
    public void loadAllData(CompoundTag compound) {
        this.loadTier(compound);
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadTime(compound);
        this.loadAbility(compound);
        this.slotManager.loadUnsortableSlots(compound);
        this.slotManager.loadMemorySlots(compound);
        this.settingsManager.loadSettings(compound);
    }

    @Override
    public void saveItems(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
    }

    @Override
    public void loadItems(CompoundTag compound) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
    }

    @Override
    public void saveTanks(CompoundTag compound) {
        compound.m_128365_("LeftTank", (Tag)this.leftTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("RightTank", (Tag)this.rightTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    @Override
    public void saveColor(CompoundTag compound) {
    }

    @Override
    public void loadColor(CompoundTag compound) {
    }

    @Override
    public void saveSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void loadSleepingBagColor(CompoundTag compound) {
    }

    @Override
    public void saveAbility(CompoundTag compound) {
        compound.m_128379_("Ability", this.ability);
    }

    @Override
    public void loadAbility(CompoundTag compound) {
        this.ability = !compound.m_128441_("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.m_128471_("Ability");
    }

    @Override
    public void saveTime(CompoundTag compound) {
        compound.m_128405_("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(CompoundTag compound) {
        this.lastTime = compound.m_128451_("LastTime");
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), this.player);
    }

    private void sendPackets() {
        if (this.screenID == 2) {
            CapabilityUtils.synchronise(this.player);
            CapabilityUtils.synchroniseToOthers(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.stack.m_41784_().m_128441_("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.stack.m_41784_().m_128451_("Color");
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.m_41784_().m_128441_("SleepingBagColor");
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.stack.m_41784_().m_128451_("SleepingBagColor");
        }
        return DyeColor.RED.m_41060_();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().m_41720_()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasBlockEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public Level getLevel() {
        return this.player.f_19853_;
    }

    @Override
    public BlockPos getPosition() {
        return this.player.m_20183_();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable Player player) {
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
        if (this.getLevel().f_46443_) {
            return;
        }
        for (byte data : dataIds) {
            switch (data) {
                case 0: {
                    this.stack.m_41784_().m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
                }
                case 1: {
                    this.stack.m_41784_().m_128365_("CraftingInventory", (Tag)this.craftingInventory.serializeNBT());
                }
                case 2: {
                    this.saveItems(this.stack.m_41784_());
                }
                case 3: {
                    this.saveTanks(this.stack.m_41784_());
                }
                case 4: {
                    this.saveColor(this.stack.m_41784_());
                }
                case 5: {
                    this.saveSleepingBagColor(this.stack.m_41784_());
                }
                case 6: {
                    this.saveAbility(this.stack.m_41784_());
                }
                case 7: {
                    this.saveTime(this.stack.m_41784_());
                }
                case 8: {
                    this.slotManager.saveUnsortableSlots(this.stack.m_41784_());
                    this.slotManager.saveMemorySlots(this.stack.m_41784_());
                }
                case 9: {
                    this.settingsManager.saveSettings(this.stack.m_41784_());
                }
                case 10: {
                    this.saveAllData(this.stack.m_41784_());
                }
            }
        }
        this.sendPackets();
    }

    @Override
    public void setDataChanged() {
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    public static void abilityTick(Player player) {
        if (player.m_6084_() && CapabilityUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(player))) {
            TravelersBackpackContainer container = CapabilityUtils.getBackpackInv(player);
            if (!player.f_19853_.f_46443_ && container.getLastTime() > 0) {
                container.setLastTime(container.getLastTime() - 1);
                container.setDataChanged(7);
            }
            if (container.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(CapabilityUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openGUI(ServerPlayer serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.f_19853_.f_46443_) {
            if (screenID == 1) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)new TravelersBackpackContainer(stack, (Player)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
            if (screenID == 2) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)CapabilityUtils.getBackpackInv((Player)serverPlayerEntity), packetBuffer -> packetBuffer.writeByte((int)screenID));
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
        return new TravelersBackpackItemMenu(windowID, inventory, this);
    }

    private ItemStackHandler createHandler(int size, final boolean isInventory) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TravelersBackpackContainer.this.setDataChanged(2);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(stack.m_41720_() instanceof TravelersBackpackItem);
            }

            public void deserializeNBT(CompoundTag nbt) {
                if (isInventory) {
                    if (TravelersBackpackContainer.this.getTier() == Tiers.LEATHER) {
                        int size;
                        int n = size = nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size();
                        if (size == 45) {
                            TravelersBackpackContainer.this.tier = Tiers.DIAMOND;
                            CompoundTag tag = TravelersBackpackContainer.this.stack.m_41784_().m_6426_();
                            tag.m_128405_("Tier", Tiers.DIAMOND.getOrdinal());
                            TravelersBackpackContainer.this.stack.m_41751_(tag);
                        }
                    }
                    this.setSize(TravelersBackpackContainer.this.tier.getAllSlots());
                    ListTag tagList = nbt.m_128437_("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundTag itemTags = tagList.m_128728_(i);
                        int slot = itemTags.m_128451_("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
                    }
                    this.onLoad();
                } else {
                    super.deserializeNBT(nbt);
                }
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackContainer.this.setDataChanged(3);
            }

            public FluidTank readFromNBT(CompoundTag nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setCapacity(TravelersBackpackContainer.this.tier.getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }
}

