/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;

public class BackpackManager {
    public static LevelResource BACKPACKS = new LevelResource("backpacks");

    public static void addBackpack(ServerPlayer player, ItemStack stack) {
        try {
            UUID randomBackpackUUID = UUID.randomUUID();
            File backpackFile = BackpackManager.getBackpackFile(player, randomBackpackUUID);
            backpackFile.getParentFile().mkdirs();
            NbtIo.m_128955_((CompoundTag)stack.m_41739_(new CompoundTag()), (File)backpackFile);
            LogHelper.info("Created new backpack backup file for " + player.m_5446_().getString() + " with unique ID " + randomBackpackUUID, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerPlayer player, UUID id) {
        return BackpackManager.getBackpack(player.m_284548_(), player.m_20148_(), id);
    }

    @Nullable
    public static ItemStack getBackpack(ServerLevel level, UUID playerUUID, UUID id) {
        try {
            CompoundTag data = NbtIo.m_128953_((File)BackpackManager.getBackpackFile(level, playerUUID, id));
            if (data == null) {
                return null;
            }
            return ItemStack.m_41712_((CompoundTag)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(File file) {
        try {
            CompoundTag data = NbtIo.m_128953_((File)file);
            if (data == null) {
                return null;
            }
            return ItemStack.m_41712_((CompoundTag)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerLevel level, UUID id) {
        File deathFolder = BackpackManager.getBackpackFolder(level);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(id.toString() + ".dat"))) == null || files.length <= 0) continue;
            return BackpackManager.getBackpack(level, UUID.fromString(f.getName()), id);
        }
        return null;
    }

    public static File getBackpackFile(ServerLevel level, UUID playerUUID, UUID id) {
        return new File(BackpackManager.getPlayerBackpackFolder(level, playerUUID), id.toString() + ".dat");
    }

    public static File getBackpackFile(ServerPlayer player, UUID id) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), id.toString() + ".dat");
    }

    public static File getPlayerBackpackFolder(ServerPlayer player) {
        return BackpackManager.getPlayerBackpackFolder(player.m_284548_(), player.m_20148_());
    }

    public static File getPlayerBackpackFolder(ServerLevel level, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(level), uuid.toString());
    }

    public static File getBackpackFolder(ServerLevel level) {
        return BackpackManager.getWorldFolder(level, BACKPACKS);
    }

    public static File getWorldFolder(ServerLevel serverLevel, LevelResource levelResource) {
        return serverLevel.m_7654_().m_129843_(levelResource).toFile();
    }
}

