/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BackpackUpgradeRecipe
extends SmithingTransformRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public BackpackUpgradeRecipe(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
        super(pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public ItemStack m_5874_(Container p_267036_, RegistryAccess p_266699_) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundtag = p_267036_.m_8020_(1).m_41783_();
        if (compoundtag != null) {
            if ((compoundtag = compoundtag.m_6426_()).m_128441_("Tier")) {
                Tiers.Tier tier = Tiers.of(compoundtag.m_128451_("Tier"));
                if (this.addition.test(Tiers.of(compoundtag.m_128451_("Tier")).getTierUpgradeIngredient().m_7968_())) {
                    compoundtag.m_128405_("Tier", tier.getNextTier().getOrdinal());
                    if (compoundtag.m_128441_("Inventory") && compoundtag.m_128469_("Inventory").m_128425_("Size", 3)) {
                        compoundtag.m_128469_("Inventory").m_128405_("Size", tier.getNextTier().getAllSlots());
                    }
                    itemstack.m_41751_(compoundtag.m_6426_());
                    return itemstack;
                }
            } else if (this.addition.test(Tiers.LEATHER.getTierUpgradeIngredient().m_7968_())) {
                compoundtag.m_128405_("Tier", Tiers.LEATHER.getNextTier().getOrdinal());
                if (compoundtag.m_128441_("Inventory") && compoundtag.m_128469_("Inventory").m_128425_("Size", 3)) {
                    compoundtag.m_128469_("Inventory").m_128405_("Size", Tiers.LEATHER.getAllSlots());
                }
                itemstack.m_41751_(compoundtag.m_6426_());
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(Container p_266855_, Level p_266781_) {
        return TravelersBackpackConfig.enableTierUpgrades && super.m_5818_(p_266855_, p_266781_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        private static final Codec<BackpackUpgradeRecipe> backpackUpgradeRecipeCodec = RecordCodecBuilder.create(p_301330_ -> p_301330_.group((App)Ingredient.f_291570_.fieldOf("template").forGetter(p_297231_ -> p_297231_.template), (App)Ingredient.f_291570_.fieldOf("base").forGetter(p_298250_ -> p_298250_.base), (App)Ingredient.f_291570_.fieldOf("addition").forGetter(p_299654_ -> p_299654_.addition), (App)CraftingRecipeCodecs.f_290789_.fieldOf("result").forGetter(p_297480_ -> p_297480_.result)).apply((Applicative)p_301330_, BackpackUpgradeRecipe::new));

        public Codec<BackpackUpgradeRecipe> m_292673_() {
            return backpackUpgradeRecipeCodec;
        }

        @Nullable
        public BackpackUpgradeRecipe fromNetwork(FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            return new BackpackUpgradeRecipe(ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_266746_, BackpackUpgradeRecipe p_266927_) {
            p_266927_.template.m_43923_(p_266746_);
            p_266927_.base.m_43923_(p_266746_);
            p_266927_.addition.m_43923_(p_266746_);
            p_266746_.m_130055_(p_266927_.result);
        }
    }
}

