/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BackpackUpgradeRecipeBuilder {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final RecipeCategory category;
    private final Item result;
    private final Map<String, Criterion<?>> f_291373_ = new LinkedHashMap();
    private final RecipeSerializer<?> type;

    public BackpackUpgradeRecipeBuilder(RecipeSerializer<?> pType, Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, Item pResult) {
        this.category = pCategory;
        this.type = pType;
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public static BackpackUpgradeRecipeBuilder backpackUpgrade(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, Item pResult) {
        return new BackpackUpgradeRecipeBuilder((RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get(), pTemplate, pBase, pAddition, pCategory, pResult);
    }

    public BackpackUpgradeRecipeBuilder unlocks(String pKey, Criterion<?> p_297342_) {
        this.f_291373_.put(pKey, p_297342_);
        return this;
    }

    public void save(RecipeOutput p_300964_, String pLocation) {
        this.save(p_300964_, new ResourceLocation(pLocation));
    }

    public void save(RecipeOutput p_301024_, ResourceLocation pLocation) {
        this.ensureValid(pLocation);
        Advancement.Builder advancement$builder = p_301024_.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)pLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pLocation)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
        this.f_291373_.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).m_138383_(arg_0, arg_1));
        p_301024_.m_292927_((FinishedRecipe)new Result(pLocation, this.type, this.template, this.base, this.addition, this.result, advancement$builder.m_138403_(pLocation.m_246208_("recipes/" + this.category.m_247710_() + "/"))));
    }

    private void ensureValid(ResourceLocation pLocation) {
        if (this.f_291373_.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pLocation);
        }
    }

    public record Result(ResourceLocation id, RecipeSerializer<?> type, Ingredient template, Ingredient base, Ingredient addition, Item result, AdvancementHolder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject p_266713_) {
            p_266713_.add("template", this.template.m_43942_(true));
            p_266713_.add("base", this.base.m_43942_(true));
            p_266713_.add("addition", this.addition.m_43942_(true));
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            p_266713_.add("result", (JsonElement)jsonobject);
        }

        public ResourceLocation m_126168_() {
            return this.id;
        }

        public RecipeSerializer<?> m_126169_() {
            return this.type;
        }

        public AdvancementHolder m_126373_() {
            return this.advancement;
        }
    }
}

