/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(String groupIn, CraftingBookCategory category, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, boolean pShowNotification) {
        super(groupIn, category, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess access) {
        ItemStack output = super.m_5874_(inv, access);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (!ingredient.m_41619_() && ingredient.m_41720_() instanceof TravelersBackpackItem) {
                    CompoundTag compound = ingredient.m_41783_();
                    output.m_41751_(compound);
                    break;
                }
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof SleepingBagItem)) continue;
                output.m_41784_().m_128405_("SleepingBagColor", ShapedBackpackRecipe.getProperColor((SleepingBagItem)ingredient.m_41720_()));
            }
        }
        return output;
    }

    public static int getProperColor(SleepingBagItem item) {
        Block block = item.m_40614_();
        if (block instanceof SleepingBagBlock) {
            SleepingBagBlock sleepingBag = (SleepingBagBlock)block;
            return sleepingBag.m_49554_().m_41060_();
        }
        return DyeColor.RED.m_41060_();
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        static final Codec<List<String>> f_291059_ = Codec.STRING.listOf().flatXmap(p_297814_ -> {
            if (p_297814_.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (p_297814_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_297814_.get(0)).length();
            for (String s : p_297814_) {
                if (s.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_297814_);
        }, DataResult::success);
        static final Codec<String> f_291502_ = Codec.STRING.flatXmap(p_301277_ -> {
            if (p_301277_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_301277_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_301277_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)p_301277_);
        }, DataResult::success);
        private static final Codec<ShapedBackpackRecipe> f_291611_ = RawShapedRecipe.f_290916_.flatXmap(p_300056_ -> {
            String[] astring = Serializer.shrink(p_300056_.f_291411_);
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            HashSet set = Sets.newHashSet(p_300056_.f_291499_.keySet());
            for (int k = 0; k < astring.length; ++k) {
                String s = astring[k];
                for (int l = 0; l < s.length(); ++l) {
                    Ingredient ingredient;
                    String s1 = s.substring(l, l + 1);
                    Ingredient ingredient2 = ingredient = s1.equals(" ") ? Ingredient.f_43901_ : p_300056_.f_291499_.get(s1);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + s1 + "' but it's not defined in the key");
                    }
                    set.remove(s1);
                    nonnulllist.set(l + i * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + set);
            }
            ShapedBackpackRecipe shapedrecipe = new ShapedBackpackRecipe(p_300056_.f_291237_, p_300056_.f_291394_, i, j, (NonNullList<Ingredient>)nonnulllist, p_300056_.f_291431_, p_300056_.f_291143_);
            return DataResult.success((Object)((Object)shapedrecipe));
        }, p_299463_ -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        static String[] shrink(List<String> p_299210_) {
            int i = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int i1 = 0; i1 < p_299210_.size(); ++i1) {
                String s = p_299210_.get(i1);
                i = Math.min(i, Serializer.firstNonSpace(s));
                int j1 = Serializer.lastNonSpace(s);
                j = Math.max(j, j1);
                if (j1 < 0) {
                    if (k == i1) {
                        ++k;
                    }
                    ++l;
                    continue;
                }
                l = 0;
            }
            if (p_299210_.size() == l) {
                return new String[0];
            }
            String[] astring = new String[p_299210_.size() - l - k];
            for (int k1 = 0; k1 < astring.length; ++k1) {
                astring[k1] = p_299210_.get(k1 + k).substring(i, j + 1);
            }
            return astring;
        }

        private static int firstNonSpace(String pEntry) {
            int i;
            for (i = 0; i < pEntry.length() && pEntry.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        private static int lastNonSpace(String pEntry) {
            int i;
            for (i = pEntry.length() - 1; i >= 0 && pEntry.charAt(i) == ' '; --i) {
            }
            return i;
        }

        public Codec<ShapedBackpackRecipe> m_292673_() {
            return f_291611_;
        }

        @Nullable
        public ShapedBackpackRecipe fromNetwork(FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            boolean flag = buffer.readBoolean();
            return new ShapedBackpackRecipe(group, craftingbookcategory, width, height, (NonNullList<Ingredient>)ingredients, result, flag);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedBackpackRecipe recipe) {
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.f_44149_, false);
            buffer.writeBoolean(recipe.m_271738_());
        }

        record RawShapedRecipe(String f_291237_, CraftingBookCategory f_291394_, Map<String, Ingredient> f_291499_, List<String> f_291411_, ItemStack f_291431_, boolean f_291143_) {
            public static final Codec<RawShapedRecipe> f_290916_ = RecordCodecBuilder.create(p_298430_ -> p_298430_.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_300105_ -> p_300105_.f_291237_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301213_ -> p_301213_.f_291394_), (App)ExtraCodecs.m_295464_(f_291502_, (Codec)Ingredient.f_290991_).fieldOf("key").forGetter(p_297983_ -> p_297983_.f_291499_), (App)f_291059_.fieldOf("pattern").forGetter(p_300956_ -> p_300956_.f_291411_), (App)CraftingRecipeCodecs.f_290789_.fieldOf("result").forGetter(p_299535_ -> p_299535_.f_291431_), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_297368_ -> p_297368_.f_291143_)).apply((Applicative)p_298430_, RawShapedRecipe::new));
        }
    }
}

