/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackLayer;
import com.tiviacz.travelersbackpack.client.screens.OverlayScreen;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModClientEventsHandler {
    public static final ModelLayerLocation TRAVELERS_BACKPACK_BLOCK_ENTITY = new ModelLayerLocation(new ResourceLocation("travelersbackpack", "travelers_backpack"), "main");
    public static final ModelLayerLocation TRAVELERS_BACKPACK_WEARABLE = new ModelLayerLocation(new ResourceLocation("travelersbackpack", "travelers_backpack"), "wearable");
    public static final KeyMapping OPEN_INVENTORY = new KeyMapping("key.travelersbackpack.inventory", 66, "key.travelersbackpack.category");
    public static final KeyMapping TOGGLE_TANK = new KeyMapping("key.travelersbackpack.toggle_tank", 78, "key.travelersbackpack.category");
    public static final KeyMapping CYCLE_TOOL = new KeyMapping("key.travelersbackpack.cycle_tool", 90, "key.travelersbackpack.category");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_INVENTORY);
        event.register(TOGGLE_TANK);
        event.register(CYCLE_TOOL);
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent evt) {
        evt.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "travelers_backpack", (gui, poseStack, partialTick, width, height) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (!mc.f_91066_.f_92062_ && CapabilityUtils.isWearingBackpack((Player)mc.f_91074_) && mc.f_91072_.m_105295_() != GameType.SPECTATOR) {
                OverlayScreen.renderOverlay(gui, mc, poseStack);
            }
        });
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltipComponent.class, ClientBackpackTooltipComponent::new);
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TRAVELERS_BACKPACK_BLOCK_ENTITY, () -> TravelersBackpackBlockEntityRenderer.createTravelersBackpack(false));
        event.registerLayerDefinition(TRAVELERS_BACKPACK_WEARABLE, () -> TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventsHandler.addPlayerLayer(evt, PlayerSkin.Model.WIDE);
        ModClientEventsHandler.addPlayerLayer(evt, PlayerSkin.Model.SLIM);
        for (EntityType type : Reference.COMPATIBLE_TYPE_ENTRIES) {
            if (TravelersBackpack.endermanOverhaulLoaded && type == EntityType.f_20566_) continue;
            ModClientEventsHandler.addEntityLayer(evt, type);
        }
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, PlayerSkin.Model model) {
        LivingEntityRenderer renderer = evt.getSkin(model);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_((RenderLayer)new TravelersBackpackLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)livingRenderer));
        }
    }

    private static void addEntityLayer(EntityRenderersEvent.AddLayers evt, EntityType entityType) {
        LivingEntityRenderer renderer = evt.getRenderer(entityType);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_((RenderLayer)new TravelersBackpackEntityLayer((RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>>)livingRenderer));
        }
    }
}

