/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ServerboundAbilitySliderPacket {
    private final byte screenID;
    private final boolean sliderValue;

    public ServerboundAbilitySliderPacket(byte screenID, boolean sliderValue) {
        this.screenID = screenID;
        this.sliderValue = sliderValue;
    }

    public static ServerboundAbilitySliderPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        boolean sliderValue = buffer.readBoolean();
        return new ServerboundAbilitySliderPacket(screenID, sliderValue);
    }

    public static void encode(ServerboundAbilitySliderPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeBoolean(message.sliderValue);
    }

    public static void handle(ServerboundAbilitySliderPacket message, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            if (serverPlayer != null) {
                AbstractContainerMenu patt1919$temp;
                if (message.screenID == 2 && CapabilityUtils.isWearingBackpack((Player)serverPlayer)) {
                    ServerActions.switchAbilitySlider((Player)serverPlayer, message.sliderValue);
                } else if (message.screenID == 3 && (patt1919$temp = serverPlayer.f_36096_) instanceof TravelersBackpackBlockEntityMenu) {
                    TravelersBackpackBlockEntityMenu menu = (TravelersBackpackBlockEntityMenu)patt1919$temp;
                    ServerActions.switchAbilitySliderBlockEntity((Player)serverPlayer, menu.container.getPosition(), message.sliderValue);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

