/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ServerboundSleepingBagPacket {
    private final BlockPos pos;

    public ServerboundSleepingBagPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static ServerboundSleepingBagPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        return new ServerboundSleepingBagPacket(pos);
    }

    public static void encode(ServerboundSleepingBagPacket message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
    }

    public static void handle(ServerboundSleepingBagPacket message, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            if (serverPlayer != null) {
                ServerActions.toggleSleepingBag((Player)serverPlayer, message.pos);
            }
        });
        ctx.setPacketHandled(true);
    }
}

