/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.collect.Multimap;
import cpw.mods.modlauncher.api.INameMappingService;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;

public final class Armory {
    public static final String DICT_KEY_ARMOR = "forge:armor";
    public static final String DICT_KEY_HELMETS = "forge:armor/helmets";
    public static final String DICT_KEY_BOOTS = "forge:armor/boots";
    public static final String DICT_KEY_CHESTPLATES = "forge:armor/chestplates";
    public static final String DICT_KEY_LEGGINGS = "forge:armor/leggings";
    public static final String DICT_KEY_GLOVES = "forge:armor/gloves";
    public static final String DICT_KEY_SHIELDS = "forge:armor/shields";
    public static final String DICT_KEY_NATURAL_WINGS = "forge:armor/wings";
    static final HashMap<String, EquipmentSlotType> _N2A = (HashMap)Util.func_200696_a(new HashMap(), m -> {
        m.put(EquipmentSlotType.HEAD.func_188450_d(), EquipmentSlotType.HEAD);
        m.put(EquipmentSlotType.CHEST.func_188450_d(), EquipmentSlotType.CHEST);
        m.put(EquipmentSlotType.LEGS.func_188450_d(), EquipmentSlotType.LEGS);
        m.put(EquipmentSlotType.FEET.func_188450_d(), EquipmentSlotType.FEET);
    });
    static final HashMap<String, EquipmentSlotType> _N2P = (HashMap)Util.func_200696_a(new HashMap(), m -> {
        m.putAll(_N2A);
        m.put(EquipmentSlotType.MAINHAND.func_188450_d(), EquipmentSlotType.MAINHAND);
        m.put(EquipmentSlotType.OFFHAND.func_188450_d(), EquipmentSlotType.OFFHAND);
        m.put("face", EquipmentSlotType.HEAD);
        m.put("back", EquipmentSlotType.CHEST);
        m.put("wings", EquipmentSlotType.CHEST);
        m.put("skirt", EquipmentSlotType.LEGS);
        m.put("hand", EquipmentSlotType.MAINHAND);
        m.put("left_hand", EquipmentSlotType.OFFHAND);
        m.put("right_hand", EquipmentSlotType.MAINHAND);
    });
    private static final DecimalFormat _VALFMT = ItemStack.field_111284_a;
    private static final int _HIDE_ATTRS_TOOLTIP_BIT = 2;
    private static final EquipmentSlotType[] _MAINHAND_ONLY = new EquipmentSlotType[]{EquipmentSlotType.MAINHAND};

    @Nullable
    public static final EquipmentSlotType getEquipSlot(@Nonnull String es, boolean modded) {
        return modded ? _N2P.get(es) : _N2A.get(es);
    }

    public static final boolean isKnownArmorSlot(@Nonnull String es, boolean modded) {
        return Armory.getEquipSlot(es, modded) != null;
    }

    public static final boolean isKnownArmorSlot(@Nonnull EquipmentSlotType es, boolean modded) {
        return Armory.isKnownArmorSlot(es.func_188450_d(), modded);
    }

    @Nullable
    public static final EquipmentSlotType findEquipCategory(ItemStack whot, boolean modded) {
        if (ItemStacks.isEmpty(whot) || !LibConfig.getInstance().isFullyStarted()) {
            return null;
        }
        Item item = whot.func_77973_b();
        if (modded) {
            if (item.func_206844_a(Tags.GLOVES)) {
                return EquipmentSlotType.MAINHAND;
            }
            if (item.func_206844_a(Tags.NATURAL_WINGS)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (item.func_206844_a(Tags.HELMETS)) {
            return EquipmentSlotType.HEAD;
        }
        if (item.func_206844_a(Tags.CHESTPLATES)) {
            return EquipmentSlotType.CHEST;
        }
        if (item.func_206844_a(Tags.LEGGINGS)) {
            return EquipmentSlotType.LEGS;
        }
        if (item.func_206844_a(Tags.BOOTS)) {
            return EquipmentSlotType.FEET;
        }
        return null;
    }

    @Nullable
    public static final EquipmentSlotType getEquipSlot(ItemStack whot, boolean modded) {
        Item item = ItemStacks.isEmpty(whot) ? null : whot.func_77973_b();
        EquipmentSlotType eqslot = null;
        if (item != null) {
            if (item instanceof ArmorItem) {
                eqslot = ((ArmorItem)item).func_185083_B_();
            }
            if (eqslot == null) {
                eqslot = item.getEquipmentSlot(whot);
            }
            if (eqslot == null && modded) {
                eqslot = Armory.findEquipCategory(whot, modded);
            }
        }
        return eqslot;
    }

    @Nullable
    public static final ITag.INamedTag<Item> getEquipCategory(ItemStack whot) {
        EquipmentSlotType es = Armory.getEquipSlot(whot, false);
        if (es == EquipmentSlotType.HEAD) {
            return Tags.HELMETS;
        }
        if (es == EquipmentSlotType.CHEST) {
            return Tags.CHESTPLATES;
        }
        if (es == EquipmentSlotType.LEGS) {
            return Tags.LEGGINGS;
        }
        if (es == EquipmentSlotType.FEET) {
            return Tags.BOOTS;
        }
        if (ItemStacks.isEmpty(whot) || !LibConfig.getInstance().isFullyStarted()) {
            return null;
        }
        Item item = whot.func_77973_b();
        if (item.func_206844_a(Tags.GLOVES)) {
            return Tags.GLOVES;
        }
        if (item.func_206844_a(Tags.NATURAL_WINGS)) {
            return Tags.NATURAL_WINGS;
        }
        if (item.func_206844_a(Tags.HELMETS)) {
            return Tags.HELMETS;
        }
        if (item.func_206844_a(Tags.CHESTPLATES)) {
            return Tags.CHESTPLATES;
        }
        if (item.func_206844_a(Tags.LEGGINGS)) {
            return Tags.LEGGINGS;
        }
        if (item.func_206844_a(Tags.BOOTS)) {
            return Tags.BOOTS;
        }
        return null;
    }

    public static final boolean isWearingHeadpiece(LivingEntity entity) {
        ItemStack whot = entity.func_184582_a(EquipmentSlotType.HEAD);
        return !whot.func_190926_b() && whot.func_77973_b() instanceof ArmorItem;
    }

    public static final boolean isLiningAllowed(@Nullable ItemStack stack, boolean modded) {
        EquipmentSlotType es = Armory.getEquipSlot(stack, modded);
        return es == null ? false : (modded ? true : es.func_188453_a() == EquipmentSlotType.Group.ARMOR);
    }

    public static final boolean isLiningAllowed(@Nullable ItemStack stack, @Nonnull EquipmentSlotType wanted, boolean modded) {
        boolean is = false;
        if (modded || wanted.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            is = Armory.getEquipSlot(stack, modded) == wanted;
        }
        return is;
    }

    private static final boolean hasSimpleLining(ItemStack stack, String NBT_TAGNAME) {
        return !ItemStacks.isEmpty(stack) && ItemStacks.hasData(stack, NBT_TAGNAME, 8);
    }

    private static final boolean hasDoubleLining(ItemStack stack, String NBT_TAGNAME) {
        return !ItemStacks.isEmpty(stack) && ItemStacks.hasData(stack, NBT_TAGNAME, 10);
    }

    private static final void removeChecked(ItemStack armor, String NBT_TAGNAME) {
        ItemStacks.removeData(armor, NBT_TAGNAME, true);
    }

    @Nonnull
    private static final <T extends Enum<?>> ItemStack setSimpleLining(ItemStack armor, String NBT_TAGNAME, @Nullable T lining) {
        ItemStack out = ItemStack.field_190927_a;
        if (!ItemStacks.isEmpty(armor)) {
            if (lining == null || "NONE".equals(lining.name())) {
                Armory.removeChecked(armor, NBT_TAGNAME);
            } else {
                String id = lining.name();
                ItemStacks.getOrCreateData(armor).func_74778_a(NBT_TAGNAME, id);
            }
            out = armor;
        }
        return out;
    }

    @Nonnull
    private static final ItemStack setDoubleLining(ItemStack armor, String NBT_TAGNAME, @Nullable CompoundNBT lining) {
        ItemStack out = ItemStack.field_190927_a;
        if (!ItemStacks.isEmpty(armor)) {
            if (lining == null || lining.isEmpty()) {
                Armory.removeChecked(armor, NBT_TAGNAME);
            } else {
                ItemStacks.getOrCreateData(armor).func_218657_a(NBT_TAGNAME, (INBT)lining);
            }
            out = armor;
        }
        return out;
    }

    public static final boolean hasXLining(@Nullable ItemStack armor) {
        return Armory.hasDoubleLining(armor, XLining.NBT_TAGNAME);
    }

    @Nonnull
    public static final XLining.PairDef getXLining(@Nonnull ItemStack stack) {
        XLining.PairDef lining = XLining.EMPTY_DOUBLE;
        if (Armory.isLiningAllowed(stack, true) && Armory.hasXLining(stack)) {
            CompoundNBT data = ItemStacks.getMap(stack, XLining.NBT_TAGNAME);
            XLining.Def inner = XLining.Def.from(data, "inner");
            XLining.Def outer = XLining.Def.from(data, "outer");
            if (!inner.isEmpty() || !outer.isEmpty()) {
                lining = new XLining.PairDef(inner, outer);
            }
        }
        return lining;
    }

    public static final boolean hasXLining(@Nullable XLining type, @Nullable ItemStack stack) {
        XLining.PairDef lining = Armory.getXLining(stack);
        return lining.has(type);
    }

    public static final boolean hasXLiningWithValue(@Nullable XLining type, @Nullable ItemStack stack) {
        if (type == null || type == XLining.NONE) {
            return false;
        }
        XLining.Def lining = Armory.getXLining(stack).get(type);
        if (lining.isEmpty()) {
            return false;
        }
        return !lining.name.hasValues() || lining.value != 0;
    }

    @Nonnull
    public static final ItemStack setXLining(@Nonnull ItemStack armor, @Nullable XLining.PairDef lining) {
        CompoundNBT data;
        if (ItemStacks.isEmpty(armor)) {
            return armor;
        }
        boolean removing = lining == null || lining.isEmpty();
        CompoundNBT compoundNBT = data = removing ? null : new CompoundNBT();
        if (data != null) {
            XLining.Def.to(data, "inner", lining.inner);
            XLining.Def.to(data, "outer", lining.outer);
        }
        return Armory.setDoubleLining(armor, XLining.NBT_TAGNAME, data);
    }

    public static final boolean hasTLining(ItemStack armor) {
        return Armory.hasSimpleLining(armor, TLining.NBT_TAGNAME);
    }

    @Nonnull
    public static final TLining getTLining(ItemStack armor) {
        String id;
        TLining found = TLining.NONE;
        if (!ItemStacks.isEmpty(armor) && ItemStacks.hasData(armor) && !(id = ItemStacks.getString(armor, TLining.NBT_TAGNAME)).isEmpty()) {
            found = TLining.findOrNone(id);
        }
        return found;
    }

    @Nonnull
    public static final ItemStack setTLining(ItemStack armor, @Nullable TLining lining) {
        if (lining == TLining.NONE) {
            lining = null;
        }
        return Armory.setSimpleLining(armor, TLining.NBT_TAGNAME, lining);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static final IFormattableTextComponent getTLiningTooltip(ItemStack stack) {
        TLining lining;
        TranslationTextComponent tooltip = null;
        if (Armory.isLiningAllowed(stack, true) && (lining = Armory.getTLining(stack)) != TLining.NONE) {
            boolean cooling = lining.getModifier() < 0;
            String modifierstring = "" + (cooling ? "-" : "+") + Math.abs(lining.getModifier());
            tooltip = new TranslationTextComponent("carrots.tooltip.tan.xlining." + (cooling ? "COOL" : "WARM"), new Object[]{modifierstring});
            tooltip.func_240699_a_(cooling ? TextFormatting.DARK_AQUA : TextFormatting.DARK_RED);
        }
        return tooltip;
    }

    public static final boolean hasTemperatureRegulatingLining(ItemStack armor) {
        return Armory.hasTLining(armor) || Armory.getXLining(armor).has(XLining.TEMPERATURE_REGULATOR);
    }

    public static final boolean hasTemperatureAffectingLining(ItemStack armor) {
        if (Armory.hasTLining(armor)) {
            return true;
        }
        XLining.PairDef lining = Armory.getXLining(armor);
        return lining.has(XLining.TEMPERATURE_REGULATOR) || lining.has(XLining.ANTIFREEZE_SHIELD) || lining.has(XLining.OBSIDIAN_SHIELD);
    }

    @Nonnull
    public static final String getArmorMaterialName(@Nullable ArmorMaterial material) {
        String name = "";
        if (material != null) {
            try {
                return (String)ObfuscationReflectionHelper.getPrivateValue(ArmorMaterial.class, (Object)material, (String)ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_179243_f"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return name;
    }

    public static final void hideStandardModifierRender(@Nonnull ItemStack on) {
        if (on.func_77942_o()) {
            int current = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            on.func_77978_p().func_74768_a(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), current | 2);
        }
    }

    public static final String getWeaponOrToolModifierName(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ToolItem ? SharedGlue.TOOL_MODIFIER_ATTRNAME() : SharedGlue.WEAPON_MODIFIER_ATTRNAME();
    }

    public static final boolean hasModifiedAttributes(ItemStack stack) {
        return !ItemStacks.isEmpty(stack) && stack.func_77942_o() && stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), 9);
    }

    public static final boolean hasReforgedAttributes(ItemStack stack) {
        return Instructions.isLooted(stack) && Armory.hasModifiedAttributes(stack) && (stack.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME()) & 2) == 2;
    }

    public static final void removeModifiedAttributes(ItemStack stack) {
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            ItemStacks.removeData(stack, SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), true);
        }
    }

    public static final void removeModifiedAttributes(ItemStack stack, String ... attributeNames) {
        if (attributeNames.length > 0 && Armory.hasModifiedAttributes(stack)) {
            ListNBT list = stack.func_77978_p().func_150295_c(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), 10);
            Iterator litr = list.iterator();
            block0: while (litr.hasNext()) {
                CompoundNBT modNbt = (CompoundNBT)litr.next();
                String am_id = modNbt.func_74779_i("AttributeName");
                for (String attrid : attributeNames) {
                    if (!attrid.equals(am_id)) continue;
                    litr.remove();
                    continue block0;
                }
            }
            if (list.isEmpty()) {
                ItemStacks.removeData(stack, SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), true);
            }
        }
    }

    @Nonnull
    public static final String getModifiersProfileId(@Nonnull ItemStack stack) {
        String id = "";
        if (!stack.func_190926_b() && stack.func_77942_o() && (id = stack.func_77978_p().func_74779_i("StatsProfile")).isEmpty() && Instructions.present(stack)) {
            id = Instructions.get(stack).func_74779_i("StatsProfile");
        }
        return id;
    }

    @Nullable
    public static final String getBestGuessMaterialName(Object identifier, Boolean uppercase, @Nullable String defaultIfCant) {
        String name = defaultIfCant;
        if (identifier instanceof Enum) {
            Enum enumidentifier = (Enum)Enum.class.cast(identifier);
            name = enumidentifier.name();
        }
        if (identifier instanceof ArmorMaterial) {
            String materialname = Armory.getArmorMaterialName((ArmorMaterial)identifier);
            if (!materialname.isEmpty()) {
                name = materialname;
            }
        } else if (identifier instanceof IStringSerializable) {
            IStringSerializable seridentifier = (IStringSerializable)identifier;
            name = seridentifier.func_176610_l();
        }
        if (name != null && uppercase != null) {
            name = uppercase != false ? name.toUpperCase(Locale.ROOT) : name.toLowerCase(Locale.ROOT);
        }
        return name;
    }

    @Nullable
    public static final String getBestGuessMaterialName(Object identifier, @Nullable String defaultIfCant) {
        return Armory.getBestGuessMaterialName(identifier, false, defaultIfCant);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addWeaponModifierInformation(@Nonnull ItemStack stack, @Nullable PlayerEntity player, @Nonnull List<ITextComponent> tooltip) {
        if (player != null) {
            Armory.addModifierInformation(stack, player, _MAINHAND_ONLY, tooltip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addWeaponModifierInformation(@Nonnull ItemStack stack, @Nonnull List<ITextComponent> tooltip) {
        Armory.addModifierInformation(stack, null, _MAINHAND_ONLY, tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addModifierInformation(@Nonnull ItemStack stack, @Nullable PlayerEntity player, @Nonnull EquipmentSlotType[] slots, @Nonnull List<ITextComponent> tooltip) {
        for (EquipmentSlotType slot : slots) {
            Multimap slotattrs = stack.func_111283_C(slot);
            if (slotattrs.isEmpty()) continue;
            tooltip.add((ITextComponent)Tooltips.NL());
            tooltip.add((ITextComponent)new TranslationTextComponent("item.modifiers." + slot.func_188450_d()));
            boolean reforged_label = false;
            for (int pass = 0; pass < 2; ++pass) {
                for (Map.Entry entry : slotattrs.entries()) {
                    double final_amount;
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    int op = modifier.func_220375_c().func_220371_a();
                    double amount = modifier.func_111164_d();
                    boolean actual = false;
                    if (UUIDPeek.isAttackDamage(modifier.func_111167_a())) {
                        actual = true;
                        if (pass == 0) {
                            amount += player != null ? player.func_110148_a(Attributes.field_233823_f_).func_111125_b() : 1.0;
                            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
                        }
                    } else if (UUIDPeek.isAttackSpeedo(modifier.func_111167_a())) {
                        actual = true;
                        if (pass == 0) {
                            amount += player != null ? player.func_110148_a(Attributes.field_233825_h_).func_111125_b() : Attributes.field_233825_h_.func_111110_b();
                        }
                    }
                    double d = final_amount = Armory.isPercentageOp(op) ? 100.0 * amount : amount;
                    if (pass == 0 && actual) {
                        tooltip.add((ITextComponent)Tooltips.SP1().func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.base_modifier.equals." + op, new Object[]{_VALFMT.format(final_amount), new TranslationTextComponent("attribute.name." + entry.getKey())})));
                        continue;
                    }
                    if (pass == 0 || actual) continue;
                    if (!reforged_label) {
                        tooltip.add((ITextComponent)Tooltips.NL());
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.section.reforged.results"));
                        tooltip.add((ITextComponent)Tooltips.SP1().func_230529_a_((ITextComponent)new TranslationTextComponent("item.modifiers." + slot.func_188450_d())));
                    }
                    if (amount > 0.0) {
                        tooltip.add((ITextComponent)Tooltips.SP2().func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + op, new Object[]{_VALFMT.format(final_amount), new TranslationTextComponent("attribute.name." + entry.getKey())}).func_240699_a_(TextFormatting.BLUE)));
                        continue;
                    }
                    if (!(amount < 0.0)) continue;
                    tooltip.add((ITextComponent)Tooltips.SP2().func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + op, new Object[]{_VALFMT.format(final_amount *= -1.0), new TranslationTextComponent("attribute.name." + entry.getKey())}).func_240699_a_(TextFormatting.RED)));
                }
            }
        }
    }

    private static boolean isPercentageOp(int op) {
        return op == SharedGlue.OP_MUL_BASE_ATTR || op == SharedGlue.OP_MUL_TOTAL_ATTR;
    }

    @Nullable
    public static final Entity getShooter(@Nonnull ProjectileEntity shot) {
        return shot.func_234616_v_();
    }

    public static final boolean isDefendableAgainst(@Nonnull DamageSource with) {
        String name = with.func_76355_l();
        return "mob".equals(name) || "player".equals(name) || "thrown".equals(name) || with instanceof EntityDamageSource || with instanceof IndirectEntityDamageSource;
    }

    public static final boolean isDirectPlayerAttackDamage(DamageSource ds) {
        return ds instanceof EntityDamageSource && ("player".equals(ds.func_76355_l()) || "explosion.player".equals(ds.func_76355_l())) && SharedGlue.isaRealPlayer(ds.func_76364_f());
    }

    public static final boolean isDirectMonsterAttackDamage(DamageSource ds) {
        return ds instanceof EntityDamageSource && "mob".equals(ds.func_76355_l()) && SharedGlue.isMonsterOrPiOoed(ds.func_76364_f());
    }

    public static final boolean isDirectEntityAttackDamage(DamageSource ds) {
        return Armory.isDirectPlayerAttackDamage(ds) || Armory.isDirectMonsterAttackDamage(ds);
    }

    public static final boolean isRetaliateAttackDamage(DamageSource ds, @Nonnull PlayerEntity hurt) {
        return ds instanceof EntityDamageSource && Armory.isDirectEntityAttackDamage(ds) || ds instanceof IndirectEntityDamageSource && SharedGlue.isMonsterOrPiOoed(ds.func_76346_g(), (LivingEntity)hurt);
    }

    public static final boolean isDamageAbsolute(DamageSource with) {
        boolean is = with.func_151517_h();
        if (is && Armory.isDefendableAgainst(with)) {
            is = false;
        }
        return is;
    }

    public static final void damageItem(ItemStack stack, int amount, @Nonnull LivingEntity holder) {
        stack.func_222118_a(amount, holder, e -> {});
    }

    public static final boolean attemptDamageItemBounded(ItemStack armor, int amount, @Nonnull LivingEntity bearer) {
        boolean attempted = false;
        if (!ItemStacks.isEmpty(armor)) {
            int current_damage;
            if (SharedGlue.isaPlayer((Entity)bearer) && (current_damage = armor.func_77952_i()) + amount >= armor.func_77958_k()) {
                amount = armor.func_77958_k() - current_damage - 1;
            }
            if (amount > 0) {
                Armory.damageItem(armor, amount, bearer);
                attempted = true;
            }
        }
        return attempted;
    }

    private Armory() {
    }

    public static final void initAmendmentSupport() {
    }

    public static class Tags {
        public static final Tags.IOptionalNamedTag<Item> ARMOR = RID.Tags.forOptionalItems("forge:armor");
        public static final Tags.IOptionalNamedTag<Item> ANIMAL_ARMOR = RID.Tags.forOptionalItems("forge:armor/animals");
        public static final Tags.IOptionalNamedTag<Item> HELMETS = RID.Tags.forOptionalItems("forge:armor/helmets");
        public static final Tags.IOptionalNamedTag<Item> BOOTS = RID.Tags.forOptionalItems("forge:armor/boots");
        public static final Tags.IOptionalNamedTag<Item> CHESTPLATES = RID.Tags.forOptionalItems("forge:armor/chestplates");
        public static final Tags.IOptionalNamedTag<Item> LEGGINGS = RID.Tags.forOptionalItems("forge:armor/leggings");
        public static final Tags.IOptionalNamedTag<Item> GLOVES = RID.Tags.forOptionalItems("forge:armor/gloves");
        public static final Tags.IOptionalNamedTag<Item> SHIELDS = RID.Tags.forOptionalItems("forge:armor/shields");
        public static final Tags.IOptionalNamedTag<Item> NATURAL_WINGS = RID.Tags.forOptionalItems("forge:armor/wings");
        public static final ITag.INamedTag<Item> MELEE_WEAPONS = RID.Tags.forItems("forge", "weapons/melee");
        public static final ITag.INamedTag<Item> SLASHING_WEAPONS = RID.Tags.forItems("forge", "weapons/slashing");
        public static final ITag.INamedTag<Item> SMASHING_WEAPONS = RID.Tags.forItems("forge", "weapons/smashing");

        protected Tags() {
        }
    }

    public static enum XLining {
        NONE(-1, Layer.BOTH),
        TEMPERATURE_REGULATOR(3, Layer.BOTH),
        OBSIDIAN_SHIELD(0, Layer.INNER),
        ANTIFREEZE_SHIELD(0, Layer.INNER),
        PHOTOSYNTHETIC(0, Layer.OUTER),
        ANTI_CORROSIVE(2, Layer.OUTER),
        SHOCK_ABSORBER(3, Layer.OUTER),
        DENSE_PADDING(5, Layer.INNER),
        CAMOUFLAGE_COVER(0, Layer.OUTER),
        POTION_INFUSER(2, Layer.INNER),
        BIOHAZARD_SHIELD(3, Layer.BOTH),
        AIR_ENVELOPE(0, Layer.OUTER),
        BUOYANCY_ENVELOPE(0, Layer.OUTER),
        LUCKY_LINERS(3, Layer.BOTH),
        INSULATOR(3, Layer.OUTER),
        BUG_REPELLANT(3, Layer.OUTER),
        ENERGY_DEFLECTOR(5, Layer.OUTER),
        BANDAGES(3, Layer.INNER),
        BEEKEEPER_SKIN(0, Layer.BOTH),
        WETSUIT(3, Layer.OUTER);

        private static final XLining[] _VALUES;
        public static final String NBT_TAGNAME;
        private final int _val_count;
        @Nonnull
        private final Layer _layer;
        public static final Def EMPTY_SINGLE;
        public static final PairDef EMPTY_DOUBLE;

        private XLining(int value_count, Layer layer) {
            this._val_count = value_count;
            this._layer = layer;
        }

        public Layer getLayer() {
            return this._layer;
        }

        public boolean isOuter() {
            return this._layer == Layer.OUTER || this._layer == Layer.BOTH;
        }

        public boolean isInner() {
            return this._layer == Layer.INNER || this._layer == Layer.BOTH;
        }

        public final boolean isEmpty() {
            return this == NONE;
        }

        public boolean hasValues() {
            return this._val_count > 0;
        }

        public int getValueLimit() {
            return this._val_count;
        }

        public static final boolean isDefined(XLining value) {
            return value != null && value != NONE;
        }

        @Nonnull
        public static final XLining findOrNone(@Nonnull String id) {
            if (!id.isEmpty()) {
                id = id.toUpperCase(Locale.US);
                for (XLining lining : _VALUES) {
                    if (!lining.name().equals(id)) continue;
                    return lining;
                }
            }
            return NONE;
        }

        static {
            _VALUES = XLining.values();
            NBT_TAGNAME = LibInfo.rstring("ArmorXLining");
            EMPTY_SINGLE = new Def(NONE, 0);
            EMPTY_DOUBLE = new PairDef(EMPTY_SINGLE, EMPTY_SINGLE);
        }

        public static enum Layer {
            INNER,
            OUTER,
            BOTH;


            @Nullable
            public static Layer valueOf(int o) {
                if (o == INNER.ordinal()) {
                    return INNER;
                }
                if (o == OUTER.ordinal()) {
                    return OUTER;
                }
                if (o == BOTH.ordinal()) {
                    return BOTH;
                }
                throw new IllegalArgumentException();
            }
        }

        public static final class Def {
            @Nonnull
            public final XLining name;
            public final int value;

            public Def(@Nonnull XLining id, int i) {
                this.name = id == null ? NONE : id;
                this.value = i;
            }

            public Def(@Nonnull XLining id) {
                this(id, 0);
            }

            public final boolean isEmpty() {
                return this.name == NONE;
            }

            public String toString() {
                return "" + (Object)((Object)this.name) + (this.isEmpty() ? "" : ":" + this.value);
            }

            static final Def from(@Nonnull CompoundNBT nbt, String key) {
                XLining id = NONE;
                int i = 0;
                if (nbt.func_150297_b(key, 8)) {
                    id = XLining.findOrNone(nbt.func_74779_i(key));
                } else if (nbt.func_150297_b(key, 10) && (id = XLining.findOrNone((nbt = nbt.func_74775_l(key)).func_74779_i("id"))) != NONE) {
                    i = nbt.func_74762_e("value");
                }
                return id == NONE ? EMPTY_SINGLE : new Def(id, i);
            }

            static final void to(@Nonnull CompoundNBT nbt, String key, @Nonnull Def defn) {
                nbt.func_82580_o(key);
                if (!defn.isEmpty()) {
                    if (!defn.name.hasValues()) {
                        nbt.func_74778_a(key, defn.name.name());
                    } else {
                        CompoundNBT what = new CompoundNBT();
                        what.func_74778_a("id", defn.name.name());
                        what.func_74768_a("value", defn.value);
                        nbt.func_218657_a(key, (INBT)what);
                    }
                }
            }

            @Nonnull
            public Def adjust(int delta) {
                if (!this.name.hasValues()) {
                    return this;
                }
                int to = MathHelper.func_76125_a((int)(this.value + delta), (int)0, (int)this.name.getValueLimit());
                return to == this.value ? this : new Def(this.name, to);
            }

            @Nonnull
            public static Def read(PacketBuffer from) {
                int i = from.func_150792_a();
                XLining id = XLining.findOrNone(from.func_150789_c(256));
                return id == NONE ? EMPTY_SINGLE : new Def(id, i);
            }

            public void write(PacketBuffer to) {
                to.func_150787_b(this.value);
                to.func_211400_a(this.name.name(), 256);
            }
        }

        public static final class PairDef {
            @Nonnull
            public final Def inner;
            @Nonnull
            public final Def outer;

            PairDef(Def i, Def o) {
                this.inner = i;
                this.outer = o;
            }

            public final boolean isEmpty() {
                return this.inner.isEmpty() && this.outer.isEmpty();
            }

            public final boolean hasStrict(@Nullable XLining lining) {
                if (lining == null || lining == NONE) {
                    return this.isEmpty();
                }
                return this.inner.name == lining && lining.isInner() || this.outer.name == lining && lining.isOuter();
            }

            public final boolean has(@Nullable XLining lining) {
                if (lining == null || lining == NONE) {
                    return this.isEmpty();
                }
                return this.inner.name == lining || this.outer.name == lining;
            }

            @Nonnull
            public final Def getStrict(@Nonnull XLining lining) {
                if (this.inner.name == lining && lining.isInner()) {
                    return this.inner;
                }
                if (this.outer.name == lining && lining.isOuter()) {
                    return this.outer;
                }
                return EMPTY_SINGLE;
            }

            @Nonnull
            public final Def get(@Nonnull XLining lining) {
                if (this.inner.name == lining) {
                    return this.inner;
                }
                if (this.outer.name == lining) {
                    return this.outer;
                }
                return EMPTY_SINGLE;
            }

            @Nullable
            public PairDef merge(@Nonnull Def chg) {
                if (!chg.isEmpty()) {
                    if (this.inner.name == chg.name) {
                        return new PairDef(chg, this.outer);
                    }
                    if (this.outer.name == chg.name) {
                        return new PairDef(this.inner, chg);
                    }
                    if (this.inner.isEmpty() && chg.name.isInner()) {
                        return new PairDef(chg, this.outer);
                    }
                    if (this.outer.isEmpty() && chg.name.isOuter()) {
                        return new PairDef(this.inner, chg);
                    }
                }
                return this;
            }

            public static PairDef newInner(Def inn) {
                return new PairDef(inn == null ? EMPTY_SINGLE : inn, EMPTY_SINGLE);
            }

            public static PairDef newOuter(Def out) {
                return new PairDef(EMPTY_SINGLE, out == null ? EMPTY_SINGLE : out);
            }
        }

        public static interface Behavior {
            default public void onEquipped(LivingEquipmentChangeEvent e) {
            }

            default public void onAddedTo(ItemStack to) {
            }

            default public void onRemovedFrom(ItemStack from) {
            }

            default public void onLivingTick(LivingEntity wearer) {
            }

            default public void onAboutToDamage(LivingDamageEvent e) {
            }

            default public void onHurt(LivingHurtEvent e) {
            }

            default public void onAttacked(LivingAttackEvent e) {
            }
        }
    }

    public static enum TLining {
        COOLEST(-3),
        COOLER(-2),
        COOL(-1),
        NONE(0),
        WARM(1),
        WARMER(2),
        WARMEST(3);

        private static final TLining[] _VALUES;
        public static final String NBT_TAGNAME;
        private final int _modifier;

        private TLining(int modifier) {
            this._modifier = modifier;
        }

        public final boolean isEmpty() {
            return this == NONE;
        }

        public int getModifier() {
            return this._modifier;
        }

        public int getOffsetModifier() {
            return this.ordinal() - NONE.ordinal();
        }

        public int getThickness() {
            return Math.abs(this.getOffsetModifier());
        }

        public int getDirection() {
            return Integer.compare(this.ordinal(), NONE.ordinal());
        }

        public static final boolean isDefined(TLining value, boolean noneIsFalse) {
            return value == null ? false : (noneIsFalse ? value != NONE : true);
        }

        @Nonnull
        public static final TLining findOrNone(@Nonnull String id) {
            id = id.toUpperCase(Locale.US);
            for (TLining lining : _VALUES) {
                if (!lining.name().equals(id)) continue;
                return lining;
            }
            return NONE;
        }

        @Nonnull
        public final TLining adjust(int delta) {
            int to = this.ordinal() + delta;
            for (int i = 0; i < _VALUES.length; ++i) {
                if (to != _VALUES[i].ordinal()) continue;
                return _VALUES[i];
            }
            return to <= COOLEST.ordinal() ? COOLEST : WARMEST;
        }

        static {
            _VALUES = TLining.values();
            NBT_TAGNAME = LibInfo.rstring("ArmorTLining");
        }
    }

    public static final class UUIDPeek
    extends Item {
        public static final UUID getAttackDamageUUID() {
            return Item.field_111210_e;
        }

        public static final UUID getAttackSpeedoUUID() {
            return Item.field_185050_h;
        }

        public static final boolean isAttackDamage(String uuidstring) {
            return UUIDPeek.getAttackDamageUUID().toString().equals(uuidstring);
        }

        public static final boolean isAttackDamage(UUID uuid) {
            return uuid != null && (uuid == Item.field_111210_e || UUIDPeek.isAttackDamage(uuid.toString()));
        }

        public static final boolean isAttackSpeedo(String uuidstring) {
            return UUIDPeek.getAttackSpeedoUUID().toString().equals(uuidstring);
        }

        public static final boolean isAttackSpeedo(UUID uuid) {
            return uuid != null && (uuid == Item.field_185050_h || UUIDPeek.isAttackSpeedo(uuid.toString()));
        }

        private UUIDPeek() {
            super(new Item.Properties());
        }
    }
}

