/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Association
implements Comparable<Association>,
Cloneable,
Supplier<String> {
    public String id;
    @Nullable
    public ITextComponent name;

    Association() {
    }

    public Association(@Nonnull LivingEntity living) {
        this.reassign(living);
    }

    public Association(@Nonnull TileEntity machine) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("m||").append(machine.func_200662_C().getRegistryName().toString()).append("||");
        BlockPos bp = machine.func_174877_v();
        sb.append(bp.func_218275_a());
        this.id = sb.toString();
        if (machine instanceof INameable) {
            INameable spi = (INameable)machine;
            this.name = spi.func_145818_k_() ? spi.func_200201_e() : spi.func_145748_c_();
        }
    }

    public Association(@Nonnull LivingEntity living, @Nullable ITextComponent display) {
        this.id = living.func_189512_bd();
        this.name = display;
    }

    public Association(@Nonnull Team team) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("t||").append(team.func_96661_b().replace(' ', '_')).append("||");
        sb.append(team.func_96665_g() ? (char)'F' : 'f');
        sb.append(team.func_178771_j() != null ? Integer.valueOf(team.func_178771_j().ordinal()) : "-");
        sb.append(team.func_186681_k() != null ? Integer.valueOf(team.func_186681_k().ordinal()) : "-");
        this.id = sb.toString();
        this.name = new StringTextComponent(team.func_96661_b());
    }

    public final void reassign(@Nonnull LivingEntity living) {
        this.id = living.func_189512_bd();
        this.name = SharedGlue.isaPlayer((Entity)living) ? SharedGlue.getPlayerOrNull((Entity)living).func_200200_C_() : (living.func_145818_k_() ? living.func_200201_e() : (living.func_96124_cp() != null ? new StringTextComponent(living.func_96124_cp().func_96661_b()).func_240702_b_(" ").func_230529_a_(living.func_145748_c_()) : living.func_145748_c_()));
    }

    @Override
    public String get() {
        return this.id == null ? "" : this.id;
    }

    @Nonnull
    public final String displayName() {
        return this.name != null ? this.name.getString() : "";
    }

    public final boolean isMachine() {
        return this.id != null && this.id.startsWith("m||") && this.id.lastIndexOf("||") > 1;
    }

    public final boolean isTeam() {
        return this.id != null && this.id.startsWith("t||") && this.name == null && this.id.length() < 23;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() == Association.class) {
            return Objects.equals(this.id, ((Association)other).id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public int compareTo(Association other) {
        if (other == null) {
            throw new NullPointerException("association");
        }
        if (other == this) {
            return 0;
        }
        if (other.id == null) {
            return this.id == null ? 0 : 1;
        }
        if (this.id == null) {
            return other.id == null ? 0 : -1;
        }
        return this.id.compareTo(other.id);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException clnx) {
            throw new InternalError("nagah happin");
        }
    }

    public static final class NBTKey
    implements Comparable<NBTKey> {
        public final String ID;
        public final String NAME;
        public final String TIP;
        public static final NBTKey BLANK = new NBTKey();
        public static final NBTKey OWNER = new NBTKey("OwnerUUID", "OwnerName", "owner");
        public static final NBTKey CREATOR = new NBTKey("MakerUUID", "MakerName", "creator");
        public static final NBTKey VENDOR = new NBTKey("VendorUUID", "VendorName", "vendor");
        public static final NBTKey TEAM = new NBTKey("TeamID", "TeamName", "team");

        public NBTKey(String id, String nm, String tp) {
            this.ID = id;
            this.NAME = nm;
            this.TIP = tp;
        }

        private NBTKey() {
            this(null, null, null);
        }

        public static final boolean isEmpty(NBTKey key) {
            return key == null || key == BLANK || key.ID == null || key.ID.isEmpty();
        }

        @Override
        public int compareTo(NBTKey other) {
            if (other == null) {
                throw new NullPointerException("NBTKey");
            }
            if (other == this) {
                return 0;
            }
            return this.ID.compareTo(other.ID);
        }
    }
}

