/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IBlockItem;
import org.jwaresoftware.mcmods.lib.api.IBurnable;

public final class BurnTimes {
    public static final int NONE = -1;
    public static final int STANDARD_COOK_TIME = 200;
    public static final int SHORTENED_COOK_TIME = 100;
    public static final int FULL_STACK_BURN_TIME = 200 * SharedGlue.PINNED_MAX_STACK_SIZE(-1, 10.0f);
    public static final int STICK_BURN_TIME = 100;
    public static final int WOOL_BURN_TIME = 100;
    public static final int WOODEN_ITEM_BURN_TIME = 300;
    public static final int BOOK_BURN_TIME = 200;
    public static final int PAPER_BURN_TIME = 60;
    public static final int COAL_BURN_TIME = 1600;
    public static final int DENSE_COAL_BURN_TIME = 6400;
    public static final int COAL_BLOCK_BURN_TIME = 16000;
    public static final int BLAZEROD_BURN_TIME = 2400;
    public static final int MAGMA_BURN_TIME = 4800;
    public static final int LOG_BURN_TIME = 300;
    public static final int DENSE_LOG_BURN_TIME = 400;
    public static final int PLANKS_BURN_TIME = 300;
    public static final int LAVA_BUCKET_BURN_TIME = 20000;
    public static final int BIG_LAVA_BUCKET_BURN_TIME = 345600;
    public static final int MINIMAX_BURN_TIME = 640000;
    public static final int MAX_BURN_TIME = 1280000;

    public static final int getFrom(@Nonnull ItemStack stack) {
        int bT = -1;
        if (!ItemStacks.isEmpty(stack)) {
            try {
                Block block;
                Item item = stack.func_77973_b();
                if (item instanceof IBurnable) {
                    bT = ((IBurnable)item).burnTime(stack);
                } else if (item instanceof IBlockItem) {
                    Block block2 = ((IBlockItem)item).getBlock();
                    if (block2 instanceof IBurnable) {
                        bT = ((IBurnable)block2).burnTime(stack);
                    }
                } else if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof IBurnable) {
                    bT = ((IBurnable)block).burnTime(stack);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return bT;
    }

    private static boolean in(ITag<Block> set, Block b) {
        return set.func_230235_a_((Object)b);
    }

    public static final int getFrom(Block material) {
        int bT = -1;
        try {
            if (BurnTimes.in((ITag<Block>)BlockTags.field_203285_n, material) || BurnTimes.in((ITag<Block>)BlockTags.field_203289_r, material)) {
                bT = 400;
            } else if (BurnTimes.in((ITag<Block>)BlockTags.field_200031_h, material)) {
                bT = 300;
            } else if (SharedGlue.isSame(material, Blocks.field_196814_hQ)) {
                bT = 4800;
            } else if (BurnTimes.in((ITag<Block>)BlockTags.field_199898_b, material)) {
                bT = 300;
            } else if (BurnTimes.in((ITag<Block>)BlockTags.field_199897_a, material)) {
                bT = 100;
            } else if (SharedGlue.isSame(material, Blocks.field_150424_aL)) {
                bT = 100;
            } else if (SharedGlue.isSame(material, Blocks.field_222405_kQ)) {
                bT = 50;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return bT;
    }

    private BurnTimes() {
    }
}

