/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IceBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Materials;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.Whatis;

public final class Fluids {
    public static final int UNCRAFTABLE_COLOR = 0xF800F8;
    public static final int BOTTLES_PER_BUCKET = 4;
    public static final int BOWLS_PER_BUCKET = 4;
    public static final int INK_SACS_PER_BUCKET = 16;
    public static final int MARBLES_PER_BUCKET = 8;
    public static final int JARS_PER_BUCKET = 2;
    public static final int MILLIBUCKETS_PER_BOTTLE = 250;
    public static final float DRINKS_PER_BUCKET = 2.75f;
    public static final int MILLIBUCKETS_PER_USE = 100;
    public static final int USES_PER_BUCKET = 10;
    public static final int ALL_FLUID = Integer.MAX_VALUE;
    public static final int BUCKETFUL = 1000;
    public static final int BOTTLEFUL = 250;
    public static final int MARBLEFUL = 125;
    public static final int JARFUL = 500;
    @Nonnull
    public static final Fluid NO_FLUID = net.minecraft.fluid.Fluids.field_204541_a;
    public static final String SWIMMABLE_IN_FLUID_NAME = "swimmable_in";
    public static final String POTABLE_WATER_FLUID_NAME = "potable_water";
    public static final String DIRTY_WATER_FLUID_NAME = "dirty_water";
    public static final String WATER_FLUID_NAME = "water";
    public static final String WATER_FLUID_TAG = "minecraft:water";
    public static final String FLOWING_WATER_FLUID_NAME = "flowing_water";
    public static final String ANY_WATER_FLUID_TAG = "forge:any_water";
    public static final String POTABLE_WATER_FLUID_TAG = "forge:potable_water";
    public static final String UNTREATED_WATER_FLUID_TAG = "forge:untreated_water";
    public static final String LAVA_FLUID_NAME = "lava";
    public static final String LAVA_FLUID_TAG = "minecraft:lava";
    public static final String MILK_FLUID_NAME = "milk";
    public static final String MILK_FLUID_TAG = "forge:milk";
    public static final String ANY_MILK_FLUID_TAG = "forge:any_milk";
    public static final String ANIMALMILK_FLUID_TAG = "forge:animal_milk";
    public static final String PLANTMILK_FLUID_TAG = "forge:plant_milk";
    public static final String COWMILK_FLUID_NAME = "cow_milk";
    public static final String SHEEPMILK_FLUID_NAME = "sheep_milk";
    public static final String GOATMILK_FLUID_NAME = "goat_milk";
    public static final String OATMILK_FLUID_NAME = "oatmilk";
    public static final String HONEY_FLUID_NAME = "honey";
    public static final String HONEY_FLUID_TAG = "forge:honey";
    public static final String SQUIDINK_FLUID_NAME = "squidink";
    public static final String SQUIDINK_FLUID_TAG = "forge:ink";
    public static final String EXPERIENCE_FLUID_NAME = "experience";
    public static final String EXPERIENCE_FLUID_TAG = "forge:experience";
    public static final String SEEDOIL_FLUID_NAME = "seedoil";
    public static final String SEEDOIL_FLUID_TAG = "forge:seedoil";
    public static final String POTION_FLUID_NAME = "potion";
    public static final String POTION_FLUID_TAG = "forge:potion";
    public static final String SLIME_FLUID_NAME = "slime";
    public static final String SLIME_FLUID_TAG = "forge:slime";
    public static final String SLURRY_FLUID_NAME = "slurry";
    public static final String SLURRY_FLUID_TAG = "forge:slurry";
    static final String _NBT_FLUID = "Fluid";
    public static final int MAX_HOT_FOR_WOOD = 573;
    @Nullable
    public static FlowingFluid MILK;
    @Nullable
    public static FlowingFluid FLOWING_MILK;
    @Nullable
    public static FlowingFluid POTABLE_WATER;
    @Nullable
    public static FlowingFluid FLOWING_POTABLE_WATER;
    @Nullable
    public static FlowingFluid EXPERIENCE;
    @Nullable
    public static FlowingFluid FLOWING_EXPERIENCE;
    @Nullable
    public static FlowingFluid HONEY;
    @Nullable
    public static FlowingFluid FLOWING_HONEY;
    @Nullable
    public static FlowingFluid SEEDOIL;
    @Nullable
    public static FlowingFluid FLOWING_SEEDOIL;
    @Nullable
    public static FlowingFluid SQUIDINK;
    @Nullable
    public static FlowingFluid FLOWING_SQUIDINK;
    @Nullable
    public static FlowingFluid OATMILK;
    @Nullable
    public static FlowingFluid FLOWING_OATMILK;

    public static final boolean isNone(@Nullable Fluid f) {
        return f == null || f == net.minecraft.fluid.Fluids.field_204541_a || f instanceof EmptyFluid;
    }

    public static final boolean isNone(FluidStack f) {
        return f == null || f.isEmpty() || Fluids.isNone(f.getFluid());
    }

    @Nullable
    public static final FluidStack sameOrNull(FluidStack f) {
        return Fluids.isNone(f) ? null : f;
    }

    public static final boolean isDefined(ResourceLocation fluidName) {
        return fluidName != null && ForgeRegistries.FLUIDS.containsKey(fluidName);
    }

    @Nonnull
    public static final String registryName(@Nullable Fluid f) {
        ResourceLocation rid = f != null ? f.getRegistryName() : null;
        return rid == null ? "" : rid.toString();
    }

    @Nonnull
    public static final String name(@Nonnull Fluid f) {
        ResourceLocation rid = f.getRegistryName();
        return rid == null ? "" : rid.func_110623_a();
    }

    public static final boolean isPotableWater(String fluidName) {
        return fluidName != null && LiquidType.POTABLE_WATER.matches(fluidName);
    }

    public static final boolean isPotableWater(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.POTABLE_WATER.matches(supplied);
    }

    public static final boolean isPotableWater(@Nullable FluidStack supplied) {
        return supplied != null && Fluids.isPotableWater(supplied.getFluid());
    }

    public static final boolean isWater(String fluidName) {
        return fluidName != null && (WATER_FLUID_NAME.equals(fluidName) || LiquidType.WATER.matches(fluidName));
    }

    public static final boolean isWater(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && (supplied == net.minecraft.fluid.Fluids.field_204546_a || supplied.func_207185_a((ITag)FluidTags.field_206959_a) || LiquidType.WATER.matches(supplied));
    }

    public static final boolean isWater(@Nullable FluidStack supplied) {
        return supplied != null && Fluids.isWater(supplied.getFluid());
    }

    public static final boolean isMilk(@Nullable String fluidName) {
        return fluidName != null && (MILK_FLUID_NAME.equals(fluidName) || COWMILK_FLUID_NAME.equals(fluidName));
    }

    public static final boolean isMilk(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && (supplied.func_207185_a(Tags.MILK) || Fluids.isMilk(Fluids.name(supplied)));
    }

    public static final boolean isMilk(@Nullable FluidStack supplied) {
        return supplied != null && Fluids.isMilk(supplied.getFluid());
    }

    public static final boolean isCowMilk(FluidStack fluid) {
        return Fluids.isMilk(fluid != null ? Fluids.name(fluid.getFluid()) : "");
    }

    public static final boolean isAnimalMilk(@Nullable String fluidName) {
        return fluidName != null && (MILK_FLUID_NAME.equals(fluidName) || LiquidType.ANIMALMILK.matches(fluidName));
    }

    public static final boolean isAnimalMilk(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.ANIMALMILK.matches(supplied);
    }

    public static final boolean isPlantMilk(@Nullable String fluidName) {
        return fluidName != null && LiquidType.PLANTMILK.matches(fluidName);
    }

    public static final boolean isPlantMilk(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.PLANTMILK.matches(supplied);
    }

    public static final boolean isCream(@Nullable String fluidName) {
        return fluidName != null && ("cream".equals(fluidName) || LiquidType.CREAM.matches(fluidName));
    }

    public static final boolean isCream(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.CREAM.matches(supplied);
    }

    public static final boolean isMilkLike(@Nullable String fluidName) {
        return fluidName != null && (Fluids.isAnimalMilk(fluidName) || Fluids.isCream(fluidName) || Fluids.isPlantMilk(fluidName) || "muscle_milk".equals(fluidName));
    }

    public static final boolean isMilkLike(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && (LiquidType.MILK.matches(supplied) || LiquidType.CREAM.matches(supplied));
    }

    public static final boolean isMilkLike(@Nullable FluidStack supplied) {
        return supplied != null && Fluids.isMilkLike(supplied.getFluid());
    }

    public static final boolean isHot(Fluid supplied) {
        return !Fluids.isNone(supplied) && (supplied == net.minecraft.fluid.Fluids.field_204547_b || supplied.getAttributes().getTemperature() > 573);
    }

    public static final boolean isLava(String fluidName) {
        return fluidName != null && (LAVA_FLUID_NAME.equals(fluidName) || "magma".equals(fluidName));
    }

    public static final boolean isLava(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && (supplied == net.minecraft.fluid.Fluids.field_204547_b || supplied.func_207185_a((ITag)FluidTags.field_206960_b) || Fluids.isLava(Fluids.name(supplied)));
    }

    public static final boolean isLava(@Nullable FluidStack supplied) {
        return supplied != null && Fluids.isLava(supplied.getFluid());
    }

    public static final boolean isHoney(@Nullable String fluidName) {
        return fluidName != null && LiquidType.HONEY.matches(fluidName);
    }

    public static final boolean isHoney(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.HONEY.matches(supplied);
    }

    public static final boolean isSeedoil(@Nullable String fluidName) {
        return SEEDOIL_FLUID_NAME.equals(fluidName) || "seed_oil".equals(fluidName) || "plantoil".equals(fluidName) || "plant_oil".equals(fluidName);
    }

    public static final boolean isSeedoil(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && (supplied.func_207185_a(Tags.SEEDOIL) || Fluids.isSeedoil(Fluids.name(supplied)));
    }

    public static final boolean isLiquidXp(String fluidName) {
        return fluidName != null && LiquidType.XP.matches(fluidName);
    }

    public static final boolean isLiquidXp(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.XP.matches(supplied);
    }

    public static final boolean isLiquidXp(FluidStack supplied) {
        return supplied != null && Fluids.isLiquidXp(supplied.getFluid());
    }

    public static final boolean isPotion(String fluidName) {
        return fluidName != null && LiquidType.POTION.matches(fluidName);
    }

    public static final boolean isPotion(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.POTION.matches(supplied);
    }

    public static final boolean isLiquidSlime(String fluidName) {
        return fluidName != null && (LiquidType.SLIME.matches(fluidName) || "pink_slime".equals(fluidName));
    }

    public static final boolean isLiquidSlime(@Nullable Fluid supplied) {
        return !Fluids.isNone(supplied) && LiquidType.SLIME.matches(supplied);
    }

    public static final boolean isLiquidSlime(FluidStack supplied) {
        return supplied != null && Fluids.isLiquidSlime(supplied.getFluid());
    }

    public static final boolean isSimilar(@Nonnull Fluid supplied, @Nonnull Fluid match, @Nullable String tag, boolean strict) {
        if (supplied == match) {
            return true;
        }
        boolean none = Fluids.isNone(supplied);
        if (Fluids.isNone(match)) {
            return tag != null && !none ? RID.isIn(supplied, tag) : none;
        }
        if (!none) {
            if (RID.isIn(supplied, tag)) {
                return true;
            }
            if (Fluids.name(match).equals(Fluids.name(supplied))) {
                return true;
            }
            if (match == Fluids.water()) {
                return Fluids.isWater(supplied);
            }
            if (!strict && Fluids.isMilk(match)) {
                return Fluids.isMilkLike(supplied);
            }
        }
        return false;
    }

    @Nonnull
    public static final Fluid getFluid(@Nonnull String fluidName) {
        ResourceLocation rid = ResourceLocation.func_208304_a((String)fluidName);
        Fluid f = NO_FLUID;
        if (rid != null) {
            f = (Fluid)ForgeRegistries.FLUIDS.getValue(rid);
        }
        return f;
    }

    @Nullable
    public static final Fluid getFluidOrNull(@Nullable String fluidName) {
        Fluid f = fluidName != null ? Fluids.getFluid(fluidName) : null;
        return Fluids.isNone(f) ? null : f;
    }

    public static final float getFillLevel(World world, BlockState state, @Nullable BlockPos pos) {
        Block block = state.func_177230_c();
        float filled = 1.0f;
        if (block instanceof IFluidBlock) {
            if (pos == null) {
                pos = BlockPos.field_177992_a;
            }
            filled = ((IFluidBlock)block).getFilledPercentage(world, pos);
        } else if (block instanceof FlowingFluidBlock) {
            filled = (float)((FlowingFluidBlock)block).func_204507_t(state).func_206882_g() / 8.0f;
        }
        return filled;
    }

    public static final int toBucketMillibuckets(int millibuckets) {
        return millibuckets - millibuckets % 1000;
    }

    public static final int getAmount(@Nullable FluidStack fs) {
        return fs == null || fs.isEmpty() || Fluids.isNone(fs.getFluid()) ? 0 : fs.getAmount();
    }

    @Nonnull
    public static final FluidStack copy(@Nonnull FluidStack from, int amount) {
        return new FluidStack(from, amount < 0 ? 0 : amount);
    }

    public static final boolean hasFluidChildTag(@Nonnull ItemStack stack) {
        return ItemStacks.hasMap(stack, _NBT_FLUID);
    }

    @Nonnull
    public static final FluidStack getGenericFluid(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof BucketItem) {
            Fluid f = ((BucketItem)stack.func_77973_b()).getFluid();
            if (Fluids.isNone(f)) {
                return FluidStack.EMPTY;
            }
            CompoundNBT data = null;
            if (Fluids.hasFluidChildTag(stack)) {
                data = ItemStacks.getMap(stack, _NBT_FLUID).func_74737_b();
            } else if (stack.func_77942_o()) {
                data = stack.func_77978_p().func_74737_b();
            }
            return new FluidStack(f, 1000, data);
        }
        if (!Fluids.hasFluidChildTag(stack)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)ItemStacks.getMap(stack, _NBT_FLUID));
    }

    @Nonnull
    public static final FluidStack getBucketFluid(@Nonnull ItemStack bucket) {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)bucket.func_77978_p());
    }

    public static final int getBucketFluidAmount(@Nonnull ItemStack bucket) {
        return Fluids.getBucketFluid(bucket).getAmount();
    }

    public static final int toBucketfuls(ItemStack bucket) {
        return Fluids.getBucketFluidAmount(bucket) / 1000;
    }

    public static final String toBucketString(FluidStack fluid) {
        return fluid == null || fluid.isEmpty() ? "NULL" : "" + Fluids.name(fluid.getFluid()) + "(" + fluid.getAmount() + "mB)";
    }

    public static final String toBucketString(ItemStack bucket) {
        FluidStack fluid = Fluids.getBucketFluid(bucket);
        return Fluids.toBucketString(fluid);
    }

    public static final IFormattableTextComponent toBucketDisplayString(@Nonnull FluidStack fluid) {
        IFormattableTextComponent dn = Tooltips.toMutable(fluid.getDisplayName());
        String mB = Strings.translateFormatted("tooltip.itemsuffix.millibuckets", fluid.getAmount());
        return dn.func_230529_a_((ITextComponent)new StringTextComponent(mB).func_240699_a_(TextFormatting.BLUE));
    }

    @Nonnull
    public static final ItemStack setBucketFluid(@Nonnull ItemStack filled_bucket, @Nonnull FluidStack to, boolean preserve) {
        CompoundNBT tag;
        if (preserve && filled_bucket.func_77942_o()) {
            tag = filled_bucket.func_77978_p();
            tag.func_82580_o("Tag");
        } else {
            tag = new CompoundNBT();
        }
        to.writeToNBT(tag);
        filled_bucket.func_77982_d(tag);
        return filled_bucket;
    }

    public static final ItemStack getFilledBucket(ModIntegration modid, String bucketid, FluidStack of, int capacity) {
        ItemStack filled_bucket = modid.itemstack(bucketid);
        if (!filled_bucket.func_190926_b()) {
            if (capacity <= 0) {
                capacity = 1000;
            }
            Fluids.setBucketFluid(filled_bucket, new FluidStack(of, capacity), false);
        }
        return filled_bucket;
    }

    public static final ItemStack getFilledBucket(ModIntegration modid, String bucketid, FluidStack of) {
        return Fluids.getFilledBucket(modid, bucketid, of, of.getAmount());
    }

    public static final void removeBucketData(ItemStack from) {
        if (from.func_77942_o()) {
            ItemStacks.removeData(from, "FluidName", 8, false);
            ItemStacks.removeData(from, "Amount", 99, false);
            ItemStacks.removeData(from, "Tag", 10, false);
            ItemStacks.normalizeData(from);
        }
    }

    public static final boolean isBucketOf(@Nonnull ItemStack stack, @Nonnull Predicate<FluidStack> check) {
        FluidStack f;
        return ModIntegration.isUniversalBucket(stack) && (f = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse(null)) != null && f.getAmount() >= 1000 && check.test((Object)f);
    }

    public static final boolean isBucketOf(@Nonnull ItemStack stack, @Nonnull Fluid fluid, @Nullable String tag, boolean strict) {
        return Fluids.isBucketOf(stack, (Predicate<FluidStack>)((Predicate)f -> Fluids.isSimilar(f.getFluid(), fluid, tag, strict)));
    }

    public static final boolean isWaterBucket(@Nonnull ItemStack stack) {
        return RID.matches(stack, "buckets/water", Items.field_151131_as) || POTABLE_WATER != null && stack.func_77973_b() == POTABLE_WATER.func_204524_b() ? true : Fluids.isBucketOf(stack, (Fluid)Fluids.water(), ANY_WATER_FLUID_TAG, false);
    }

    public static final boolean isPotableWaterBucket(@Nonnull ItemStack stack) {
        return RID.matches(stack, "buckets/potable_water", POTABLE_WATER != null ? POTABLE_WATER.func_204524_b() : null) ? true : Fluids.isBucketOf(stack, Fluids.potable_water(), POTABLE_WATER_FLUID_TAG, false);
    }

    public static final boolean isLavaBucket(@Nonnull ItemStack stack) {
        return RID.matches(stack, "buckets/lava", Items.field_151129_at) ? true : Fluids.isBucketOf(stack, (Fluid)Fluids.lava(), LAVA_FLUID_TAG, true);
    }

    public static final boolean isMilkBucket(@Nonnull ItemStack stack) {
        return RID.matches(stack, "buckets/milk", Items.field_151117_aB) ? true : (MILK != null ? Fluids.isBucketOf(stack, (Fluid)MILK, ANY_MILK_FLUID_TAG, false) : Fluids.isBucketOf(stack, (Predicate<FluidStack>)((Predicate)f -> Fluids.isMilkLike(f))));
    }

    public static final boolean isSimpleFluid(@Nonnull FluidStack fluid) {
        return fluid.getTag() == null || fluid.getTag().isEmpty();
    }

    public static final boolean isBucketOf(@Nonnull ItemStack stack, @Nonnull FluidStack match) {
        if (Fluids.isSimpleFluid(match)) {
            String fluid_name = Fluids.name(match.getFluid());
            if (WATER_FLUID_NAME.equals(fluid_name)) {
                return Fluids.isWaterBucket(stack);
            }
            if (MILK_FLUID_NAME.equals(fluid_name)) {
                return Fluids.isMilkBucket(stack);
            }
            if (LAVA_FLUID_NAME.equals(fluid_name)) {
                return Fluids.isLavaBucket(stack);
            }
        }
        FluidStack have = null;
        return ModIntegration.isUniversalBucket(stack) && (have = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse(null)) != null && have.containsFluid(match);
    }

    public static final boolean isBucketOf(@Nonnull ItemStack stack, @Nonnull FluidStack match, @Nonnull String tag) {
        if (tag.isEmpty()) {
            return Fluids.isBucketOf(stack, match);
        }
        if (Strings.isAllValue(tag, false)) {
            return ModIntegration.isUniversalBucket(stack) && FluidUtil.getFluidContained((ItemStack)stack).orElse(null) != null;
        }
        if (tag.indexOf(58) < 0) {
            if (WATER_FLUID_NAME.equals(tag)) {
                return Fluids.isWaterBucket(stack);
            }
            if (MILK_FLUID_NAME.equals(tag)) {
                return Fluids.isMilkBucket(stack);
            }
            if (LAVA_FLUID_NAME.equals(tag)) {
                return Fluids.isLavaBucket(stack);
            }
        }
        return Fluids.isBucketOf(stack, (Predicate<FluidStack>)((Predicate)f -> Fluids.isSimilar(f.getFluid(), match.getFluid(), tag, false)));
    }

    public static final ItemStack newPotionHeldItem(FluidStack supplied) {
        CompoundNBT ptag;
        CompoundNBT from;
        ItemStack potionitem = ItemStack.field_190927_a;
        if (supplied.hasTag() && Potions.copyDefinition(from = supplied.getTag(), ptag = new CompoundNBT())) {
            potionitem = new ItemStack((IItemProvider)Items.field_151068_bn);
            potionitem.func_77982_d(ptag);
        }
        return potionitem;
    }

    public static final boolean isEmpty(@Nullable IFluidHandler fh) {
        return Fluids.getFirstNonEmpty(fh) == null;
    }

    @Nullable
    public static final FluidStack getFirstNonEmpty(@Nullable IFluidHandler fh) {
        if (fh != null && fh.getTanks() > 0) {
            int n = fh.getTanks();
            for (int i = 0; i < n; ++i) {
                FluidStack fluid = fh.getFluidInTank(i);
                if (fluid == null || fluid.isEmpty() || Fluids.isNone(fluid.getFluid())) continue;
                return fluid.copy();
            }
        }
        return null;
    }

    @Nullable
    public static final Fluid getFirstFluid(@Nullable IFluidHandler fh) {
        FluidStack f = Fluids.getFirstNonEmpty(fh);
        return f != null ? f.getFluid() : null;
    }

    @Nonnull
    public static final FlowingFluid water() {
        return net.minecraft.fluid.Fluids.field_204546_a;
    }

    @Nonnull
    public static final FlowingFluid lava() {
        return net.minecraft.fluid.Fluids.field_204547_b;
    }

    @Nonnull
    public static final Fluid potable_water() {
        return POTABLE_WATER != null ? POTABLE_WATER : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid milk() {
        return MILK != null ? MILK : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid oatmilk() {
        return OATMILK != null ? OATMILK : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid experience() {
        return EXPERIENCE != null ? EXPERIENCE : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid honey() {
        return HONEY != null ? HONEY : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid seedoil() {
        return SEEDOIL != null ? SEEDOIL : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final Fluid ink() {
        return SQUIDINK != null ? SQUIDINK : net.minecraft.fluid.Fluids.field_204541_a;
    }

    @Nonnull
    public static final FluidStack marbleOf(Fluid f) {
        return f == null ? FluidStack.EMPTY : new FluidStack(f, 125);
    }

    @Nonnull
    public static final FluidStack bottleOf(Fluid f) {
        return f == null ? FluidStack.EMPTY : new FluidStack(f, 250);
    }

    @Nonnull
    public static final FluidStack bottleOf(Fluid f, int count) {
        return f == null ? FluidStack.EMPTY : new FluidStack(f, 250 * count);
    }

    @Nonnull
    public static final FluidStack bucketOf(Fluid f) {
        return f == null ? FluidStack.EMPTY : new FluidStack(f, 1000);
    }

    public static final boolean isStandingIn(Entity e, ITag<Fluid> fluids, boolean checkChunkLoaded) {
        if (Whatis.isBoat(e.func_184187_bx())) {
            return false;
        }
        return e.func_208600_a(fluids);
    }

    public static final boolean isStandingIn(Entity e, ITag<Fluid> fluids) {
        return Fluids.isStandingIn(e, fluids, false);
    }

    private Fluids() {
    }

    public static final void init() {
    }

    public static class Tags {
        public static final ITag<Fluid> SWIMMABLE_IN = FluidTags.func_206956_a((String)RID.fstring("swimmable_in"));
        public static final ITag<Fluid> ANY_WATER = FluidTags.func_206956_a((String)"forge:any_water");
        public static final ITag<Fluid> POTABLE_WATER = FluidTags.func_206956_a((String)RID.fstring("potable_water"));
        public static final ITag<Fluid> MILK = FluidTags.func_206956_a((String)"forge:milk");
        public static final ITag<Fluid> ANY_MILK = FluidTags.func_206956_a((String)"forge:any_milk");
        public static final ITag<Fluid> ANIMAL_MILK = FluidTags.func_206956_a((String)"forge:animal_milk");
        public static final ITag<Fluid> PLANT_MILK = FluidTags.func_206956_a((String)"forge:plant_milk");
        public static final ITag<Fluid> HONEY = FluidTags.func_206956_a((String)"forge:honey");
        public static final ITag<Fluid> EXPERIENCE = FluidTags.func_206956_a((String)"forge:experience");
        public static final ITag<Fluid> SLIME = FluidTags.func_206956_a((String)RID.fstring("slime"));
        public static final ITag<Fluid> SEEDOIL = FluidTags.func_206956_a((String)"forge:seedoil");
        public static final ITag<Fluid> INK = FluidTags.func_206956_a((String)"forge:ink");
        public static final ITag<Fluid> POTION = FluidTags.func_206956_a((String)"forge:potion");
        public static final ITag<Fluid> LIQUID_SLIME = FluidTags.func_206956_a((String)"forge:slime");
        public static final ITag<Fluid> SLURRY = FluidTags.func_206956_a((String)"forge:slurry");
    }

    public static final class IsLavaOrMagma {
        public static final Predicate<BlockXyz> check = xyz -> IsLavaOrMagma.block(xyz.state);

        public static final boolean block(BlockState state) {
            if (state != null) {
                return IsLavaLike.block(state) || state.func_177230_c() == Blocks.field_196814_hQ;
            }
            return false;
        }
    }

    public static final class IsLavaLike {
        public static final Predicate<BlockXyz> check = xyz -> IsLavaLike.block(xyz.state);
        static final int _okTempLo = Fluids.lava().getAttributes().getTemperature() - 20;

        public static final boolean block(BlockState instate) {
            if (instate != null) {
                Material material = instate.func_185904_a();
                if (material == SharedGlue.Material_lava) {
                    return IsAnyLiquid.block(instate);
                }
                if (Boolean.TRUE == IsWaterLike.material(material) || material == SharedGlue.Material_air) {
                    return false;
                }
                FluidState fluid = instate.func_204520_s();
                if (!fluid.func_206888_e() && !Fluids.isNone(fluid.func_206886_c())) {
                    FluidAttributes a = fluid.func_206886_c().getAttributes();
                    return !a.isGaseous() && a.getTemperature() >= _okTempLo;
                }
            }
            return false;
        }

        public static final boolean temperature(Fluid fluid) {
            return fluid != null && fluid != Fluids.water() && (fluid == Fluids.lava() || Fluids.isLava(fluid) || !fluid.getAttributes().isGaseous() && fluid.getAttributes().getTemperature() >= _okTempLo);
        }
    }

    @ParametersAreNonnullByDefault
    public static class IsLikeLiquid
    implements Predicate<BlockXyz> {
        private final Material[] _liquid_materials;
        public static final IsLikeLiquid simplewater = new IsLikeLiquid(SharedGlue.Material_water, Materials.potable_water);
        public static final IsLikeLiquid pinklywater = new IsLikeLiquid(Materials.pinkly_water);
        public static final IsLikeLiquid growthwater = new IsLikeLiquid(SharedGlue.Material_water, Materials.potable_water, Materials.fertilizer_water, Materials.pinkly_water);
        public static final IsLikeLiquid fertilizer = new IsLikeLiquid(Materials.fertilizer_water, Materials.pinkly_water);
        public static final IsLikeLiquid sticky_goo = new IsLikeLiquid(Materials.liquid_slime, Materials.sticky_goo);

        public IsLikeLiquid(Material ... material) {
            this._liquid_materials = material;
        }

        public boolean apply(BlockXyz xyz) {
            return this.apply(xyz.state);
        }

        public final boolean apply(BlockState instate) {
            Material material = null;
            if (instate != null) {
                Block block = instate.func_177230_c();
                Material instate_material = instate.func_185904_a();
                if (block instanceof FlowingFluidBlock) {
                    material = instate_material;
                } else if (block instanceof IFluidBlock) {
                    Fluid fluid;
                    material = instate_material;
                    if (!material.func_76224_d() && IsWater.fluid(fluid = ((IFluidBlock)block).getFluid())) {
                        material = SharedGlue.Material_water;
                    }
                } else if (instate_material.func_76224_d()) {
                    material = instate_material;
                } else if (IsWater.like(instate)) {
                    material = SharedGlue.Material_water;
                }
            }
            return this.matches(material);
        }

        public final boolean matches(@Nullable Material material) {
            if (material != null) {
                for (Material valid : this._liquid_materials) {
                    if (material != valid) continue;
                    return true;
                }
            }
            return false;
        }
    }

    @ParametersAreNonnullByDefault
    public static final class IsWaterLike {
        public static final Predicate<BlockXyz> check = xyz -> IsWaterLike.block(xyz.state);
        public static final Predicate<BlockXyz> present_check = xyz -> IsWaterLike.present(xyz);
        static final int _okTempLo;
        static final int _okTempHi;
        static final int _maxVisco;

        public static final boolean fluid(@Nullable Fluid fluid) {
            boolean ok = false;
            if (IsWater.fluid(fluid)) {
                ok = true;
            } else if (!Fluids.isNone(fluid)) {
                FluidAttributes a = fluid.getAttributes();
                int temp = a.getTemperature();
                ok = !a.isGaseous() && temp >= _okTempLo && temp <= _okTempHi && a.getViscosity() < _maxVisco;
            }
            return ok;
        }

        public static final boolean fluid(@Nullable FluidState fluid) {
            return fluid != null && !fluid.func_206888_e() && IsWaterLike.fluid(fluid.func_206886_c());
        }

        @Nullable
        public static final Boolean material(Material material) {
            if (IsLikeLiquid.growthwater.matches(material)) {
                return true;
            }
            if (material == SharedGlue.Material_lava || material == SharedGlue.Material_air || material == SharedGlue.Material_bubbles) {
                return false;
            }
            return null;
        }

        public static final boolean block(BlockState state) {
            Boolean material = IsWaterLike.material(state.func_185904_a());
            return material != null ? material : IsWaterLike.fluid(state.func_204520_s());
        }

        public static final boolean present(BlockXyz xyz) {
            return IsWaterLike.block(xyz.state) ? true : IsWaterLike.fluid(xyz.worldr.func_204610_c(xyz.pos));
        }

        static {
            FluidAttributes water = Fluids.water().getFluid().getAttributes();
            _okTempLo = water.getTemperature() - 20;
            _okTempHi = water.getTemperature() + 20;
            _maxVisco = water.getViscosity() * 4;
        }
    }

    @ParametersAreNonnullByDefault
    public static final class IsAnyLiquidOrAnyIce {
        public static final Predicate<BlockXyz> check = xyz -> IsAnyLiquid.block(xyz.state);
        public static final Predicate<BlockXyz> present_check = xyz -> IsAnyLiquidOrAnyIce.present(xyz);

        public static final boolean block(BlockState state) {
            return IsAnyLiquid.block(state) || IsAnyLiquidOrAnyIce.ice_like(state);
        }

        public static final boolean present(BlockXyz xyz) {
            return IsAnyLiquid.present(xyz) || IsAnyLiquidOrAnyIce.ice_like(xyz.state);
        }

        public static final boolean ice_like(BlockState state) {
            boolean is;
            Block block = state.func_177230_c();
            boolean bl = is = block == Blocks.field_150432_aD || block == Blocks.field_185778_de || block == Blocks.field_150403_cj || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC || block == Blocks.field_205164_gk;
            if (!is) {
                is = block.func_203417_a(RID.Tags.ICE_LIKE) || block instanceof IceBlock;
            }
            return is;
        }
    }

    @ParametersAreNonnullByDefault
    public static final class IsAnyLiquid {
        public static final Predicate<BlockXyz> check = xyz -> IsAnyLiquid.block(xyz.state);
        public static final Predicate<BlockXyz> present_check = xyz -> IsAnyLiquid.present(xyz);

        public static final boolean block(BlockState state) {
            FluidState fluid;
            boolean is = false;
            Material material = state.func_185904_a();
            is = material.func_76224_d();
            if (!(is || state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() || (fluid = state.func_204520_s()).func_206888_e() || Fluids.isNone(fluid.func_206886_c()) || fluid.func_206886_c().getAttributes().isGaseous())) {
                is = true;
            }
            return is;
        }

        public static final boolean present(BlockXyz xyz) {
            FluidState fluid;
            boolean is = false;
            Material material = xyz.state.func_185904_a();
            is = material.func_76224_d();
            if (!(is || (fluid = xyz.worldr.func_204610_c(xyz.pos)).func_206888_e() || Fluids.isNone(fluid.func_206886_c()) || fluid.func_206886_c().getAttributes().isGaseous((IBlockDisplayReader)xyz.worldr, xyz.pos))) {
                is = true;
            }
            return is;
        }
    }

    @ParametersAreNonnullByDefault
    public static final class IsLava {
        public static final Predicate<BlockXyz> strict_check = xyz -> IsLava.block(xyz.state);
        public static final Predicate<BlockXyz> strict_check_submerged = xyz -> IsLava.source_block(xyz.state);
        public static final Predicate<BlockXyz> like_check = xyz -> IsLava.like(xyz.state);
        public static final Predicate<BlockXyz> present_check = xyz -> IsLava.present(xyz);

        public static final boolean fluid(@Nullable Fluid fluid) {
            return fluid == net.minecraft.fluid.Fluids.field_204547_b.getFluid() || fluid == net.minecraft.fluid.Fluids.field_207213_d.getFluid();
        }

        public static final boolean block(BlockState state) {
            return state.func_177230_c() == Blocks.field_150353_l;
        }

        public static final boolean source_block(BlockState state) {
            return state.func_177230_c() == Blocks.field_150353_l && state.func_204520_s().func_206889_d();
        }

        public static final boolean like(BlockState state) {
            FluidState f = state.func_204520_s();
            return !f.func_206888_e() && Fluids.isLava(f.func_206886_c());
        }

        public static final boolean present(BlockXyz xyz) {
            return xyz.worldr != null && Fluids.isLava(xyz.worldr.func_204610_c(xyz.pos).func_206886_c());
        }
    }

    @ParametersAreNonnullByDefault
    public static final class IsWater {
        public static final Predicate<BlockXyz> strict_check = xyz -> IsWater.block(xyz.state);
        public static final Predicate<BlockXyz> strict_check_submerged = xyz -> IsWater.source_block(xyz.state);
        public static final Predicate<BlockXyz> like_check = xyz -> IsWater.like(xyz.state);
        public static final Predicate<BlockXyz> present_check = xyz -> IsWater.present(xyz);

        public static final boolean fluid(@Nullable Fluid fluid) {
            return fluid == net.minecraft.fluid.Fluids.field_204546_a.getFluid() || fluid == net.minecraft.fluid.Fluids.field_207212_b.getFluid();
        }

        public static final boolean block(BlockState state) {
            return state.func_177230_c() == Blocks.field_150355_j;
        }

        public static final boolean source_block(BlockState state) {
            return state.func_177230_c() == Blocks.field_150355_j && state.func_204520_s().func_206889_d();
        }

        public static final boolean like(BlockState state) {
            FluidState f = state.func_204520_s();
            return !f.func_206888_e() && Fluids.isWater(f.func_206886_c());
        }

        public static final boolean present(BlockXyz xyz) {
            return xyz.worldr != null && Fluids.isWater(xyz.worldr.func_204610_c(xyz.pos).func_206886_c());
        }
    }
}

