/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Association;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public final class Instructions {
    @Nonnull
    public static final CompoundNBT createshell(@Nonnull CompoundNBT inside) {
        if (inside.func_150297_b("carrots:root", 10)) {
            return inside.func_74775_l("carrots:root");
        }
        CompoundNBT instr = new CompoundNBT();
        inside.func_218657_a("carrots:root", (INBT)instr);
        return instr;
    }

    @Nonnull
    public static final CompoundNBT createshell(@Nonnull ItemStack stack) {
        return ItemStacks.getOrCreateData(stack, "carrots:root");
    }

    @Nonnull
    public static final CompoundNBT createshell(@Nonnull ItemStack stack, @Nonnull String modid) {
        CompoundNBT nbt_instr = ItemStacks.getOrCreateData(stack, "carrots:root");
        if (!modid.isEmpty()) {
            nbt_instr.func_74778_a("ModId", modid);
        }
        return nbt_instr;
    }

    @Nonnull
    public static final CompoundNBT create(@Nonnull ItemStack stack, int currentVersion) {
        Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
        CompoundNBT nbt_instr = ItemStacks.getOrCreateData(stack, "carrots:root");
        nbt_instr.func_74774_a("Version", (byte)currentVersion);
        return nbt_instr;
    }

    @Nonnull
    public static final CompoundNBT create(@Nonnull ItemStack stack, int currentVersion, @Nonnull String modid) {
        assert (modid != null);
        CompoundNBT nbt_instr = Instructions.create(stack, currentVersion);
        if (!modid.isEmpty()) {
            nbt_instr.func_74778_a("ModId", modid);
        }
        return nbt_instr;
    }

    public static final boolean present(@Nullable ItemStack stack) {
        return !ItemStacks.isEmpty(stack) ? stack.func_179543_a("carrots:root") != null : false;
    }

    public static final Optional<CompoundNBT> find(@Nullable ItemStack stack) {
        return Optional.ofNullable(Instructions.get(stack));
    }

    @Nullable
    public static final CompoundNBT get(@Nullable ItemStack stack) {
        CompoundNBT nbt_instr = null;
        if (!ItemStacks.isEmpty(stack)) {
            nbt_instr = stack.func_179543_a("carrots:root");
        }
        return nbt_instr;
    }

    public static final Optional<CompoundNBT> find(@Nullable ItemStack stack, int requiredVersion, boolean olderOk) {
        return Optional.ofNullable(Instructions.get(stack, requiredVersion, olderOk));
    }

    @Nullable
    public static final CompoundNBT get(@Nullable ItemStack stack, int requiredVersion, boolean olderOk) {
        Validate.isTrue((requiredVersion > 0 && requiredVersion < 128 ? 1 : 0) != 0, (String)"Invalid version (not allowed to be lte 0", (Object[])new Object[0]);
        CompoundNBT nbt_instr = null;
        CompoundNBT tst_instr = Instructions.get(stack);
        if (tst_instr != null) {
            if (tst_instr.func_150297_b("Version", 1)) {
                byte v = tst_instr.func_74771_c("Version");
                if (v != 0 && (requiredVersion == v || olderOk && v < requiredVersion)) {
                    nbt_instr = tst_instr;
                }
            } else if (olderOk && 0 <= requiredVersion) {
                nbt_instr = tst_instr;
            }
        }
        return nbt_instr;
    }

    public static final boolean present(@Nullable ItemStack stack, int requiredVersion, boolean olderOk) {
        return Instructions.get(stack, requiredVersion, olderOk) != null;
    }

    @Nullable
    public static final CompoundNBT getraw(@Nullable ItemStack stack) {
        CompoundNBT nbt_instr = null;
        if (stack != null && stack != ItemStack.field_190927_a) {
            nbt_instr = stack.func_179543_a("carrots:root");
        }
        return nbt_instr;
    }

    @Nullable
    public static final CompoundNBT getraw(@Nullable CompoundNBT inside) {
        CompoundNBT nbt_instr = null;
        if (inside != null && inside.func_150297_b("carrots:root", 10)) {
            nbt_instr = inside.func_74775_l("carrots:root");
        }
        return nbt_instr;
    }

    public static final void remove(@Nonnull ItemStack stack) {
        stack.func_196083_e("carrots:root");
    }

    public static final void remove(@Nonnull CompoundNBT inside, String child, boolean normalize) {
        CompoundNBT nbt_instr = Instructions.getraw(inside);
        if (nbt_instr != null) {
            nbt_instr.func_82580_o(child);
            if (normalize && nbt_instr.isEmpty()) {
                inside.func_82580_o("carrots:root");
            }
        }
    }

    public static final boolean has(@Nonnull ItemStack stack, String key, int type) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(key, type);
    }

    public static final boolean has(@Nonnull ItemStack stack, String key) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b(key);
    }

    public static final boolean copyinit(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        boolean changed = false;
        CompoundNBT nbt_instr = Instructions.get(from);
        to.func_196083_e("carrots:root");
        if (nbt_instr != null) {
            CompoundNBT cpy_instr = nbt_instr.func_74737_b();
            to.func_77983_a("carrots:root", (INBT)cpy_instr);
            changed = true;
        }
        return changed;
    }

    public static final boolean copyinit(@Nonnull ItemStack from, @Nonnull ItemStack to, int currentVersion) {
        boolean changed = Instructions.copyinit(from, to);
        if (changed) {
            Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
            Instructions.get(to).func_74774_a("Version", (byte)currentVersion);
        } else {
            Instructions.create(to, currentVersion);
            changed = true;
        }
        return changed;
    }

    public static final boolean setVersion(@Nonnull ItemStack to, int currentVersion) {
        Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
        CompoundNBT nbt_instr = Instructions.getraw(to);
        if (nbt_instr != null) {
            nbt_instr.func_74774_a("Version", (byte)currentVersion);
        }
        return nbt_instr != null;
    }

    public static final boolean isCustomFor(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        CompoundNBT instr = Instructions.get(stack);
        return instr != null && modid.equals(instr.func_74779_i("ModId"));
    }

    public static final boolean isXEnchanted(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && modid.equals(nbt_instr.func_74779_i("ModId")) && nbt_instr.func_74762_e("PrizeEnchant") > 0;
    }

    public static final boolean isFlagged(@Nullable ItemStack stack, String nbt_flag, @Nullable String modid) {
        boolean is = false;
        CompoundNBT nbt_instr = Instructions.get(stack);
        if (nbt_instr != null && (modid == null || modid.equals(nbt_instr.func_74779_i("ModId")))) {
            is = nbt_instr.func_74767_n(nbt_flag);
        }
        return is;
    }

    public static final boolean isLooted(@Nullable ItemStack stack, @Nullable String modid) {
        return Instructions.isFlagged(stack, "Looted", modid);
    }

    public static final boolean isLooted(@Nullable ItemStack stack) {
        return Instructions.isLooted(stack, null);
    }

    public static final boolean isCrafted(@Nullable ItemStack stack) {
        return Instructions.isFlagged(stack, "Crafted", null);
    }

    public static final boolean setCrafted(@Nonnull ItemStack stack) {
        ResourceLocation rid = stack.func_77973_b().getRegistryName();
        if (rid == null || "minecraft".equals(rid.func_110624_b())) {
            return false;
        }
        Instructions.createshell(stack, rid.func_110624_b()).func_74757_a("Crafted", true);
        return true;
    }

    public static final boolean isUnvanishing(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        return Instructions.isXEnchanted(stack, modid) && Instructions.isFlagged(stack, "Unvanishing", modid);
    }

    public static final boolean hasXGearFlag(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        return Instructions.isXEnchanted(stack, modid) && Instructions.isFlagged(stack, "XGear", modid);
    }

    public static final boolean hasXFoodFlag(@Nullable ItemStack stack) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b("XFood") && nbt_instr.func_74767_n("XFood");
    }

    public static final boolean hasLootTable(@Nullable ItemStack stack, boolean topLevel) {
        CompoundNBT nbt = Instructions.get(stack);
        if (nbt != null && nbt.func_150297_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME(), 8)) {
            return true;
        }
        return topLevel && Loot.hasTopLevelLootTable(stack);
    }

    public static final boolean hasUnrepairableFlag(@Nullable ItemStack stack) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b("Unrepairable") && nbt_instr.func_74767_n("Unrepairable");
    }

    public static final boolean hasSampleFlag(@Nullable ItemStack stack) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b("SAMPLE");
    }

    public static final long getLong(@Nullable ItemStack stack, @Nonnull String tagid, long valueIfAbsent) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 99) ? nbt_instr.func_74763_f(tagid) : valueIfAbsent;
    }

    public static final int getInteger(@Nullable ItemStack stack, @Nonnull String tagid, int valueIfAbsent) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 99) ? nbt_instr.func_74762_e(tagid) : valueIfAbsent;
    }

    static final CompoundNBT setInteger_(@Nonnull ItemStack stack, @Nonnull String tagid, int value) {
        CompoundNBT nbt_instr = Instructions.createshell(stack);
        nbt_instr.func_74768_a(tagid, value);
        return nbt_instr;
    }

    public static final int setInteger(@Nullable ItemStack stack, @Nonnull String tagid, int value, int nullValue) {
        int oldValue = Instructions.getInteger(stack, tagid, nullValue);
        Instructions.setInteger_(stack, tagid, value);
        return oldValue;
    }

    public static final void setInteger(@Nullable ItemStack stack, @Nonnull String tagid, int value) {
        Instructions.setInteger_(stack, tagid, value);
    }

    public static final int getIntegerRaw(@Nullable ItemStack stack, @Nonnull String tagid, int valueIfAbsent) {
        CompoundNBT nbt_instr = Instructions.getraw(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 99) ? nbt_instr.func_74762_e(tagid) : valueIfAbsent;
    }

    public static final void setLong(@Nullable ItemStack stack, @Nonnull String tagid, long value) {
        CompoundNBT nbt_instr = Instructions.createshell(stack);
        nbt_instr.func_74772_a(tagid, value);
    }

    public static final boolean getFlag(@Nullable ItemStack stack, @Nonnull String tagid, boolean valueIfAbsent) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 1) ? nbt_instr.func_74767_n(tagid) : valueIfAbsent;
    }

    public static final boolean getFlag(@Nullable ItemStack stack, @Nonnull String tagid) {
        return Instructions.getFlag(stack, tagid, false);
    }

    public static final boolean setFlag(@Nullable ItemStack stack, @Nonnull String tagid, Boolean value) {
        boolean oldValue = Instructions.getFlag(stack, tagid);
        CompoundNBT nbt_instr = Instructions.createshell(stack);
        if (value == null) {
            nbt_instr.func_82580_o(tagid);
        } else {
            nbt_instr.func_74757_a(tagid, Boolean.TRUE.equals(value));
        }
        return oldValue;
    }

    public static final void setFlag(@Nonnull CompoundNBT inside, @Nonnull String tagid, Boolean value) {
        CompoundNBT nbt_instr = Instructions.createshell(inside);
        if (value == null) {
            nbt_instr.func_82580_o(tagid);
        } else {
            nbt_instr.func_74757_a(tagid, Boolean.TRUE.equals(value));
        }
    }

    public static final String getString(@Nullable ItemStack stack, @Nonnull String tagid, String valueIfAbsent) {
        CompoundNBT nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 8) ? nbt_instr.func_74779_i(tagid) : valueIfAbsent;
    }

    public static final int getUsed(@Nullable ItemStack stack, int valueIfAbsent) {
        return Instructions.getInteger(stack, "Used", valueIfAbsent);
    }

    public static final int getCheckedUsed(@Nullable ItemStack stack, int valueIfAbsent, int maxValue) {
        int n = Instructions.getUsed(stack, valueIfAbsent);
        if (n < 0) {
            n = valueIfAbsent;
        }
        return Math.min(n, maxValue);
    }

    public static final void setUsed(@Nonnull ItemStack stack, int value, int capacityIfAbsent) {
        CompoundNBT nbt_instr = Instructions.setInteger_(stack, "Used", value);
        if (capacityIfAbsent > 0) {
            if (!nbt_instr.func_150297_b("Capacity", 99)) {
                Instructions.setCapacity(stack, capacityIfAbsent);
            }
            if (value > capacityIfAbsent) {
                Instructions.setInteger_(stack, "Used", capacityIfAbsent);
            }
        }
    }

    public static final int getCapacity(@Nullable ItemStack stack, int valueIfAbsent) {
        return Instructions.getInteger(stack, "Capacity", valueIfAbsent);
    }

    public static final int getCheckedCapacity(@Nullable ItemStack stack, int valueIfAbsent, int maxValue) {
        int n = Instructions.getCapacity(stack, valueIfAbsent);
        if (n < 0) {
            n = valueIfAbsent;
        }
        return Math.min(n, maxValue);
    }

    public static final void setCapacity(@Nonnull ItemStack stack, int capacity) {
        Instructions.setInteger_(stack, "Capacity", capacity);
    }

    public static final int getRemaining(@Nullable ItemStack stack, int capacityIfAbsent, int maxCapacity) {
        int n;
        int m;
        CompoundNBT nbt_instr = Instructions.get(stack);
        if (nbt_instr == null) {
            return capacityIfAbsent;
        }
        int n2 = m = nbt_instr.func_150297_b("Capacity", 99) ? nbt_instr.func_74762_e("Capacity") : capacityIfAbsent;
        if (m < 0) {
            m = capacityIfAbsent;
        }
        int n3 = n = nbt_instr.func_150297_b("Used", 99) ? nbt_instr.func_74762_e("Used") : 0;
        if (n < 0) {
            n = 0;
        }
        return MathHelper.func_76125_a((int)(m - n), (int)0, (int)maxCapacity);
    }

    public static final int getColorRgb(@Nonnull ItemStack stack, int valueIfAbsent) {
        if (ItemStacks.hasData(stack, SharedGlue.CUSTOM_COLOR_TAGNAME(), 3)) {
            return stack.func_77978_p().func_74762_e(SharedGlue.CUSTOM_COLOR_TAGNAME());
        }
        CompoundNBT nbt_instr = Instructions.get(stack);
        if (nbt_instr != null && nbt_instr.func_150297_b("ColorRGB", 3)) {
            return nbt_instr.func_74762_e("ColorRGB");
        }
        return valueIfAbsent;
    }

    public static final void setColorRgb(@Nonnull ItemStack stack, int color) {
        CompoundNBT nbt_instr = Instructions.createshell(stack);
        nbt_instr.func_74768_a(SharedGlue.CUSTOM_COLOR_TAGNAME(), color);
    }

    public static final int renameLikeAnvil(@Nonnull ItemStack target, String newname) {
        int cost = 0;
        if (StringUtils.isBlank((CharSequence)newname)) {
            if (target.func_82837_s()) {
                target.func_135074_t();
                ++cost;
            }
        } else if (!newname.equals(target.func_200301_q().func_150261_e())) {
            target.func_200302_a((ITextComponent)new StringTextComponent(newname));
            ++cost;
        }
        return cost;
    }

    public static final int namedOnAvil(@Nonnull ItemStack creation, @Nonnull ItemStack original, String newname) {
        String oldname;
        int cost = 0;
        if (!StringUtils.isBlank((CharSequence)newname) && !newname.equals(oldname = original.func_200301_q().func_150261_e())) {
            creation.func_200302_a((ITextComponent)new StringTextComponent(newname));
            ++cost;
        }
        return cost;
    }

    public static final boolean setAssociation(ItemStack stack, PlayerEntity player, boolean forced, Association.NBTKey key) {
        if (ItemStacks.isEmpty(stack) || Association.NBTKey.isEmpty(key) || !SharedGlue.isaRealPlayer((Entity)player)) {
            return false;
        }
        boolean setted = false;
        String uuid = player.func_189512_bd();
        if (!StringUtils.isBlank((CharSequence)uuid)) {
            String uuid_present;
            CompoundNBT instr = Instructions.createshell(stack);
            if (!forced && instr.func_150297_b(key.ID, 8) && !(uuid_present = instr.func_74779_i(key.ID)).isEmpty() && !uuid.equals(uuid_present)) {
                return false;
            }
            instr.func_74778_a(key.ID, uuid);
            instr.func_74778_a(key.NAME, Strings.serialize(player.func_200200_C_()));
            setted = true;
        }
        return setted;
    }

    public static final boolean setOwner(ItemStack stack, PlayerEntity player, boolean forced) {
        return Instructions.setAssociation(stack, player, forced, Association.NBTKey.OWNER);
    }

    public static final boolean setCreator(ItemStack stack, PlayerEntity player) {
        return Instructions.setAssociation(stack, player, false, Association.NBTKey.CREATOR);
    }

    public static final boolean setAssociation(ItemStack stack, String uuid, Association.NBTKey key) {
        if (ItemStacks.isEmpty(stack) || Association.NBTKey.isEmpty(key)) {
            return false;
        }
        CompoundNBT instr = Instructions.createshell(stack);
        instr.func_74778_a(key.ID, uuid);
        instr.func_82580_o(key.NAME);
        return true;
    }

    public static final boolean setOwner(ItemStack stack, String uuid) {
        return Instructions.setAssociation(stack, uuid, Association.NBTKey.OWNER);
    }

    public static final boolean setCreator(ItemStack stack, String uuid) {
        return Instructions.setAssociation(stack, uuid, Association.NBTKey.CREATOR);
    }

    public static final boolean setAssociation(@Nullable CompoundNBT into, @Nullable Association affiliate, Association.NBTKey key) {
        if (into == null || affiliate == null || Association.NBTKey.isEmpty(key) || StringUtils.isBlank((CharSequence)affiliate.id)) {
            return false;
        }
        into.func_74778_a(key.ID, affiliate.id);
        if (affiliate.name == null) {
            into.func_82580_o(key.NAME);
        } else {
            into.func_74778_a(key.NAME, Strings.serialize(affiliate.name));
        }
        return true;
    }

    public static final boolean setAssociation(ItemStack stack, @Nonnull Association affiliate, Association.NBTKey key) {
        if (ItemStacks.isEmpty(stack)) {
            return false;
        }
        return Instructions.setAssociation(Instructions.createshell(stack), affiliate, key);
    }

    public static final boolean setOwner(ItemStack stack, @Nonnull Association owner) {
        return Instructions.setAssociation(stack, owner, Association.NBTKey.OWNER);
    }

    public static final boolean setOwner(CompoundNBT into, @Nonnull Association owner) {
        return Instructions.setAssociation(into, owner, Association.NBTKey.OWNER);
    }

    @Nullable
    public static final CompoundNBT saveOwner(@Nullable Association owner) {
        CompoundNBT nbt;
        CompoundNBT compoundNBT = nbt = owner == null ? null : new CompoundNBT();
        if (nbt != null && !Instructions.setAssociation(nbt, owner, Association.NBTKey.OWNER)) {
            nbt = null;
        }
        return nbt;
    }

    public static final boolean setCreator(ItemStack stack, @Nonnull Association creator) {
        return Instructions.setAssociation(stack, creator, Association.NBTKey.CREATOR);
    }

    @Nullable
    public static String getOwner(ItemStack stack) {
        Association owner = Instructions.getOwnerDef(stack);
        return owner != null ? owner.id : null;
    }

    @Nullable
    public static String getCreator(ItemStack stack) {
        Association creator = Instructions.getCreatorDef(stack);
        return creator != null ? creator.id : null;
    }

    @Nullable
    public static Association getAssociation(CompoundNBT from, Association.NBTKey key) {
        String id_;
        Association affiliate = null;
        if (from != null && !Association.NBTKey.isEmpty(key) && (id_ = StringUtils.trimToNull((String)from.func_74779_i(key.ID))) != null) {
            affiliate = new Association();
            affiliate.id = id_;
            if (from.func_150297_b(key.NAME, 8)) {
                affiliate.name = Strings.deserialize(from.func_74779_i(key.NAME));
            }
        }
        return affiliate;
    }

    @Nullable
    public static Association getAssociation(ItemStack stack, Association.NBTKey key) {
        Association affiliate = null;
        if (!ItemStacks.isEmpty(stack)) {
            affiliate = Instructions.getAssociation(Instructions.get(stack), key);
        }
        return affiliate;
    }

    @Nullable
    public static Association getOwnerDef(ItemStack stack) {
        return Instructions.getAssociation(stack, Association.NBTKey.OWNER);
    }

    @Nullable
    public static Association getOwnerDef(CompoundNBT data) {
        return Instructions.getAssociation(data, Association.NBTKey.OWNER);
    }

    @Nullable
    public static Association getCreatorDef(ItemStack stack) {
        return Instructions.getAssociation(stack, Association.NBTKey.CREATOR);
    }

    public static boolean copyOwner(ItemStack from, ItemStack to) {
        Association current = Instructions.getOwnerDef(from);
        return current != null && Instructions.setOwner(to, current);
    }

    public static boolean copyCreator(ItemStack from, ItemStack to) {
        Association current = Instructions.getCreatorDef(from);
        return current != null && Instructions.setCreator(to, current);
    }

    public static final boolean isAssociation(ItemStack stack, Entity candidate, @Nonnull String inside, boolean emptyIsMatch, Association.NBTKey key) {
        String uuid;
        boolean is;
        if (candidate == null || Association.NBTKey.isEmpty(key)) {
            return false;
        }
        CompoundNBT instr = ItemStacks.hasMap(stack, inside) ? ItemStacks.getMap(stack, inside) : null;
        boolean bl = is = instr != null;
        is = is ? ((uuid = instr.func_74779_i(key.ID)).isEmpty() ? emptyIsMatch : uuid.equals(candidate.func_189512_bd())) : emptyIsMatch;
        return is;
    }

    public static final boolean isOwner(ItemStack stack, Entity candidate, @Nonnull String inside, boolean emptyIsMatch) {
        return Instructions.isAssociation(stack, candidate, inside, emptyIsMatch, Association.NBTKey.OWNER);
    }

    public static final boolean isOwner(ItemStack stack, Entity candidate, boolean emptyIsMatch) {
        return Instructions.isAssociation(stack, candidate, "carrots:root", emptyIsMatch, Association.NBTKey.OWNER);
    }

    public static final boolean isOwnerOrUnowned(ItemStack stack, Entity candidate) {
        return Instructions.isOwner(stack, candidate, true);
    }

    public static final boolean isCreator(ItemStack stack, Entity candidate) {
        return Instructions.isAssociation(stack, candidate, "carrots:root", false, Association.NBTKey.CREATOR);
    }

    public static final void clearAssociation(ItemStack stack, Association.NBTKey key) {
        CompoundNBT instr;
        if (!ItemStacks.isEmpty(stack) && !Association.NBTKey.isEmpty(key) && (instr = Instructions.get(stack)) != null) {
            instr.func_82580_o(key.ID);
            instr.func_82580_o(key.NAME);
        }
    }

    public static final void clearOwner(ItemStack stack) {
        Instructions.clearAssociation(stack, Association.NBTKey.OWNER);
    }

    public static final void clearCreator(ItemStack stack) {
        Instructions.clearAssociation(stack, Association.NBTKey.CREATOR);
    }

    public static final boolean hasAssociation(ItemStack stack, Association.NBTKey key) {
        CompoundNBT instr = Instructions.get(stack);
        return instr != null ? !instr.func_74779_i(key.ID).isEmpty() : false;
    }

    public static final boolean hasOwner(ItemStack stack) {
        return Instructions.hasAssociation(stack, Association.NBTKey.OWNER);
    }

    public static final boolean hasCreator(ItemStack stack) {
        return Instructions.hasAssociation(stack, Association.NBTKey.CREATOR);
    }
}

