/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.CarrotsLib;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibFMLMessage;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.mod.FlexibleBoolean;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;
import org.jwaresoftware.mcmods.lib.impl.Count;
import org.jwaresoftware.mcmods.lib.impl.ModConfigBase;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalFluids;
import org.jwaresoftware.mcmods.lib.integration.BaublesHelper;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public final class LibConfig
extends ModConfigBase
implements IModConfig {
    static final int _CONFIG_VERSION = 1;
    static final String _GENERAL = "general";
    static final String _INTEGRATION = "integration";
    static final String _ALMANAC = "almanac";
    private static LibConfig _sharedINSTANCE;
    private boolean _fullyStarted = false;
    private boolean _tagsLoaded = false;
    public static final ITag.INamedTag<Enchantment> OMITTED_FROM_RANDOM_ENCHANTS;
    private final List<Enchantment> _OMITTED_FROM_RANDOM_ENCHANTS = new ArrayList<Enchantment>();
    private final List<Potion> _OMITTED_FROM_RANDOM_POTIONS = new ArrayList<Potion>();
    private boolean _UPDATE_ADVANCEMENT_TRIGGERS;
    private boolean _UPDATE_SCORE_BASED_TRIGGERS;
    private int _UPDATE_TRIGGERS_FREQUENCY_TICKS = -1;
    private boolean _ENABLE_UNCURABLE_EFFECTS = false;
    private final HashMap<String, List<String>> _PROPERTY_SYNONYMS = new HashMap(23);
    private List<String> _AGE_PROPERTY_SYNONYMS = (List)Util.func_200696_a(new ArrayList(5), a -> {
        a.add(BlockStateProperties.field_222512_Y.func_177701_a());
        a.add(BlockStateProperties.field_208137_al.func_177701_a());
        a.add("growstate");
        a.add("growth");
    });
    private List<String> _WET_PROPERTY_SYNONYMS = (List)Util.func_200696_a(new ArrayList(5), w -> {
        w.add(BlockStateProperties.field_208133_ah.func_177701_a());
        w.add("wet");
        w.add("wetness");
    });
    private int _SPECIAL_DROPS_LIFESPAN_TICKS = SharedGlue.ticksFromSeconds(450);
    private int _FARMED_DROPS_LIFESPAN_TICKS = SharedGlue.ticksFromSeconds(120);
    private boolean _INCLUDE_ALMANAC_TRACKING = LibConfig.__devEnvironment();
    private boolean _INCLUDE_NUTRITION_NOTES = false;
    private boolean _INCLUDE_ATTRIBUTE_EVENT_HANDLER = true;
    private boolean _DISABLE_FIGHTING_FOOD_EFFECTS = false;
    private final ArrayList<ItemStack> _MILK_BUCKETS = new ArrayList();
    private static final boolean __IDE_ENVIRONMENT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> DEBUG_MODE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ENABLE_FORGE_MILK;
    public static final int DEFAULT_SUBSEASON_WEEKS = 4;
    public static final int DEFAULT_SUBSEASON_DAYS = 28;
    public static final int DEFAULT_SUBSEASON_COUNT = 3;
    public static final int DEFAULT_SEASON_DAYS = 84;
    public static final int UNKNOWN_SEASON_DAYS = -1;
    public static final int DEFAULT_SEASON_COUNT = 4;
    public static final int DEFAULT_ALMANAC_DAYS = 336;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> TICKS_PER_FULLDAY;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> TICKS_IN_DAYTIME;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> TICKS_IN_DUSK;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> TICKS_IN_DAWN;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> DAY1_TICKS_OFFSET;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> SUBSEASONS_PER_SEASON;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> WEEKS_PER_SUBSEASON;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> SEASONS_PER_ALMANAC_YEAR;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> FALLBACK_ALMANAC_IMPL;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> PREFERRED_BAUBLES_IMPL;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> PREFERRED_SURVIVAL_IMPL;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> PREFERRED_ENVIRON_IMPL;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> NEUTRAL_POTIONS_BAD;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SHARED_POTIONS_SHOWN;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXTRA_SURVIVAL_MECHANICS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> FAIRPLAY_PVP;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> FIGHTING_FOODS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> FOOD_TO_FUEL;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.ConfigValue<Integer>> SHARED_EFFECTS_MAX_DISTANCE;
    static final ModConfigBase.Option<List<? extends String>, ForgeConfigSpec.ConfigValue<List<? extends String>>> ALMANAC_TRACKED;

    @Nonnull
    static LibConfig setInstance() {
        assert (_sharedINSTANCE == null) : "lib config uninitialized";
        _sharedINSTANCE = new LibConfig();
        return _sharedINSTANCE;
    }

    @Nonnull
    public static final LibConfig getInstance() {
        return Objects.requireNonNull(_sharedINSTANCE);
    }

    private LibConfig() {
        super(LibInfo.getInstance());
        this.initMilkBuckets();
    }

    @Override
    public final int currentVersion() {
        return 1;
    }

    @Override
    public boolean useForgeTracking() {
        return true;
    }

    final void setFullyStarted() {
        this._fullyStarted = true;
    }

    @Override
    public boolean isFullyStarted() {
        return this._fullyStarted;
    }

    final void setTagsLoaded(boolean are) {
        this._tagsLoaded = are;
    }

    @Override
    public boolean tagsLoaded() {
        return this._tagsLoaded;
    }

    public static final boolean tagsUnsafe() {
        return !LibConfig._sharedINSTANCE._tagsLoaded;
    }

    public void initFinalize() {
        ArrayList<Potion> omitted_potions = new ArrayList<Potion>();
        ArrayList<Enchantment> omitted_enchants = new ArrayList<Enchantment>();
        Count autotickDelaySeconds = new Count(60);
        ArrayList<String> age_names = new ArrayList<String>();
        ArrayList<String> wet_names = new ArrayList<String>();
        this.copyinitMilkBuckets();
        InterModComms.getMessages((String)"carrots").forEach(msg -> {
            LibFMLMessage msgid = LibFMLMessage.findOrNone(msg.getMethod());
            switch (msgid) {
                case ADD_MILK_BUCKET: {
                    ItemStack bucket = ItemStack.field_190927_a;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof Item) {
                        bucket = ItemStacks.create((Item)unsafe);
                    } else if (unsafe instanceof ItemStack) {
                        bucket = ItemStacks.copy((ItemStack)unsafe, 1);
                    } else if (unsafe instanceof ItemStackDef) {
                        bucket = ((ItemStackDef)unsafe).get();
                    }
                    if (ItemStacks.isEmpty(bucket)) break;
                    this._MILK_BUCKETS.add(bucket);
                    break;
                }
                case ENABLE_UNCURABLE_EFFECTS: {
                    this._ENABLE_UNCURABLE_EFFECTS = true;
                    break;
                }
                case DISABLE_FIGHTING_FOODS: {
                    this._DISABLE_FIGHTING_FOOD_EFFECTS = true;
                    break;
                }
                case TICK_SCORE_ADVANCEMENTS: {
                    int i;
                    this._UPDATE_SCORE_BASED_TRIGGERS = true;
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (!(unsafe instanceof Number) || (i = ((Number)unsafe).intValue()) <= 1 || i >= autotickDelaySeconds.value()) break;
                    autotickDelaySeconds.setValue(i);
                    break;
                }
                case TICK_ADVANCEMENTS: {
                    this._UPDATE_ADVANCEMENT_TRIGGERS = true;
                    break;
                }
                case BROADCAST_ALMANAC_ROLLOVERS: {
                    this._INCLUDE_ALMANAC_TRACKING = true;
                    break;
                }
                case OMIT_FROM_RANDOM_POTIONS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Potion) {
                        rid = ((Potion)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Potion p = null;
                        if (ForgeRegistries.POTION_TYPES.containsKey(rid)) {
                            p = (Potion)ForgeRegistries.POTION_TYPES.getValue(rid);
                        }
                        if (!Potions.isEmpty(p)) {
                            omitted_potions.add(p);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.getLog().warn("Unable to process omit potion FML request from '{}' for '{}'. Unrecognized potion identifier. Understands strings, resource locations, and object references for REGISTERED potions only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
                case OMIT_FROM_RANDOM_ENCHANTS: {
                    boolean yup = false;
                    ResourceLocation rid = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        rid = ResourceLocation.func_208304_a((String)unsafe.toString());
                    } else if (unsafe instanceof ResourceLocation) {
                        rid = (ResourceLocation)unsafe;
                    } else if (unsafe instanceof Enchantment) {
                        rid = ((Enchantment)unsafe).getRegistryName();
                    }
                    if (rid != null) {
                        Enchantment e = null;
                        if (ForgeRegistries.ENCHANTMENTS.containsKey(rid)) {
                            e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rid);
                        }
                        if (e != null) {
                            omitted_enchants.add(e);
                            yup = true;
                        }
                    }
                    if (yup) break;
                    CarrotsLib.getLog().warn("Unable to process omit enchantment FML request from '{}' for '{}'. Unrecognized enchantment identifier. Understands strings, resource locations, and object references for REGISTERED enchantments only.", (Object)msg.getSenderModId(), (Object)rid);
                    break;
                }
                case FARMED_DROPS_LIFESPAN_TICKS: 
                case SPECIAL_DROPS_LIFESPAN_TICKS: {
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof Number) {
                        int ticks = ((Number)unsafe).intValue();
                        if (ticks <= 0) break;
                        if (msgid == LibFMLMessage.SPECIAL_DROPS_LIFESPAN_TICKS && ticks > this._SPECIAL_DROPS_LIFESPAN_TICKS) {
                            this._SPECIAL_DROPS_LIFESPAN_TICKS = Math.min(ticks, SharedGlue.ticksFromSeconds(1800));
                            break;
                        }
                        if (msgid != LibFMLMessage.FARMED_DROPS_LIFESPAN_TICKS || ticks >= this._FARMED_DROPS_LIFESPAN_TICKS) break;
                        this._FARMED_DROPS_LIFESPAN_TICKS = ticks;
                        break;
                    }
                    CarrotsLib.getLog().warn("Unable to process dropped items lifespan FML request from '{}'. Value is not a number.", (Object)msg.getSenderModId());
                    break;
                }
                case ADD_MOISTURE_SYNONYM: 
                case ADD_AGE_SYNONYM: {
                    String name = null;
                    Object unsafe = msg.getMessageSupplier().get();
                    if (unsafe instanceof String) {
                        name = unsafe.toString();
                    } else if (unsafe instanceof IntegerProperty) {
                        name = ((IntegerProperty)unsafe).func_177701_a();
                    } else {
                        CarrotsLib.getLog().warn("Unable to process add property synonym FML request from '{}'. Understands strings and IntegerProperty.", (Object)msg.getSenderModId());
                    }
                    if (name == null) break;
                    if (msgid == LibFMLMessage.ADD_MOISTURE_SYNONYM) {
                        age_names.add(name);
                        break;
                    }
                    wet_names.add(name);
                    break;
                }
                case ENABLE_NUTRITION_NOTES: {
                    this._INCLUDE_NUTRITION_NOTES = true;
                    break;
                }
                case DISABLE_ATTRIBUTES_HANDLER: {
                    this._INCLUDE_ATTRIBUTE_EVENT_HANDLER = false;
                    break;
                }
            }
        });
        this.finalizePropertySynonyms(age_names, wet_names);
        this.finalizeBlockedEnchantments(omitted_enchants);
        this.finalizeBlockedPotions(omitted_potions);
        if (this._UPDATE_SCORE_BASED_TRIGGERS) {
            this._UPDATE_TRIGGERS_FREQUENCY_TICKS = SharedGlue.ticksFromSeconds(autotickDelaySeconds.intValue());
        }
    }

    private void finalizeBlockedEnchantments(Collection<Enchantment> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_ENCHANTS.clear();
            this._OMITTED_FROM_RANDOM_ENCHANTS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nonnull Enchantment e) {
        return LibConfig.getInstance()._OMITTED_FROM_RANDOM_ENCHANTS.contains(e) || e.isIn(OMITTED_FROM_RANDOM_ENCHANTS);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Enchantment e) {
        return e == null || e.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(e);
    }

    private void finalizeBlockedPotions(Collection<Potion> denylist) {
        if (!denylist.isEmpty()) {
            this._OMITTED_FROM_RANDOM_POTIONS.clear();
            this._OMITTED_FROM_RANDOM_POTIONS.addAll(denylist);
        }
    }

    public static final boolean omitFromRandomGeneration_s(@Nonnull Potion p) {
        return p == Potions.PLACEHOLDER || LibConfig.getInstance()._OMITTED_FROM_RANDOM_POTIONS.contains(p);
    }

    public static final boolean omitFromRandomGeneration(@Nullable Potion p) {
        return p == null || p.getRegistryName() == null || LibConfig.omitFromRandomGeneration_s(p);
    }

    public static final boolean installAdvancementAutoTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS || LibConfig.getInstance()._UPDATE_SCORE_BASED_TRIGGERS;
    }

    public static final boolean tickAdvancementTriggers() {
        return LibConfig.getInstance()._UPDATE_ADVANCEMENT_TRIGGERS;
    }

    public static final int tickScoreTriggersFrequency() {
        return LibConfig.getInstance()._UPDATE_TRIGGERS_FREQUENCY_TICKS;
    }

    public static final boolean allowUncurablePotionEffects() {
        return LibConfig.getInstance()._ENABLE_UNCURABLE_EFFECTS;
    }

    private void finalizePropertySynonyms(Collection<String> agelist, Collection<String> wetlist) {
        for (String age_p : agelist) {
            if (age_p.isEmpty()) continue;
            this._AGE_PROPERTY_SYNONYMS.add(age_p);
        }
        this._AGE_PROPERTY_SYNONYMS = Collections.unmodifiableList(this._AGE_PROPERTY_SYNONYMS);
        for (String id : this._AGE_PROPERTY_SYNONYMS) {
            this._PROPERTY_SYNONYMS.putIfAbsent(id, this._AGE_PROPERTY_SYNONYMS);
        }
        for (String wet_p : wetlist) {
            if (wet_p.isEmpty()) continue;
            this._WET_PROPERTY_SYNONYMS.add(wet_p);
        }
        this._WET_PROPERTY_SYNONYMS = Collections.unmodifiableList(this._WET_PROPERTY_SYNONYMS);
        for (String id : this._WET_PROPERTY_SYNONYMS) {
            this._PROPERTY_SYNONYMS.putIfAbsent(id, this._WET_PROPERTY_SYNONYMS);
        }
    }

    @Nonnull
    public static final List<String> propertySynonyms(@Nonnull String id) {
        return LibConfig.getInstance()._PROPERTY_SYNONYMS.getOrDefault(id, Collections.emptyList());
    }

    public static final List<String> agePropertyNames() {
        return LibConfig.getInstance()._AGE_PROPERTY_SYNONYMS;
    }

    public static final List<String> wetPropertyNames() {
        return LibConfig.getInstance()._WET_PROPERTY_SYNONYMS;
    }

    public static final int specialDropsLifespanTicks() {
        return LibConfig.getInstance()._SPECIAL_DROPS_LIFESPAN_TICKS;
    }

    public static final int farmedDropsLifespanTicks() {
        return LibConfig.getInstance()._FARMED_DROPS_LIFESPAN_TICKS;
    }

    public static final boolean includeAlmanacTracking() {
        return LibConfig.getInstance()._INCLUDE_ALMANAC_TRACKING;
    }

    public static final boolean includeNutritionNotes() {
        return LibConfig.getInstance()._INCLUDE_NUTRITION_NOTES;
    }

    public static final boolean includeAttributeSupportHandler() {
        return !ModIntegration.PINKLYSHEEP.isLoaded() && LibConfig.getInstance()._INCLUDE_ATTRIBUTE_EVENT_HANDLER;
    }

    private void initMilkBuckets() {
        this._MILK_BUCKETS.add(new ItemStack((IItemProvider)Items.field_151117_aB));
    }

    private void copyinitMilkBuckets() {
        this._MILK_BUCKETS.clear();
        this._MILK_BUCKETS.addAll(UniversalFluids.milkBuckets());
    }

    public static final List<ItemStack> getMilkBuckets() {
        return LibConfig.getInstance()._MILK_BUCKETS.stream().map(I -> ItemStacks.copy(I)).collect(Collectors.toList());
    }

    public static final boolean __devEnvironment() {
        return __IDE_ENVIRONMENT;
    }

    @Override
    public final boolean isDebugMode() {
        return DEBUG_MODE.value();
    }

    private void define_isDebugMode() {
        LibConfig.DEBUG_MODE.val = this._spec.comment("[INTERNAL] Set true to enable development checks and workflows. Do NOT enable in a regular environment. Applies only to library.").define(LibConfig.DEBUG_MODE.PROPERTY, DEBUG_MODE);
    }

    public static final boolean allowForgeMilkFluid() {
        return ENABLE_FORGE_MILK.value();
    }

    private void define_allowForgeMilk() {
        LibConfig.ENABLE_FORGE_MILK.val = this._spec.comment("Set false to prevent library from enabling Forge's builtin 'milk' fluid. Be warned that turning this off can impact builtin recipes.").define(LibConfig.ENABLE_FORGE_MILK.PROPERTY, ENABLE_FORGE_MILK);
    }

    static final String DTKey(@Nullable World w) {
        ResourceLocation rid = w == null ? World.field_234918_g_.func_240901_a_() : w.func_234923_W_().func_240901_a_();
        return String.valueOf(rid).replace(':', '_');
    }

    public static final boolean __locationImportantToSeasonCompute() {
        return false;
    }

    private void define_ticksPerFullDay() {
        LibConfig.TICKS_PER_FULLDAY.val = this._spec.comment("[INTERNAL] Set to the number of ticks associated with a FULL day-night cycle in game. Alter this value for testing only as setting it does NOT change the actual game clock.").define(LibConfig.TICKS_PER_FULLDAY.PROPERTY, (Object)((Integer)LibConfig.TICKS_PER_FULLDAY.DFLT));
    }

    public static final int __ticksPerFullDay() {
        int num = TICKS_PER_FULLDAY.value();
        return num <= 0 ? SharedGlue.DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE() : num;
    }

    public static final int __ticksPerFullDay(@Nonnull RegistryKey<World> w) {
        return LibConfig.__ticksPerFullDay();
    }

    private void define_ticksInDaytime() {
        LibConfig.TICKS_IN_DAYTIME.val = this._spec.comment("[INTERNAL] Set to the number of ticks associated with the day portion of a day-night cycle in game including both dawn and dusk portions. Alter this value for testing only as setting it does NOT change the actual game clock.").define(LibConfig.TICKS_IN_DAYTIME.PROPERTY, (Object)((Integer)LibConfig.TICKS_IN_DAYTIME.DFLT));
    }

    public static final int __ticksInDaytime() {
        int num = TICKS_IN_DAYTIME.value();
        return num <= 0 ? SharedGlue.DEFAULT_TICKS_DAY_TIME() : num;
    }

    public static final int __ticksInDaytime(@Nonnull RegistryKey<World> w) {
        return LibConfig.__ticksInDaytime();
    }

    private void define_ticksInDusk() {
        LibConfig.TICKS_IN_DUSK.val = this._spec.comment("[INTERNAL] Set to the number of ticks associated with dusk portion of a day-night cycle in game. Leave as-is to use 50s or 1000 ticks. Alter this value for testing only as setting it does NOT change the actual game clock.").define(LibConfig.TICKS_IN_DUSK.PROPERTY, (Object)((Integer)LibConfig.TICKS_IN_DUSK.DFLT));
    }

    public static final int __ticksInDusk() {
        int num = TICKS_IN_DUSK.value();
        return num <= 0 ? SharedGlue.DEFAULT_TICKS_TWILIGHT_TIME() : num;
    }

    private void define_ticksInDawn() {
        LibConfig.TICKS_IN_DAWN.val = this._spec.comment("[INTERNAL] Set to the number of ticks associated with dawn portion of a day-night cycle in game. Leave as-is to use 50s or 1000 ticks. Alter this value for testing only as setting it does NOT change the actual game clock.").define(LibConfig.TICKS_IN_DAWN.PROPERTY, (Object)((Integer)LibConfig.TICKS_IN_DAWN.DFLT));
    }

    public static final int __ticksInDawn() {
        int num = TICKS_IN_DAWN.value();
        return num <= 0 ? SharedGlue.DEFAULT_TICKS_TWILIGHT_TIME() : num;
    }

    private void define_day1TickOffset() {
        LibConfig.DAY1_TICKS_OFFSET.val = this._spec.comment("[INTERNAL] Set to the number of ticks to add as an offset on day one of world creation. Alter this value if you have an environment mod that \"shifts\" its first day to match some custom starting point (for example 'start on the last day of spring'). Do NOT change this value for an existing world; you will screw things up badly. Defaults to zero(0).").define(LibConfig.DAY1_TICKS_OFFSET.PROPERTY, (Object)((Integer)LibConfig.DAY1_TICKS_OFFSET.DFLT));
    }

    public static final int __day1TickOffset() {
        int num = DAY1_TICKS_OFFSET.value();
        return num < 0 ? 0 : num;
    }

    private void define_subseasonPerSeason() {
        LibConfig.SUBSEASONS_PER_SEASON.val = this._spec.comment("[INTERNAL] Set to the number of subseasons associated with a single full almanac season in game. Alter this value for debugging only; leave as-is to allow library to determine value from mods present. If no environment mods are present, defaults to 3; for example: 'early', 'mid', 'late' designations.").define(LibConfig.SUBSEASONS_PER_SEASON.PROPERTY, (Object)((Integer)LibConfig.SUBSEASONS_PER_SEASON.DFLT));
    }

    public static final int __subseasonsPerSeason(@Nonnull World w) {
        int num = SUBSEASONS_PER_SEASON.value();
        return num <= 0 ? 3 : num;
    }

    private void define_weeksPerSubseason() {
        LibConfig.WEEKS_PER_SUBSEASON.val = this._spec.comment("[INTERNAL] Set to the number of weeks associated with a single subseason in game. Note that each week consists of 7 full Minecraft days ALWAYS. Alter this value for debugging only; leave as-is to allow library to determine value from mods present. If no environment mods are present, defaults to 4 for a default season length of 84 Minecraft days for 3 subseasons.").define(LibConfig.WEEKS_PER_SUBSEASON.PROPERTY, (Object)((Integer)LibConfig.WEEKS_PER_SUBSEASON.DFLT));
    }

    public static final int __weeksPerSubseason(@Nonnull World w) {
        int num = WEEKS_PER_SUBSEASON.value();
        return num <= 0 ? 4 : num;
    }

    public static final int __daysPerSeason(@Nonnull World w) {
        Integer i = (Integer)LibConfig._sharedINSTANCE._cache.get("__days_per_season.resolved");
        if (i == null) {
            i = LibConfig.__subseasonsPerSeason(w) * LibConfig.__weeksPerSubseason(w) * 7;
            LibConfig._sharedINSTANCE._cache.put("__days_per_season.resolved", i);
        }
        return i;
    }

    private void define_seasonsPerAlmanacYear() {
        LibConfig.SEASONS_PER_ALMANAC_YEAR.val = this._spec.comment("[INTERNAL] Set to the number of seasons associated with a single full almanac year in game (overworld). Alter this value for debugging only; leave as-is to allow library to determine value from mods present. If no environment mods are present defaults to 4; for example: spring, summer, autumn, and winter. Does not affect the fixed single-season almanacs assigned to the Nether and the End.").define(LibConfig.SEASONS_PER_ALMANAC_YEAR.PROPERTY, (Object)((Integer)LibConfig.SEASONS_PER_ALMANAC_YEAR.DFLT));
    }

    public static final int __seasonsPerAlmanacYear(@Nonnull World w) {
        int num = SEASONS_PER_ALMANAC_YEAR.value();
        return num <= 0 ? 4 : num;
    }

    public static final int __daysPerAlmanacYear(@Nullable World w) {
        String resolvedKey = "__days_per_year." + LibConfig.DTKey(w) + ".resolved";
        Integer i = (Integer)LibConfig._sharedINSTANCE._cache.get(resolvedKey);
        if (i == null) {
            i = LibConfig.__daysPerSeason(w) * LibConfig.__seasonsPerAlmanacYear(w);
            LibConfig._sharedINSTANCE._cache.put(resolvedKey, i);
        }
        return i;
    }

    @Nonnull
    public static final String getPreferredAlmanacImpl() {
        return FALLBACK_ALMANAC_IMPL.value();
    }

    private void define_preferredAlmanacImpl() {
        LibConfig.FALLBACK_ALMANAC_IMPL.val = this._spec.comment("[INTERNAL] Set to the preferred almanac computation algo when a season-providing mod is NOT present. Allowed values are 'config'(default), '84x4', 'biome', and 'disabled'").define(LibConfig.FALLBACK_ALMANAC_IMPL.PROPERTY, (Object)((String)LibConfig.FALLBACK_ALMANAC_IMPL.DFLT));
    }

    @Nonnull
    static final ModIntegration __getPreferredImpl(String feature, ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> PREFERRED_IMPL_OPTION) {
        String resolvedKey = "__" + feature + "_impl.resolved";
        ModIntegration mod = (ModIntegration)((Object)LibConfig._sharedINSTANCE._cache.get(resolvedKey));
        if (mod != null) {
            return mod;
        }
        String modid = PREFERRED_IMPL_OPTION.value();
        mod = Strings.isNoneValue(modid, true) ? ModIntegration.MINECRAFT : (Strings.isDefaultValue(modid) ? ModIntegration.CARROTS_LIB : ModIntegration.get(modid));
        if (mod == null) {
            mod = ModIntegration.MINECRAFT;
        }
        LibConfig._sharedINSTANCE._cache.put(resolvedKey, mod);
        return mod;
    }

    private void define_preferredBaublesImpl() {
        LibConfig.PREFERRED_BAUBLES_IMPL.val = this._spec.comment("Set to your preferred baubles mod's id. Note that if this value is defined and the named mod is not present but another baubles mod is, that other mod will NOT be used. If you want to disable mod integration, set this value to \"*NONE*\". Leave the value as \"*DEFAULT*\" to have the library bind to any mod it recognizes (Curios,Baubles Reborn). Affects auto-integration of all library-dependent mods.").define(LibConfig.PREFERRED_BAUBLES_IMPL.PROPERTY, (Object)((String)LibConfig.PREFERRED_BAUBLES_IMPL.DFLT));
    }

    public static final boolean allowBaublesAutoIntegration() {
        return !Strings.isNoneValue(PREFERRED_BAUBLES_IMPL.value());
    }

    public static final boolean integrateWithBaublesMods() {
        return LibConfig.allowBaublesAutoIntegration() && BaublesHelper.isAnyExtensionPresent();
    }

    @Nonnull
    public static final ModIntegration getPreferredBaublesImpl() {
        return LibConfig.__getPreferredImpl("baubles", PREFERRED_BAUBLES_IMPL);
    }

    private void define_preferredWellnessAndSurivalImpl() {
        LibConfig.PREFERRED_SURVIVAL_IMPL.val = this._spec.comment("Set to your preferred survival mod's id. Note that if this value is defined and the named mod is not present but another survival mod is, that other mod will NOT be used. If you want to disable mod integration, set this value to \"*NONE*\". Leave the value as \"*DEFAULT*\" to have the library bind to any mod it recognizes (Survive). Affects auto-integration of all library-dependent mods.").define(LibConfig.PREFERRED_SURVIVAL_IMPL.PROPERTY, (Object)((String)LibConfig.PREFERRED_SURVIVAL_IMPL.DFLT));
    }

    public static final boolean allowWellbeingAutoIntegration() {
        return !Strings.isNoneValue(PREFERRED_SURVIVAL_IMPL.value());
    }

    public static final boolean integrateWithSurvivalMods() {
        return LibConfig.allowWellbeingAutoIntegration() && WellnessHelper.isAnyExtensionPresent();
    }

    @Nonnull
    public static final ModIntegration getPreferredSurvivalImpl() {
        return LibConfig.__getPreferredImpl("survival", PREFERRED_SURVIVAL_IMPL);
    }

    private void define_preferredClimateEnvironImpl() {
        LibConfig.PREFERRED_ENVIRON_IMPL.val = this._spec.comment("Set to your preferred environment or climate mod's id. Note that if this value is defined and the named mod is not present but another similar mod is, that other mod will NOT be used. If you want to disable mod integration, set this value to \"*NONE*\". Leave the value as \"*DEFAULT*\" to have the library bind to any mod it recognizes (Serene Seasons). Affects auto-integration of all library-dependent mods.").define(LibConfig.PREFERRED_ENVIRON_IMPL.PROPERTY, (Object)((String)LibConfig.PREFERRED_ENVIRON_IMPL.DFLT));
    }

    @Nonnull
    public static final ModIntegration getPreferredEnvironImpl() {
        return LibConfig.__getPreferredImpl("climate", PREFERRED_SURVIVAL_IMPL);
    }

    public static final boolean neutralPotionsEffectivelyBad() {
        return NEUTRAL_POTIONS_BAD.value();
    }

    private void define_neutralPotionsEffectivelyBad() {
        LibConfig.NEUTRAL_POTIONS_BAD.val = this._spec.comment("Set to true to consider neutral potions as 'bad' for certain operations; for example, when blanket clearing harmful effects with antidotes or in selection of random potion effects. Affects all library-dependent mods.").define(LibConfig.NEUTRAL_POTIONS_BAD.PROPERTY, NEUTRAL_POTIONS_BAD);
    }

    public static final boolean sharedEffectIsVisible() {
        return SHARED_POTIONS_SHOWN.value();
    }

    private void define_sharedEffectIsVisible() {
        LibConfig.SHARED_POTIONS_SHOWN.val = this._spec.comment("Set to true to make shared buffs visible to recipients in their HUD. Note that whether the effect is actually visible may depend on the other mods present.").define(LibConfig.SHARED_POTIONS_SHOWN.PROPERTY, SHARED_POTIONS_SHOWN);
    }

    public static final boolean hardcoreSurvivalMechanics() {
        return EXTRA_SURVIVAL_MECHANICS.value();
    }

    private void define_hardcoreSurvivalMechanics() {
        LibConfig.EXTRA_SURVIVAL_MECHANICS.val = this._spec.comment("Set to true to add a few more difficulty tweaks to some survival mod mechanics (eg make thirst matter). Ignored if auto-integration with survival mods disabled. Affects all library-dependent mods.").define(LibConfig.EXTRA_SURVIVAL_MECHANICS.PROPERTY, EXTRA_SURVIVAL_MECHANICS);
    }

    public static final boolean fairplayPVP() {
        return FAIRPLAY_PVP.value();
    }

    public static final boolean playersAreFriends(boolean preferredValue) {
        return true;
    }

    private void define_fairplayPVP() {
        LibConfig.FAIRPLAY_PVP.val = this._spec.comment("Set to true to use fair play settings wherever appropriate (for example could disable x-ray potion effects or insta-kill weapons or certain enchantments in multi-player environments). Defaults OFF (anything goes!)").define(LibConfig.FAIRPLAY_PVP.PROPERTY, FAIRPLAY_PVP);
    }

    public static final boolean allowFightingFoods() {
        return LibConfig._getBooleanOrDefault(FIGHTING_FOODS.value(), !LibConfig.getInstance()._DISABLE_FIGHTING_FOOD_EFFECTS);
    }

    public static final boolean allowFightingFoods(String modConfig, boolean modPreferredValue) {
        FlexibleBoolean b = LibConfig._getFlexibleOrNull(modConfig);
        if (FlexibleBoolean.isDefined(b)) {
            return b.asbool();
        }
        return LibConfig._getBooleanOrDefault(FIGHTING_FOODS.value(), modPreferredValue);
    }

    private void define_allowFightingFoods() {
        LibConfig.FIGHTING_FOODS.val = this._spec.comment("Set to 'false' to remove or disable automatic application of nourishment related 'xxx Fed' buffs from consuming food or drink. Note that the underlying effects are still defined and available for use in data packs even if this option is set 'false'; the option only affects how the library and dependent mods like Vanilla Food Pantry and Super Buckets use those effects. Does not impact custom effects like Muscle Boost.").define(LibConfig.FIGHTING_FOODS.PROPERTY, (Object)((String)LibConfig.FIGHTING_FOODS.DFLT));
    }

    public static final boolean allowFoodToFuel(String modConfig, boolean modPreferredValue) {
        FlexibleBoolean b = LibConfig._getFlexibleOrNull(modConfig);
        if (FlexibleBoolean.isDefined(b)) {
            return b.asbool();
        }
        return LibConfig._getBooleanOrDefault(FOOD_TO_FUEL.value(), modPreferredValue);
    }

    private void define_allowFoodToFuel() {
        LibConfig.FOOD_TO_FUEL.val = this._spec.comment("Set to 'false' to disable ability to process food items into a simple charcoal substitute. Affects features within mods like Vanilla Food Pantry, Super Blocks, and Smart Hoppers.").define(LibConfig.FOOD_TO_FUEL.PROPERTY, (Object)((String)LibConfig.FOOD_TO_FUEL.DFLT));
    }

    public static final int getMaxDistanceEffectRange() {
        return MathHelper.func_76125_a((int)SHARED_EFFECTS_MAX_DISTANCE.value(), (int)0, (int)32);
    }

    public static final int getCloseProximityEffectRange() {
        int n = LibConfig.getMaxDistanceEffectRange();
        return MathHelper.func_76125_a((int)n, (int)0, (int)Math.min(n / 2, 4));
    }

    public static final boolean canShareEffects() {
        return LibConfig.getMaxDistanceEffectRange() > 0;
    }

    private void define_sharedEffectsMaxDistance() {
        LibConfig.SHARED_EFFECTS_MAX_DISTANCE.val = this._spec.comment("Set to the max block distance a recipient entity for a far-reaching shared effect can be from the source. Primarily used for food-related buffs but can also apply to (de)buffs, campfires, and similar items. Set to 0 to disable sharing of all effects for library and dependent mods.").defineInRange(LibConfig.SHARED_EFFECTS_MAX_DISTANCE.PROPERTY, ((Integer)LibConfig.SHARED_EFFECTS_MAX_DISTANCE.DFLT).intValue(), 0, 32);
    }

    private final void define_almanacTrackedWorldTypes() {
        LibConfig.ALMANAC_TRACKED.val = this._spec.comment("List of non-standard world types for which almanac tracking is done if that feature is enabled. Ignored unless almanacs have been enabled by at least one dependent mod. Tracking is ALWAYS done for the three standard Minecraft dimensions (overworld, the nether, the end). Requires a restart if changed.").defineList(LibConfig.ALMANAC_TRACKED.PROPERTY, (List)LibConfig.ALMANAC_TRACKED.DFLT, IS_NONEMPTY_STRING);
    }

    public static final boolean isAlmanacTracked(@Nonnull RegistryKey<World> world_id) {
        if (!LibConfig.includeAlmanacTracking()) {
            return false;
        }
        if (world_id == World.field_234918_g_ || world_id == World.field_234919_h_ || world_id == World.field_234920_i_) {
            return true;
        }
        ResourceLocation rid = world_id.func_240901_a_();
        return ALMANAC_TRACKED.value().contains(rid.func_110624_b()) || ALMANAC_TRACKED.value().contains(rid.toString());
    }

    @Override
    protected void fullyDefineInternal() {
        this.define_version();
        this._spec.push(_GENERAL).worldRestart();
        this.define_isDebugMode();
        this._spec.pop();
        this._spec.comment(" Used to control how the library and dependent mods work with other thirdparty mods.");
        this._spec.push(_INTEGRATION).worldRestart();
        this.define_allowForgeMilk();
        this.define_fairplayPVP();
        this.define_neutralPotionsEffectivelyBad();
        this.define_sharedEffectIsVisible();
        this.define_preferredBaublesImpl();
        this.define_preferredClimateEnvironImpl();
        this.define_preferredWellnessAndSurivalImpl();
        this.define_hardcoreSurvivalMechanics();
        this.define_allowFightingFoods();
        this.define_allowFoodToFuel();
        this.define_sharedEffectsMaxDistance();
        this.define_almanacTrackedWorldTypes();
        this._spec.pop();
        this._spec.comment(new String[]{" Used to diagnose farming and fishing almanacs and advancements within dependent mods. INTERNAL.", " Does not affect the fixed psuedo-season of the Nether or the End (a single 336-day long season)"});
        this._spec.push(_ALMANAC).worldRestart();
        this.define_ticksPerFullDay();
        this.define_ticksInDaytime();
        this.define_ticksInDawn();
        this.define_ticksInDusk();
        this.define_preferredAlmanacImpl();
        this.define_subseasonPerSeason();
        this.define_weeksPerSubseason();
        this.define_seasonsPerAlmanacYear();
        this.define_day1TickOffset();
        this._spec.pop();
    }

    @Override
    public void setRecipeFlagsEarly() {
        super.setRecipeFlagsEarly();
        LibConfig.__daysPerAlmanacYear(null);
    }

    static {
        OMITTED_FROM_RANDOM_ENCHANTS = RID.Tags.forEnchantment(LibInfo.rstring("random_enchants_denylist"));
        __IDE_ENVIRONMENT = "ide".equals(System.getenv("MOD_RUNMODE"));
        DEBUG_MODE = new ModConfigBase.Option("debug_mode", false);
        ENABLE_FORGE_MILK = new ModConfigBase.Option("forge_milkfluid", true);
        TICKS_PER_FULLDAY = new ModConfigBase.Option("ticks_per_fullday", -1);
        TICKS_IN_DAYTIME = new ModConfigBase.Option("ticks_in_daytime", -1);
        TICKS_IN_DUSK = new ModConfigBase.Option("ticks_in_dusk", -1);
        TICKS_IN_DAWN = new ModConfigBase.Option("ticks_in_dawn", -1);
        DAY1_TICKS_OFFSET = new ModConfigBase.Option("day1_ticks_offset", -1);
        SUBSEASONS_PER_SEASON = new ModConfigBase.Option("subseasons_per_season", -1);
        WEEKS_PER_SUBSEASON = new ModConfigBase.Option("weeks_per_subseason", -1);
        SEASONS_PER_ALMANAC_YEAR = new ModConfigBase.Option("seasons_per_year", -1);
        FALLBACK_ALMANAC_IMPL = new ModConfigBase.Option("fallback_impl", "*DEFAULT*");
        PREFERRED_BAUBLES_IMPL = new ModConfigBase.Option("baubles_mod_used", "*DEFAULT*");
        PREFERRED_SURVIVAL_IMPL = new ModConfigBase.Option("survival_mod_used", "*DEFAULT*");
        PREFERRED_ENVIRON_IMPL = new ModConfigBase.Option("environ_mod_used", "*DEFAULT*");
        NEUTRAL_POTIONS_BAD = new ModConfigBase.Option("neutral_effects_bad", false);
        SHARED_POTIONS_SHOWN = new ModConfigBase.Option("shared_effects_shown", false);
        EXTRA_SURVIVAL_MECHANICS = new ModConfigBase.Option("more_survival_tweaks", false);
        FAIRPLAY_PVP = new ModConfigBase.Option("fairplay_pvp", false);
        FIGHTING_FOODS = new ModConfigBase.Option("fighting_foods", "*DEFAULT*");
        FOOD_TO_FUEL = new ModConfigBase.Option("food_to_fuel", "*DEFAULT*");
        SHARED_EFFECTS_MAX_DISTANCE = new ModConfigBase.Option("shared_effects_max_reach", 8);
        ALMANAC_TRACKED = new ModConfigBase.Option("almanac_tracked_dims", Arrays.asList("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"));
    }
}

